/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.log.model.document;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.data.elasticsearch.annotations.Field;

public class OperationLogDocument {
    @Field(name="id")
    private String id;
    @Field(name="triggerTerminal")
    private String triggerTerminal;
    @Field(name="sysModel")
    private String sysModel;
    @Field(name="operationType")
    private String operationType;
    @Field(name="operationUser")
    private String operationUser;
    @Field(name="operationUrl")
    private String operationUrl;
    @Field(name="@timestamp")
    private LocalDateTime timestamp;
    @Field(name="operationTime", pattern={"yyyy-MM-dd HH:mm:ss"})
    private String operationTime;
    @Field(name="operationIp")
    private String operationIp;
    @Field(name="operationStatus")
    private String operationStatus;
    @Field(name="requestParam")
    private String requestParam;
    @Field(name="responseParam")
    private String responseParam;
    @Field(name="logId")
    private String logId;
    @Field(name="requestMethod")
    private String requestMethod;
    @Field(name="exceptionDesc")
    private String exceptionDesc;
    private LocalDateTime operationDateTime;

    public LocalDateTime getOperationDateTime() {
        if (this.operationTime != null) {
            if (this.operationTime.length() > 19) {
                this.operationTime = this.operationTime.substring(0, 19);
            }
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            try {
                this.operationDateTime = LocalDateTime.parse(this.operationTime, pattern);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.operationDateTime;
    }

    public String getId() {
        return this.id;
    }

    public String getTriggerTerminal() {
        return this.triggerTerminal;
    }

    public String getSysModel() {
        return this.sysModel;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getOperationUser() {
        return this.operationUser;
    }

    public String getOperationUrl() {
        return this.operationUrl;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getOperationTime() {
        return this.operationTime;
    }

    public String getOperationIp() {
        return this.operationIp;
    }

    public String getOperationStatus() {
        return this.operationStatus;
    }

    public String getRequestParam() {
        return this.requestParam;
    }

    public String getResponseParam() {
        return this.responseParam;
    }

    public String getLogId() {
        return this.logId;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getExceptionDesc() {
        return this.exceptionDesc;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTriggerTerminal(String triggerTerminal) {
        this.triggerTerminal = triggerTerminal;
    }

    public void setSysModel(String sysModel) {
        this.sysModel = sysModel;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setOperationUser(String operationUser) {
        this.operationUser = operationUser;
    }

    public void setOperationUrl(String operationUrl) {
        this.operationUrl = operationUrl;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setOperationTime(String operationTime) {
        this.operationTime = operationTime;
    }

    public void setOperationIp(String operationIp) {
        this.operationIp = operationIp;
    }

    public void setOperationStatus(String operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public void setResponseParam(String responseParam) {
        this.responseParam = responseParam;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setExceptionDesc(String exceptionDesc) {
        this.exceptionDesc = exceptionDesc;
    }

    public void setOperationDateTime(LocalDateTime operationDateTime) {
        this.operationDateTime = operationDateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationLogDocument)) {
            return false;
        }
        OperationLogDocument other = (OperationLogDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$triggerTerminal = this.getTriggerTerminal();
        String other$triggerTerminal = other.getTriggerTerminal();
        if (this$triggerTerminal == null ? other$triggerTerminal != null : !this$triggerTerminal.equals(other$triggerTerminal)) {
            return false;
        }
        String this$sysModel = this.getSysModel();
        String other$sysModel = other.getSysModel();
        if (this$sysModel == null ? other$sysModel != null : !this$sysModel.equals(other$sysModel)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        String this$operationUser = this.getOperationUser();
        String other$operationUser = other.getOperationUser();
        if (this$operationUser == null ? other$operationUser != null : !this$operationUser.equals(other$operationUser)) {
            return false;
        }
        String this$operationUrl = this.getOperationUrl();
        String other$operationUrl = other.getOperationUrl();
        if (this$operationUrl == null ? other$operationUrl != null : !this$operationUrl.equals(other$operationUrl)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$operationTime = this.getOperationTime();
        String other$operationTime = other.getOperationTime();
        if (this$operationTime == null ? other$operationTime != null : !this$operationTime.equals(other$operationTime)) {
            return false;
        }
        String this$operationIp = this.getOperationIp();
        String other$operationIp = other.getOperationIp();
        if (this$operationIp == null ? other$operationIp != null : !this$operationIp.equals(other$operationIp)) {
            return false;
        }
        String this$operationStatus = this.getOperationStatus();
        String other$operationStatus = other.getOperationStatus();
        if (this$operationStatus == null ? other$operationStatus != null : !this$operationStatus.equals(other$operationStatus)) {
            return false;
        }
        String this$requestParam = this.getRequestParam();
        String other$requestParam = other.getRequestParam();
        if (this$requestParam == null ? other$requestParam != null : !this$requestParam.equals(other$requestParam)) {
            return false;
        }
        String this$responseParam = this.getResponseParam();
        String other$responseParam = other.getResponseParam();
        if (this$responseParam == null ? other$responseParam != null : !this$responseParam.equals(other$responseParam)) {
            return false;
        }
        String this$logId = this.getLogId();
        String other$logId = other.getLogId();
        if (this$logId == null ? other$logId != null : !this$logId.equals(other$logId)) {
            return false;
        }
        String this$requestMethod = this.getRequestMethod();
        String other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        String this$exceptionDesc = this.getExceptionDesc();
        String other$exceptionDesc = other.getExceptionDesc();
        if (this$exceptionDesc == null ? other$exceptionDesc != null : !this$exceptionDesc.equals(other$exceptionDesc)) {
            return false;
        }
        LocalDateTime this$operationDateTime = this.getOperationDateTime();
        LocalDateTime other$operationDateTime = other.getOperationDateTime();
        return !(this$operationDateTime == null ? other$operationDateTime != null : !((Object)this$operationDateTime).equals(other$operationDateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationLogDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $triggerTerminal = this.getTriggerTerminal();
        result = result * 59 + ($triggerTerminal == null ? 43 : $triggerTerminal.hashCode());
        String $sysModel = this.getSysModel();
        result = result * 59 + ($sysModel == null ? 43 : $sysModel.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        String $operationUser = this.getOperationUser();
        result = result * 59 + ($operationUser == null ? 43 : $operationUser.hashCode());
        String $operationUrl = this.getOperationUrl();
        result = result * 59 + ($operationUrl == null ? 43 : $operationUrl.hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $operationTime = this.getOperationTime();
        result = result * 59 + ($operationTime == null ? 43 : $operationTime.hashCode());
        String $operationIp = this.getOperationIp();
        result = result * 59 + ($operationIp == null ? 43 : $operationIp.hashCode());
        String $operationStatus = this.getOperationStatus();
        result = result * 59 + ($operationStatus == null ? 43 : $operationStatus.hashCode());
        String $requestParam = this.getRequestParam();
        result = result * 59 + ($requestParam == null ? 43 : $requestParam.hashCode());
        String $responseParam = this.getResponseParam();
        result = result * 59 + ($responseParam == null ? 43 : $responseParam.hashCode());
        String $logId = this.getLogId();
        result = result * 59 + ($logId == null ? 43 : $logId.hashCode());
        String $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        String $exceptionDesc = this.getExceptionDesc();
        result = result * 59 + ($exceptionDesc == null ? 43 : $exceptionDesc.hashCode());
        LocalDateTime $operationDateTime = this.getOperationDateTime();
        result = result * 59 + ($operationDateTime == null ? 43 : ((Object)$operationDateTime).hashCode());
        return result;
    }

    public String toString() {
        return "OperationLogDocument(id=" + this.getId() + ", triggerTerminal=" + this.getTriggerTerminal() + ", sysModel=" + this.getSysModel() + ", operationType=" + this.getOperationType() + ", operationUser=" + this.getOperationUser() + ", operationUrl=" + this.getOperationUrl() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", operationTime=" + this.getOperationTime() + ", operationIp=" + this.getOperationIp() + ", operationStatus=" + this.getOperationStatus() + ", requestParam=" + this.getRequestParam() + ", responseParam=" + this.getResponseParam() + ", logId=" + this.getLogId() + ", requestMethod=" + this.getRequestMethod() + ", exceptionDesc=" + this.getExceptionDesc() + ", operationDateTime=" + String.valueOf(this.getOperationDateTime()) + ")";
    }
}

