/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.log.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.log.common.LogLevel;
import com.elitescloud.cloudt.log.model.document.LogStashDocument;
import com.elitescloud.cloudt.log.model.vo.param.LogStashQueryParam;
import com.elitescloud.cloudt.log.model.vo.resp.LogStashRecordRespVO;
import com.elitescloud.cloudt.log.service.LogStashService;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class LogStashServiceFilebeat
implements LogStashService {
    private static final Logger logger = LoggerFactory.getLogger(LogStashServiceFilebeat.class);
    private final RestHighLevelClient client;
    private final String preIndex;
    private ElasticsearchRestTemplate restTemplate;
    private String indexPrefix;
    private static final Class<LogStashDocument> DOCUMENT_CLASS = LogStashDocument.class;
    private static final DateTimeFormatter FORMATTER_INDEX = DateTimeFormatter.ofPattern("yyyy.MM.dd");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public LogStashServiceFilebeat(RestHighLevelClient client, String preIndex) {
        this.client = client;
        this.preIndex = preIndex;
        this.init();
    }

    @Override
    public ApiResult<PagingVO<LogStashRecordRespVO>> search(LogStashQueryParam queryParam) {
        SearchHits<LogStashDocument> searchHits = this.searchHits(queryParam);
        if (searchHits == null || !searchHits.hasSearchHits()) {
            PagingVO pagingVO = PagingVO.builder().total(searchHits == null ? 0L : searchHits.getTotalHits()).records(Collections.emptyList()).build();
            return ApiResult.ok((Object)pagingVO);
        }
        List records = searchHits.get().map(t -> {
            LogStashDocument document = (LogStashDocument)t.getContent();
            LogStashRecordRespVO vo = new LogStashRecordRespVO();
            vo.setPreIndex(document.getPreIndex());
            vo.setAppName(document.getAppName());
            vo.setLogLevel(document.getLevel());
            vo.setMsg(document.getMsg());
            vo.setTime(LocalDateTime.parse(document.getTime(), FORMATTER));
            vo.setMessage(document.getMessage());
            return vo;
        }).sorted(Comparator.comparing(LogStashRecordRespVO::getTime).reversed()).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(searchHits.getTotalHits()).records(records).build());
    }

    @Override
    public ApiResult<List<String>> logLevelList() {
        List levelNames = Arrays.stream(LogLevel.values()).map(Enum::name).collect(Collectors.toList());
        return ApiResult.ok(levelNames);
    }

    @Override
    public ApiResult<List<String>> appNameList(Integer size, LocalDateTime start, LocalDateTime end) {
        IndexCoordinates indexCoordinates = null;
        try {
            indexCoordinates = this.obtainIndexCoordinates(start, end);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        if (indexCoordinates == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<String> appNameList = this.searchAppName(indexCoordinates, size);
        return ApiResult.ok(appNameList);
    }

    private List<String> searchAppName(IndexCoordinates indexCoordinates, Integer size) {
        List aggList;
        TermsValuesSourceBuilder valuesSourceBuilder = (TermsValuesSourceBuilder)new TermsValuesSourceBuilder("appName").field("app.name.keyword");
        CompositeAggregationBuilder aggregationBuilder = new CompositeAggregationBuilder("appName_bucket", List.of(valuesSourceBuilder));
        aggregationBuilder.size(((Integer)ObjectUtil.defaultIfNull((Object)size, (Object)20)).intValue());
        NativeSearchQuery nativeSearch = new NativeSearchQueryBuilder().withAggregations(new AbstractAggregationBuilder[]{aggregationBuilder}).build();
        nativeSearch.setMaxResults(Integer.valueOf(0));
        SearchHits searchHits = null;
        try {
            searchHits = this.restTemplate.search((Query)nativeSearch, DOCUMENT_CLASS, indexCoordinates);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        ElasticsearchAggregations aggregation = (ElasticsearchAggregations)searchHits.getAggregations();
        List list = aggList = aggregation == null ? null : aggregation.aggregations().asList();
        if (CollectionUtils.isEmpty((Collection)aggList)) {
            return Collections.emptyList();
        }
        return aggList.stream().flatMap(agg -> ((CompositeAggregation)agg).getBuckets().stream().map(t -> t.getKey().get("appName").toString())).collect(Collectors.toList());
    }

    private SearchHits<LogStashDocument> searchHits(LogStashQueryParam queryParam) {
        NativeSearchQueryBuilder queryBuilder = this.buildQueryBuilder(queryParam);
        this.withPageable(queryBuilder, queryParam);
        this.withSort(queryBuilder);
        IndexCoordinates indexCoordinates = null;
        try {
            indexCoordinates = this.obtainIndexCoordinates(queryParam.getStartTime(), queryParam.getEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        if (indexCoordinates == null) {
            return null;
        }
        try {
            return this.restTemplate.search((Query)queryBuilder.build(), DOCUMENT_CLASS, indexCoordinates);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    private IndexCoordinates obtainIndexCoordinates(LocalDateTime startTime, LocalDateTime endTime) {
        if (startTime == null && endTime == null) {
            return IndexCoordinates.of((String[])new String[]{this.convertIndex(LocalDateTime.now())});
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = null;
        end = endTime == null || endTime.isAfter(now) ? now.with(LocalTime.MAX) : endTime.with(LocalTime.MAX);
        Object[] indexNames = (String[])Stream.iterate(startTime == null ? LocalDateTime.now() : startTime, end::isAfter, f -> f.plusDays(1L)).map(this::convertIndex).filter(this::existsIndex).toArray(String[]::new);
        if (indexNames.length == 0) {
            logger.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7d22\u5f15\u5b58\u5728");
            return null;
        }
        logger.info("\u65e5\u5fd7\u67e5\u8be2\u7d22\u5f15\uff1a{}", (Object)Arrays.toString(indexNames));
        return IndexCoordinates.of((String[])indexNames);
    }

    private String convertIndex(LocalDateTime date) {
        return this.indexPrefix + date.format(FORMATTER_INDEX);
    }

    private void withSort(NativeSearchQueryBuilder queryBuilder) {
        queryBuilder.withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"@timestamp").order(SortOrder.DESC)});
    }

    private void withPageable(NativeSearchQueryBuilder queryBuilder, LogStashQueryParam queryParam) {
        int page = Math.max((Integer)ObjectUtil.defaultIfNull((Object)queryParam.getPage(), (Object)1) - 1, 0);
        int pageSize = Math.max((Integer)ObjectUtil.defaultIfNull((Object)queryParam.getPageSize(), (Object)20), 1);
        queryBuilder.withPageable((Pageable)PageRequest.of((int)page, (int)pageSize));
    }

    private NativeSearchQueryBuilder buildQueryBuilder(LogStashQueryParam queryParam) {
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        if (StrUtil.isNotBlank((CharSequence)queryParam.getAppName())) {
            filter.must((QueryBuilder)QueryBuilders.termsQuery((String)"app.name.keyword", (String[])new String[]{queryParam.getAppName()}));
        }
        if (queryParam.getLogLevel() != null) {
            filter.must((QueryBuilder)QueryBuilders.termsQuery((String)"level.keyword", (Object[])new Object[]{queryParam.getLogLevel()}));
        } else if (queryParam.getLogLevelMin() != null && queryParam.getLogLevelMin() != LogLevel.TRACE) {
            filter.must((QueryBuilder)QueryBuilders.termsQuery((String)"level.keyword", this.getLogLevels(queryParam.getLogLevelMin())));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParam.getTraceId())) {
            filter.must((QueryBuilder)QueryBuilders.termsQuery((String)"traceId.keyword", (String[])new String[]{queryParam.getTraceId()}));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParam.getThreadId())) {
            filter.must((QueryBuilder)QueryBuilders.termsQuery((String)"thread.keyword", (String[])new String[]{queryParam.getThreadId()}));
        }
        if (queryParam.getStartTime() != null || queryParam.getEndTime() != null) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"@timestamp");
            if (queryParam.getStartTime() != null) {
                rangeQuery.from((Object)queryParam.getStartTime());
            }
            if (queryParam.getEndTime() != null) {
                rangeQuery.to((Object)queryParam.getEndTime());
            }
            filter.must((QueryBuilder)rangeQuery);
        }
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        queryBuilder.withFilter((QueryBuilder)filter);
        if (StrUtil.isNotBlank((CharSequence)queryParam.getKeyword())) {
            queryBuilder.withQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"msg", (Object)queryParam.getKeyword())));
            LogStashQueryParam.Highlight highlight = queryParam.getHighlight();
            if (highlight != null && StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{highlight.getPreTag(), highlight.getPostTag()})) {
                HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)new HighlightBuilder().field("message").preTags(new String[]{highlight.getPreTag()})).postTags(new String[]{highlight.getPostTag()});
                queryBuilder.withHighlightBuilder(highlightBuilder);
            }
        }
        return queryBuilder;
    }

    private boolean existsIndex(String indexName) {
        return this.restTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).exists();
    }

    private List<LogLevel> getLogLevels(LogLevel min) {
        switch (min) {
            case TRACE: {
                return List.of(LogLevel.TRACE, LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR, LogLevel.FATAL, LogLevel.OFF);
            }
            case DEBUG: {
                return List.of(LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR, LogLevel.FATAL, LogLevel.OFF);
            }
            case INFO: {
                return List.of(LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR, LogLevel.FATAL, LogLevel.OFF);
            }
            case WARN: {
                return List.of(LogLevel.WARN, LogLevel.ERROR, LogLevel.FATAL, LogLevel.OFF);
            }
            case ERROR: {
                return List.of(LogLevel.ERROR, LogLevel.FATAL, LogLevel.OFF);
            }
            case FATAL: {
                return List.of(LogLevel.FATAL, LogLevel.OFF);
            }
            case OFF: {
                return List.of(LogLevel.OFF);
            }
        }
        throw new BusinessException("\u672a\u77e5\u7684\u65e5\u5fd7\u7ea7\u522b");
    }

    private void init() {
        if (this.client == null) {
            logger.error("\u65e5\u5fd7\u67e5\u8be2\u7ec4\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684Elasticsearch Client");
            return;
        }
        this.indexPrefix = "filebeat-" + (String)(CharSequenceUtil.isBlank((CharSequence)this.preIndex) ? "" : this.preIndex + "-");
        this.restTemplate = new ElasticsearchRestTemplate(this.client);
        this.restTemplate.setEntityCallbacks(new EntityCallbacks(){

            public void addEntityCallback(@NonNull EntityCallback<?> callback) {
            }

            @NonNull
            public <T> T callback(@NonNull Class<? extends EntityCallback> callbackType, @NonNull T entity, Object ... args) {
                Document document = (Document)args[0];
                ((LogStashDocument)entity).setAppName(document.getString("app.name"));
                return entity;
            }
        });
    }
}

