/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.cas.provider.ThirdPartyAccountTransferHelper;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.system.cas.SystemLoginCallback;
import com.elitescloud.cloudt.system.cas.SystemUserDetailManager;
import com.elitescloud.cloudt.system.cas.SystemUserSyncProvider;
import com.elitescloud.cloudt.system.cas.ThirdPartyAccountChangedCallbackCas;
import com.elitescloud.cloudt.system.cas.UserChangedCallbackCas;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class SystemCasConfig {
    SystemCasConfig() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={UserDetailManager.class})
    static class AuthProviderConfig {
        private final AuthorizationProperties authorizationProperties;

        public AuthProviderConfig(AuthorizationProperties authorizationProperties) {
            this.authorizationProperties = authorizationProperties;
        }

        @Bean
        public UserDetailManager userDetailManagerSystemSelf(UserQueryService userQueryService, UserMngManager userMngManager) {
            return new SystemUserDetailManager(this.authorizationProperties, userQueryService, userMngManager);
        }

        @Bean
        public AuthenticationCallable authenticationCallableSystemLogin(UserMngService userMngService) {
            return new SystemLoginCallback(userMngService);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="elitesland.authorization.sdk.cas-client", name={"enabled"}, havingValue="true")
    static class CasProviderConfig {
        private final AuthorizationSdkProperties sdkProperties;

        public CasProviderConfig(AuthorizationSdkProperties sdkProperties) {
            this.sdkProperties = sdkProperties;
        }

        @Bean
        public UserSourceProvider sourceProvider() {
            return new SystemUserSyncProvider();
        }

        @Bean
        public UserTransferHelper userTransferHelper() {
            return UserTransferHelper.getInstance((String)this.sdkProperties.getAuthServer());
        }

        @Bean
        public UserChangedCallbackCas userChangedCallbackCas(UserTransferHelper userTransferHelper) {
            return new UserChangedCallbackCas(this.sdkProperties, userTransferHelper);
        }

        @Bean
        public ThirdPartyAccountTransferHelper thirdPartyAccountTransferHelper() {
            return ThirdPartyAccountTransferHelper.getInstance((String)this.sdkProperties.getAuthServer());
        }

        @Bean
        public ThirdPartyAccountChangedCallbackCas thirdPartyAccountChangedCallbackCas(ThirdPartyAccountTransferHelper transferHelper) {
            return new ThirdPartyAccountChangedCallbackCas(transferHelper);
        }

        @Bean
        public PwdStrategyTransferHelper pwdStrategyTransferHelper() {
            return PwdStrategyTransferHelper.getInstance((String)this.sdkProperties.getAuthServer());
        }
    }
}

