/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.cas.model.thirdparty.WechatMiniProgramDTO;
import com.elitescloud.boot.auth.cas.model.thirdparty.WechatServiceDTO;
import com.elitescloud.boot.auth.cas.model.thirdparty.WechatSubscriptionDTO;
import com.elitescloud.boot.auth.cas.provider.ThirdPartyAccountTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.cloudt.system.service.ThirdPartAccountMngService;
import com.elitescloud.cloudt.system.service.callback.ThirdPartyAccountChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.entity.SysThirdPartyAccountDO;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepoProc;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;

class ThirdPartyAccountChangedCallbackCas
implements ThirdPartyAccountChangedCallback {
    private static final Logger log = LogManager.getLogger(ThirdPartyAccountChangedCallbackCas.class);
    @Autowired
    private ThirdPartAccountMngService mngService;
    @Autowired
    private ThirdPartyAccountRepoProc repoProc;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ObjectMapper objectMapper;
    private final ThirdPartyAccountTransferHelper helper;

    public ThirdPartyAccountChangedCallbackCas(ThirdPartyAccountTransferHelper thirdPartyAccountTransferHelper) {
        this.helper = thirdPartyAccountTransferHelper;
    }

    public void onUpsert(boolean add, SysThirdPartyAccountDO accountDO) {
        this.execute(() -> {
            if (accountDO == null) {
                return null;
            }
            this.upsertWechat(accountDO);
            return accountDO.getId();
        });
    }

    public void onEnabled(Long accountId, boolean enabled) {
        this.execute(() -> {
            Long casId = this.repoProc.getCasId(accountId);
            if (casId != null) {
                this.helper.updateEnabled(casId.longValue(), enabled);
                return accountId;
            }
            this.onUpsert(true, (SysThirdPartyAccountDO)this.repoProc.get(accountId));
            return accountId;
        });
    }

    public void onDelete(SysThirdPartyAccountDO accountDO) {
        this.execute(() -> {
            if (accountDO == null) {
                return null;
            }
            Long casId = accountDO.getCasId();
            if (casId != null) {
                this.helper.delete(casId.longValue());
                return accountDO.getId();
            }
            return accountDO.getId();
        });
    }

    private void upsertWechat(SysThirdPartyAccountDO accountDO) {
        String type = accountDO.getAccountType();
        Map config = null;
        try {
            config = (Map)this.objectMapper.readValue(accountDO.getConfigJson(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("\u8bfb\u53d6\u8d26\u53f7\u914d\u7f6e\u5f02\u5e38", e);
        }
        Result result = null;
        if (type.equals(ThirdPartAccountType.WECHAT_SERVICE.getValue())) {
            WechatServiceDTO dto = new WechatServiceDTO();
            dto.setId(accountDO.getCasId());
            dto.setAppId(accountDO.getAccount());
            dto.setAppSecret((String)config.get("appSecret"));
            dto.setName(accountDO.getName());
            dto.setEnabled(accountDO.getEnabled());
            result = this.helper.upsertWechatService(dto);
        } else if (type.equals(ThirdPartAccountType.WECHAT_MINI_APP.getValue())) {
            WechatMiniProgramDTO dto = new WechatMiniProgramDTO();
            dto.setId(accountDO.getCasId());
            dto.setAppId(accountDO.getAccount());
            dto.setAppSecret((String)config.get("appSecret"));
            dto.setName(accountDO.getName());
            dto.setEnabled(accountDO.getEnabled());
            result = this.helper.upsertWechatMiniProgram(dto);
        } else if (type.equals(ThirdPartAccountType.WECHAT_SUBSCRIPTION.getValue())) {
            WechatSubscriptionDTO dto = new WechatSubscriptionDTO();
            dto.setId(accountDO.getCasId());
            dto.setAppId(accountDO.getAccount());
            dto.setAppSecret((String)config.get("appSecret"));
            dto.setName(accountDO.getName());
            dto.setEnabled(accountDO.getEnabled());
            result = this.helper.upsertWechatSubscription(dto);
        } else {
            log.error("\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff1a{}", (Object)type);
            return;
        }
        if (Boolean.FALSE.equals(result.getSuccess())) {
            log.error("\u4fdd\u5b58\u7b2c\u4e09\u65b9\u8d26\u53f7\u5230\u7edf\u4e00\u8ba4\u8bc1\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)result.getMsg());
            return;
        }
        if (result.getData() != null && accountDO.getCasId() == null) {
            this.mngService.updateCasId(accountDO.getId(), (Long)result.getData());
        }
    }

    private void execute(Supplier<Long> supplier) {
        CompletableFuture.runAsync(supplier::get, (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u540c\u6b65\u7b2c\u4e09\u65b9\u8d26\u53f7\u5f02\u5e38\uff1a", e);
            }
        });
    }
}

