/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.common.system;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonAppInstanceRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.ServiceInstancesVo;
import com.elitescloud.cloudt.system.service.PlatformQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Api(tags={"\u5e73\u53f0\u901a\u7528\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/common/platform"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_Common:\u516c\u5171")
public class PlatformCommonController {
    private static final Logger log = LoggerFactory.getLogger(PlatformCommonController.class);
    private PlatformQueryService platformQueryService;
    private final DiscoveryClient discoveryClient;
    private final RestTemplate restTemplate;
    private static String OPENAPI_GET_JSON_URL = "/sys/openapi/get/json";
    private static String OPENAPI_DOWNLOAD_JSON_URL = "/sys/openapi/download/json";
    private static String UDC_LOCAL_CACHE_URL = "/cloudt/core/udc/clear/localCache";

    public PlatformCommonController(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
        this.restTemplate = RestTemplateFactory.instance();
    }

    @ApiOperation(value="\u7248\u672c\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/versions"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u7248\u672c\u5217\u8868")
    public ApiResult<List<CodeNameParam>> getVersionList() {
        return this.platformQueryService.listProjectVersion();
    }

    @Autowired
    public void setPlatformQueryService(PlatformQueryService platformQueryService) {
        this.platformQueryService = platformQueryService;
    }

    @ApiOperation(value="\u6ce8\u518c\u670d\u52a1\u6e05\u5355", hidden=true)
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/serviceInstances"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u6ce8\u518c\u670d\u52a1\u6e05\u5355")
    public ApiResult<List<ServiceInstancesVo>> printServiceInstances() {
        List services = this.discoveryClient.getServices();
        ArrayList servicesInstances = new ArrayList();
        for (String service : services) {
            this.discoveryClient.getInstances(service).forEach(instance -> {
                ServiceInstancesVo serviceInstancesVo = new ServiceInstancesVo();
                serviceInstancesVo.setServices(service);
                serviceInstancesVo.setServiceId(instance.getServiceId());
                serviceInstancesVo.setHost(instance.getHost());
                serviceInstancesVo.setPort(instance.getPort());
                serviceInstancesVo.setSecure(instance.isSecure());
                serviceInstancesVo.setUri(instance.getUri());
                servicesInstances.add(serviceInstancesVo);
            });
        }
        return ApiResult.ok(servicesInstances);
    }

    @ApiOperation(value="\u670d\u52a1\u5b9e\u4f8b\u5217\u8868")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1ID"), @ApiImplicitParam(name="appOnly", value="\u662f\u5426\u4ec5\u8fd4\u56de\u5e94\u7528\u5217\u8868\u4e2d\u7684", defaultValue="false")})
    @GetMapping(value={"/serviceInstance/list"})
    public ApiResult<List<CommonAppInstanceRespVO>> serviceInstanceList(@RequestParam(name="serviceId", required=false) String serviceId, @RequestParam(name="appOnly", required=false, defaultValue="false") Boolean appOnly) {
        return this.platformQueryService.serviceInstanceList(serviceId, appOnly);
    }

    @ApiOperation(value="\u672c\u5730\u8c03\u7528\u670d\u52a1\u7684openApi\u83b7\u53d6json\u63a5\u53e3")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/openapiGetJson"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="openApi\u67e5\u8be2")
    public ApiResult<Object> callOpenApiJsonDServiceInstances(String serviceName) {
        List instances = this.discoveryClient.getInstances(serviceName);
        if (instances.isEmpty()) {
            return ApiResult.fail((String)("\u5b9e\u4f8b\u6ce8\u518a\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u73af\u5883\uff1a" + serviceName));
        }
        StringBuffer errMessage = new StringBuffer();
        HttpHeaders headers = this.createHeadersFromCurrentRequest();
        HttpEntity entity = new HttpEntity((Object)"body", (MultiValueMap)headers);
        for (ServiceInstance serviceInstance : instances) {
            String url = serviceInstance.getUri().toString() + OPENAPI_GET_JSON_URL;
            try {
                log.info("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\uff1aurl={} serviceInstance={}", (Object)url, (Object)serviceInstance);
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
                log.info("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\uff1aurl {}  \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)url, (Object)response);
                return ApiResult.ok((Object)response.getBody());
            }
            catch (Exception e) {
                log.error("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: " + e.getMessage());
                errMessage.append("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: " + url + e.getMessage());
            }
        }
        return ApiResult.fail((String)("\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\u5168\u90e8\u5931\u8d25:" + String.valueOf(errMessage)));
    }

    @ApiOperation(value="\u672c\u5730\u8c03\u7528\u670d\u52a1\u7684openApi\u4e0b\u8f7djson\u63a5\u53e3")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/openapiDownJson"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="openApi\u4e0b\u8f7d")
    public ResponseEntity<?> callOpenApiDownJsonDServiceInstances(String serviceName) {
        List instances = this.discoveryClient.getInstances(serviceName);
        if (instances.isEmpty()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("\u5b9e\u4f8b\u6ce8\u518c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u73af\u5883\uff1a" + serviceName));
        }
        StringBuffer errMessage = new StringBuffer();
        HttpHeaders headers = this.createHeadersFromCurrentRequest();
        HttpEntity entity = new HttpEntity((Object)"body", (MultiValueMap)headers);
        for (ServiceInstance serviceInstance : instances) {
            String url = serviceInstance.getUri().toString() + OPENAPI_DOWNLOAD_JSON_URL;
            try {
                log.info("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\uff1aurl={} serviceInstance={}", (Object)url, (Object)serviceInstance);
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[0]);
                ByteArrayResource resource = new ByteArrayResource((byte[])response.getBody());
                log.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f\uff1a{}", (Object)url);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).contentLength((long)((byte[])response.getBody()).length).body((Object)resource);
            }
            catch (Exception e) {
                log.error("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: " + e.getMessage());
                errMessage.append("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: " + url + e.getMessage());
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\u5168\u90e8\u5931\u8d25:" + String.valueOf(errMessage)));
    }

    @ApiOperation(value="\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6e05\u7406\u8fdc\u7aef\u670d\u52a1UDC\u4e8c\u7ea7\u7f13\u5b58")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/udcLocalCache"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6e05\u7406\u8fdc\u7aef\u670d\u52a1UDC\u4e8c\u7ea7\u7f13\u5b58")
    public ApiResult udcLocalCacheServiceInstances(String serviceName) {
        List instances = this.discoveryClient.getInstances(serviceName);
        if (instances.isEmpty()) {
            return ApiResult.fail((String)("\u5b9e\u4f8b\u6ce8\u518c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u73af\u5883\uff1a" + serviceName));
        }
        StringBuffer errMessage = new StringBuffer();
        HttpHeaders headers = this.createHeadersFromCurrentRequest();
        HttpEntity entity = new HttpEntity((Object)"body", (MultiValueMap)headers);
        for (ServiceInstance serviceInstance : instances) {
            String url = serviceInstance.getUri().toString() + UDC_LOCAL_CACHE_URL;
            try {
                log.info("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\uff1aurl={} serviceInstance={}", (Object)url, (Object)serviceInstance);
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ApiResult<Boolean>>(){}, new Object[0]);
                if (response.getStatusCode().is2xxSuccessful()) {
                    log.info("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u6210\u529f\uff1aurl={} serviceInstance={}", (Object)url, (Object)serviceInstance);
                    continue;
                }
                errMessage.append("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u72b6\u6001\u5f02\u5e38\uff1a" + url + " \u5f02\u5e38\u7801\uff1a" + String.valueOf(response.getStatusCode()) + ";");
                log.error("Request failed with status: " + String.valueOf(response.getStatusCode()));
            }
            catch (Exception e) {
                log.error("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: " + e.getMessage());
                errMessage.append("\u5185\u90e8\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: ").append(url).append(e.getMessage()).append(";");
            }
        }
        if (errMessage.length() > 0) {
            return ApiResult.fail((String)errMessage.toString());
        }
        return ApiResult.ok();
    }

    private HttpHeaders createHeadersFromCurrentRequest() {
        HttpHeaders headers = new HttpHeaders();
        HttpServletRequest request = this.getCurrentHttpRequest();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.set(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    private HttpServletRequest getCurrentHttpRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attributes.getRequest();
    }
}

