/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserListQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserQueryRespVO;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@BusinessObject(businessType="Sys_User:\u8d26\u53f7")
@Api(tags={"\u901a\u7528\u7528\u6237\u8d26\u53f7\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/mng/common/user"}, produces={"application/json"})
@Validated
public class CommonUserController {
    private final UserMngService userMngService;
    private final UserQueryService userQueryService;

    public CommonUserController(UserMngService userMngService, UserQueryService userQueryService) {
        this.userMngService = userMngService;
        this.userQueryService = userQueryService;
    }

    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u901a\u7528\u5206\u9875\u67e5\u8be2\u8d26\u53f7", dataPermissionEnabled=true)
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d26\u53f7")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<UserQueryRespVO>> page(@RequestBody UserQueryVO queryVO) {
        return this.userQueryService.pageQuery(queryVO);
    }

    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u901a\u7528\u67e5\u8be2\u8d26\u53f7\u5217\u8868", dataPermissionEnabled=true)
    @ApiOperation(value="\u67e5\u8be2\u8d26\u53f7\u5217\u8868")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/list"})
    public ApiResult<List<UserListRespVO>> list(UserListQueryVO queryVO) {
        return this.userQueryService.listUser(queryVO);
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @ApiOperationSupport(order=11)
    @PatchMapping(value={"/reset/{id}/password"})
    public ApiResult<Long> updatePassword(@PathVariable(value="id") Long id) {
        return this.userMngService.updatePassword(id);
    }
}

