/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.system.service.AreaMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u884c\u653f\u533a\u57df\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/area"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_Area:\u884c\u653f\u533a\u57df", businessDoClass=SysPlatformAreaDO.class)
public class AreaController {
    private final AreaMngService service;

    public AreaController(AreaMngService service) {
        this.service = service;
    }

    @GetMapping(value={"/platform/enabled"})
    @ApiOperation(value="\u83b7\u53d6\u662f\u5426\u542f\u7528\u5e73\u53f0\u8bbe\u7f6e")
    @ApiOperationSupport(order=1)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u662f\u5426\u542f\u7528\u5e73\u53f0\u8bbe\u7f6e")
    public ApiResult<Boolean> getEnabledPlatform() {
        return this.service.getEnabledPlatform();
    }

    @PutMapping(value={"/platform/enabled"})
    @ApiOperation(value="\u5207\u6362\u662f\u5426\u542f\u7528\u5e73\u53f0\u8bbe\u7f6e")
    @ApiOperationSupport(order=2)
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u662f\u5426\u542f\u7528\u5e73\u53f0\u8bbe\u7f6e", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> updateEnabledPlatform() {
        return this.service.updateEnabledPlatform();
    }

    @GetMapping(value={"/tree"})
    @ApiOperation(value="\u884c\u653f\u533a\u57df\u6811")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u72b6\uff0c\u9ed8\u8ba4false", defaultValue="false")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u884c\u653f\u533a\u57df\u6811")
    public ApiResult<List<AreaMngTreeRespVO>> tree(@RequestParam(name="tree", defaultValue="false") Boolean tree) {
        return this.service.tree(tree);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u884c\u653f\u533a\u57df")
    @ApiOperationSupport(order=4)
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u662f\u5426\u542f\u7528\u5e73\u53f0\u8bbe\u7f6e", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid PlatformAreaSaveVO saveVO) {
        return this.service.save(saveVO);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u57df\u8be6\u60c5")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u533a\u57dfID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u884c\u653f\u533a\u57df\u8be6\u60c5")
    public ApiResult<AreaDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.service.get(id);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u884c\u653f\u533a\u57df\u8be6\u60c5")
    @ApiOperationSupport(order=6)
    @ApiImplicitParam(name="id", value="\u533a\u57dfID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u884c\u653f\u533a\u57df\u8be6\u60c5", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.service.delete(id);
    }

    @PostMapping(value={"/tree/rebuild"})
    @ApiOperation(value="\u91cd\u6784\u884c\u653f\u533a\u57df\u6811")
    @ApiOperationSupport(order=7)
    @ApiImplicitParam(name="rootId", value="\u6839\u533a\u57dfID")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u91cd\u6784\u884c\u653f\u533a\u57df\u6811")
    public ApiResult<Boolean> rebuildTree(@RequestParam(name="rootId", required=false) Long rootId) {
        return this.service.rebuildTree(rootId);
    }

    @ApiOperation(value="\u83b7\u53d6\u91c7\u96c6URL")
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/grabUrl"})
    public ApiResult<String> grabPreview() {
        return this.service.grabUrl();
    }

    @ApiOperation(value="\u9884\u89c8\u91c7\u96c6\u7684\u884c\u653f\u533a\u57df")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="url", value="URL\u5730\u5740", required=false), @ApiImplicitParam(name="forceLevel", value="\u5f3a\u5236\u7ea7\u522b", required=false, dataType="boolean"), @ApiImplicitParam(name="json", value="\u662f\u5426\u8fd4\u56deJSON", required=false, dataType="boolean")})
    @GetMapping(value={"/grabPreview"})
    public ApiResult<Object> grabPreview(@RequestParam(name="url", required=false) String url, @RequestParam(name="forceLevel", required=false, defaultValue="true") Boolean forceLevel, @RequestParam(name="json", required=false) Boolean json) {
        return this.service.grabPreview(url, forceLevel, json);
    }

    @ApiOperation(value="\u91c7\u96c6\u884c\u653f\u533a\u57df")
    @ApiOperationSupport(order=9)
    @ApiImplicitParams(value={@ApiImplicitParam(name="url", value="URL\u5730\u5740", required=false), @ApiImplicitParam(name="forceLevel", value="\u5f3a\u5236\u7ea7\u522b", required=false, dataType="boolean")})
    @PostMapping(value={"/grab"})
    public ApiResult<Boolean> grab(@RequestParam(name="url", required=false) String url, @RequestParam(name="forceLevel", required=false, defaultValue="true") Boolean forceLevel) {
        return this.service.grab(url, forceLevel);
    }
}

