/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.TenantOrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgTenantSaveVO;
import com.elitescloud.cloudt.system.service.TenantOrgMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u7ec4\u7ec7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/tenantOrg"}, produces={"application/json"})
@Validated
public class OrgTenantMngController {
    private final TenantOrgMngService tenantOrgMngService;

    public OrgTenantMngController(TenantOrgMngService tenantOrgMngService) {
        this.tenantOrgMngService = tenantOrgMngService;
    }

    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u7ec4\u7ec7\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/list"})
    public ApiResult<List<TenantOrgRespVO>> getList() {
        return this.tenantOrgMngService.getList();
    }

    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u7ec4\u7ec7\u5206\u9875\u5217\u8868")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<TenantOrgRespVO>> getPage(@RequestBody TenantOrgPageQueryVO queryVO) {
        return this.tenantOrgMngService.pageQuery(queryVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u79df\u6237\u7ec4\u7ec7ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.tenantOrgMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u79df\u6237\u7ec4\u7ec7")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/save"})
    public ApiResult<Long> saveTenantOrg(@RequestBody @Valid OrgTenantSaveVO saveVO) {
        return this.tenantOrgMngService.saveTenantOrg(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/get/{id}"})
    public ApiResult<TenantOrgDetailRespVO> getDetail(@PathVariable(value="id") Long id) {
        return this.tenantOrgMngService.getDetail(id);
    }

    @ApiOperation(value="\u5220\u9664\u79df\u6237\u7ec4\u7ec7")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u79df\u6237\u7ec4\u7ec7ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.tenantOrgMngService.delete(id);
    }

    @ApiOperation(value="\u5206\u914d\u79df\u6237\u7ec4\u7ec7\u7ba1\u7406\u5458")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u79df\u6237\u7ec4\u7ec7ID", required=true, dataType="int"), @ApiImplicitParam(name="adminId", value="\u7ba1\u7406\u5458ID", required=true, dataType="int")})
    @PatchMapping(value={"/assign/admin/{id}/{adminId}"})
    public ApiResult<Long> assignAdmin(@PathVariable(value="id") Long id, @PathVariable(value="adminId") Long adminId) {
        return this.tenantOrgMngService.updateAdmin(id, adminId);
    }
}

