/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DprSysInternallyEmployeeSalesman
implements DprValueResolverSPI {
    private static final Logger log = LoggerFactory.getLogger(DprSysInternallyEmployeeSalesman.class);

    @NotEmpty
    public DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN};
    }

    public DprValueResolverSPI.DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprValueResolverSPI.DprRuleValue dprRuleValueSysInternallyBo = new DprValueResolverSPI.DprRuleValue();
        List userTypeList = userInfo.getUser().getUserTypeList();
        List salesmanIdList = null;
        if (CollUtil.isNotEmpty((Collection)userTypeList)) {
            salesmanIdList = userTypeList.stream().filter(t -> UserType.SALESMAN.getValue().equals(t.getUserType())).map(SysUserType::getIdentityId).filter(StringUtils::hasText).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(salesmanIdList)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7684\u4e1a\u52a1\u5458ID\uff1a{}", (Object)userInfo.getUserId());
        }
        dprRuleValueSysInternallyBo.setValue(salesmanIdList);
        return dprRuleValueSysInternallyBo;
    }
}

