/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.finereport.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.AccountType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.modules.finereport.model.ViewReportParamRespVO;
import com.elitescloud.cloudt.system.modules.finereport.service.FineReportService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class FineReportServiceImpl
implements FineReportService {
    private static final Logger log = LoggerFactory.getLogger(FineReportServiceImpl.class);
    @Autowired
    private SystemProperties systemProperties;

    @Override
    public ApiResult<String> getSsoToken() {
        SystemProperties.FineReport props = this.systemProperties.getFineReport();
        if (props.getAccountType() == null || CharSequenceUtil.isBlank((CharSequence)props.getPublicKey())) {
            return ApiResult.fail((String)"\u83b7\u53d6SsoToken\u5931\u8d25");
        }
        String ssoToken = this.generateToken(props);
        return ApiResult.ok((Object)ssoToken);
    }

    @Override
    public ApiResult<ViewReportParamRespVO> viewReport(String viewlet, Boolean encoded) {
        SystemProperties.FineReport props = this.systemProperties.getFineReport();
        if (CharSequenceUtil.isBlank((CharSequence)props.getServerAddr())) {
            return ApiResult.fail((String)"\u62a5\u8868\u672a\u914d\u7f6e");
        }
        if (CharSequenceUtil.isBlank((CharSequence)viewlet)) {
            viewlet = CharSequenceUtil.nullToDefault((CharSequence)props.getDefaultViewlet(), (String)"");
        }
        ViewReportParamRespVO respVO = new ViewReportParamRespVO();
        respVO.setServerAddr(props.getServerAddr());
        respVO.setUri(this.obtainUriPath(viewlet));
        LinkedMultiValueMap uriParams = new LinkedMultiValueMap();
        if (StringUtils.hasText((String)viewlet)) {
            uriParams.add((Object)"viewlet", (Object)viewlet);
        }
        String token = this.generateToken(props);
        if (encoded == null || encoded.booleanValue()) {
            token = URLEncoder.encode(token, StandardCharsets.UTF_8);
        }
        if (StringUtils.hasText((String)props.getPublicKey())) {
            uriParams.add((Object)"ssoToken", (Object)token);
        } else {
            uriParams.add((Object)"fine_username", (Object)token);
        }
        respVO.setUriParams((MultiValueMap<String, String>)uriParams);
        String url = UriComponentsBuilder.fromUriString((String)respVO.getServerAddr()).path(respVO.getUri()).queryParams((MultiValueMap)uriParams).build().normalize().toString();
        respVO.setUrl(url);
        log.info("\u8bf7\u6c42\u62a5\u8868\uff1a{}", (Object)url);
        return ApiResult.ok((Object)respVO);
    }

    private String obtainUriPath(String viewlet) {
        if (viewlet.endsWith(".cpt")) {
            return "/decision/view/report";
        }
        if (viewlet.endsWith(".fvs")) {
            return "/decision/view/duchamp";
        }
        if (viewlet.endsWith(".frm")) {
            return "/decision/view/form";
        }
        return "/decision/view/report";
    }

    private String generateToken(SystemProperties.FineReport props) {
        AccountType accountType = props.getAccountType();
        Assert.notNull((Object)accountType, (String)"\u8d26\u53f7\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        String account = null;
        if (accountType == AccountType.USERNAME) {
            account = user.getUsername();
        } else if (accountType == AccountType.EMAIL) {
            account = user.getUser().getEmail();
        } else if (accountType == AccountType.MOBILE) {
            account = user.getUser().getMobile();
        } else {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff1a" + String.valueOf(accountType));
        }
        if (CharSequenceUtil.isBlank((CharSequence)account)) {
            throw new BusinessException("\u7528\u6237\u7684" + accountType.getType() + "\u4e3a\u7a7a");
        }
        String publicKey = props.getPublicKey();
        if (CharSequenceUtil.isBlank((CharSequence)publicKey)) {
            return account;
        }
        RSA rsa = new RSA(null, publicKey);
        Object plainTxt = null;
        plainTxt = Boolean.TRUE.equals(props.getTokenWithIssueTime()) ? "{\"username\":\"" + account + "\",\"issueTime\":" + new Date().getTime() + "}" : account;
        return rsa.encryptBase64((String)plainTxt, KeyType.PublicKey);
    }
}

