/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.repository;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgSendRecordDO;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class SysMsgSendRecordDtlRepoProc
extends BaseRepoProc<SysMsgSendRecordDtlDO> {
    private static final QSysMsgSendRecordDtlDO QDO = QSysMsgSendRecordDtlDO.sysMsgSendRecordDtlDO;
    private static final QSysMsgSendRecordDO QDO_RECORD = QSysMsgSendRecordDO.sysMsgSendRecordDO;

    public SysMsgSendRecordDtlRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByBatchId(@NotBlank String batchId) {
        super.deleteByValue((Path)SysMsgSendRecordDtlRepoProc.QDO.batchUuid, (Object)batchId);
    }

    public void updateViewed(@NotEmpty Collection<Long> ids, boolean readFlag) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysMsgSendRecordDtlRepoProc.QDO.readFlg, (Object)readFlag).set((Path)SysMsgSendRecordDtlRepoProc.QDO.readTime, (Object)LocalDateTime.now().format(DatetimeUtil.FORMATTER_DATETIME)).where(new Predicate[]{SysMsgSendRecordDtlRepoProc.QDO.id.in(ids)}).execute();
    }

    public void updateSendResult(@NotBlank String batchId, @NotBlank String sentEndMessage, String sendState, String sentErrMessage) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysMsgSendRecordDtlRepoProc.QDO.sendState, (Object)sendState).set((Path)SysMsgSendRecordDtlRepoProc.QDO.sentErrMessage, (Object)sentErrMessage).set(SysMsgSendRecordDtlRepoProc.QDO.sentTimeEnd, (Object)LocalDateTime.now()).where(new Predicate[]{SysMsgSendRecordDtlRepoProc.QDO.batchUuid.eq((Object)batchId).and((Predicate)SysMsgSendRecordDtlRepoProc.QDO.sentEndMessage.eq((Object)sentEndMessage))}).execute();
    }

    public long countToView(String receiverUserCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserCode, (Object)receiverUserCode).andEq((SimpleExpression)SysMsgSendRecordDtlRepoProc.QDO.sentTypeCode, (Object)MsgSendTypeEnum.SYS_INTERIOR.name()).andEq((SimpleExpression)SysMsgSendRecordDtlRepoProc.QDO.sendState, (Object)MsgSendStateEnum.OK.name()).andEq((SimpleExpression)SysMsgSendRecordDtlRepoProc.QDO.readFlg, (Object)false).build();
        return super.count(predicate);
    }

    public List<SysMsgViewResultDTO> queryViewResult(@NotBlank String batchId, @NotNull MsgSendTypeEnum sentType) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysMsgSendRecordDtlRepoProc.QDO.recipientUserId, SysMsgSendRecordDtlRepoProc.QDO.recipientUserCode, SysMsgSendRecordDtlRepoProc.QDO.recipientUserName, SysMsgSendRecordDtlRepoProc.QDO.readFlg, SysMsgSendRecordDtlRepoProc.QDO.readTime}).from((EntityPath)QDO)).where((Predicate)SysMsgSendRecordDtlRepoProc.QDO.batchUuid.eq((Object)batchId).and((Predicate)SysMsgSendRecordDtlRepoProc.QDO.sentTypeCode.eq((Object)sentType.name())).and((Predicate)SysMsgSendRecordDtlRepoProc.QDO.sendState.eq((Object)MsgSendStateEnum.OK.name())))).fetch().stream().map(t -> {
            SysMsgViewResultDTO dto = new SysMsgViewResultDTO();
            if (StringUtils.hasText((String)((String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserId)))) {
                dto.setUserId(Long.valueOf(Long.parseLong((String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserId))));
            }
            dto.setAccount((String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserCode));
            dto.setShowName((String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserName));
            dto.setViewed(Boolean.valueOf(Boolean.TRUE.equals(t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.readFlg))));
            if (StringUtils.hasText((String)((String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.readTime)))) {
                dto.setViewTime(LocalDateTime.parse((CharSequence)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.readTime), DatetimeUtil.FORMATTER_DATETIME));
            }
            return dto;
        }).collect(Collectors.toList());
    }

    public List<SysMsgSentResultDTO> querySentResult(@NotEmpty Collection<String> batchIds, @NotNull MsgSendTypeEnum sentType) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysMsgSendRecordDtlRepoProc.QDO.batchUuid, SysMsgSendRecordDtlRepoProc.QDO.recipientUserId, SysMsgSendRecordDtlRepoProc.QDO.recipientUserName, SysMsgSendRecordDtlRepoProc.QDO.readFlg}).from((EntityPath)QDO)).where((Predicate)SysMsgSendRecordDtlRepoProc.QDO.batchUuid.in(batchIds).and((Predicate)SysMsgSendRecordDtlRepoProc.QDO.sentTypeCode.eq((Object)sentType.name())).and((Predicate)SysMsgSendRecordDtlRepoProc.QDO.sendState.eq((Object)MsgSendStateEnum.OK.name())))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.batchUuid))).entrySet().stream().map(t -> {
            SysMsgSentResultDTO sentResultDTO = new SysMsgSentResultDTO();
            sentResultDTO.setRecordId((String)t.getKey());
            ArrayList<String> viewedUserIds = new ArrayList<String>();
            ArrayList<String> viewedUserNames = new ArrayList<String>();
            ArrayList<String> toViewUserIds = new ArrayList<String>();
            ArrayList<String> toViewUserNames = new ArrayList<String>();
            for (Tuple tuple : (List)t.getValue()) {
                if (Boolean.TRUE.equals(tuple.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.readFlg))) {
                    viewedUserIds.add((String)tuple.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserId));
                    viewedUserNames.add((String)tuple.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserName));
                    continue;
                }
                toViewUserIds.add((String)tuple.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserId));
                toViewUserNames.add((String)tuple.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserName));
            }
            sentResultDTO.setViewedUserIds(viewedUserIds);
            sentResultDTO.setViewedUserAccounts(viewedUserNames);
            sentResultDTO.setToViewUserIds(toViewUserIds);
            sentResultDTO.setToViewUserAccounts(toViewUserNames);
            return sentResultDTO;
        }).collect(Collectors.toList());
    }

    public Map<String, String> querySentEndMessage(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysMsgSendRecordDtlRepoProc.QDO.sentEndMessage, SysMsgSendRecordDtlRepoProc.QDO.recipientUserCode}).from((EntityPath)QDO)).where((Predicate)SysMsgSendRecordDtlRepoProc.QDO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.sentEndMessage), t -> (String)t.get((Expression)SysMsgSendRecordDtlRepoProc.QDO.recipientUserCode), (t1, t2) -> t1));
    }

    public List<SysMsgSendRecordDtlDO> queryByBatchId(@NotBlank String batchId) {
        return super.getListByValue((Path)SysMsgSendRecordDtlRepoProc.QDO.batchUuid, (Object)batchId, new OrderSpecifier[0]);
    }

    public List<SysMsgSendRecordDtlDO> queryByBatchId(@NotEmpty Collection<String> batchIds) {
        return super.getListByValue((Path)SysMsgSendRecordDtlRepoProc.QDO.batchUuid, batchIds, new OrderSpecifier[0]);
    }
}

