/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.rpc;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.zhxu.bs.BeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.AssignParamSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSentMsgParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordRepository;
import com.elitescloud.cloudt.system.modules.message.rpc.manager.SysMsgCustomSendRpcServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonService;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import com.elitescloud.cloudt.system.service.SysMsgCustomSendRpcService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/msg/custom/send"}, produces={"application/json"})
@TenantOrgTransaction(useTenantOrg=false)
public class SysMsgCustomSendRpcServiceImpl
extends SysMsgCustomSendRpcServiceAbstract
implements SysMsgCustomSendRpcService {
    private static final Logger log = LoggerFactory.getLogger(SysMsgCustomSendRpcServiceImpl.class);
    private final SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository;
    private final SysMsgSendRecordRepository sysMsgSendRecordRepository;
    private final BeanSearcherFactory beanSearcherFactory;
    private final BeanSearcher beanSearcher;
    private final PlatformTransactionManager transactionManager;
    private final SysMsgSendCommonService sysMsgSendCommonService;

    public SysMsgCustomSendRpcServiceImpl(SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository, SysMsgSendRecordRepository sysMsgSendRecordRepository, BeanSearcherFactory beanSearcherFactory, PlatformTransactionManager transactionManager, SysMsgSendCommonService sysMsgSendCommonService) {
        this.sysMsgSendRecordDtlRepository = sysMsgSendRecordDtlRepository;
        this.sysMsgSendRecordRepository = sysMsgSendRecordRepository;
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
        this.transactionManager = transactionManager;
        this.sysMsgSendCommonService = sysMsgSendCommonService;
    }

    public ApiResult<String> msgCustomEmployeeSend(EmployeeSendParamDTO param) {
        String uuidBatch = UUID.randomUUID().toString();
        MsgSendEmployeeUserDTO sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        this.sysMsgSendCommonService.checkSendUser(sendUser);
        List recipientUserList = param.getMsgRecipientUserDTO();
        this.sysMsgSendCommonService.checkRecipientEmployeeUserList(recipientUserList);
        List<EmployeePagedRespBean> employeeList = this.sysMsgSendCommonService.getCheckEmployeePagedRespBeans(recipientUserList);
        List employeeSentMsgParamDTOS = param.getSendTypeMessageMap();
        this.sendCustomRpcMsg(uuidBatch, sendUser, employeeList, employeeSentMsgParamDTOS, param.getMesJoinParamMap(), param.getReceiptUserId(), null);
        return ApiResult.ok((Object)uuidBatch);
    }

    public ApiResult<List<SysSendResultParam>> msgCustomEmployeeSend(List<EmployeeSendParamDTO> paramList) {
        ArrayList<SysSendResultParam> resultParamList = new ArrayList<SysSendResultParam>(paramList.size());
        for (EmployeeSendParamDTO paramDTO : paramList) {
            try {
                ApiResult<String> sendResult = this.msgCustomEmployeeSend(paramDTO);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(sendResult.isSuccess()), sendResult.getMsg(), (String)sendResult.getData()));
            }
            catch (Throwable e) {
                log.error("\u53d1\u9001\u5931\u8d25\uff1a", e);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(false), e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    public ApiResult<String> customMsgTypeParamSend(AssignParamSendParamDTO param) {
        String uuidBatch = UUID.randomUUID().toString();
        MsgSendEmployeeUserDTO sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        this.sysMsgSendCommonService.checkSendUser(sendUser);
        List recipientUserList = param.getMsgRecipientUserDTO();
        this.sysMsgSendCommonService.checkRecipientAssignUserList(recipientUserList);
        List<EmployeePagedRespBean> employeeList = recipientUserList.stream().map(templateAssignRecipientUserDTO -> {
            Map map = templateAssignRecipientUserDTO.getRecipientUserAccountDtoMap();
            EmployeePagedRespBean bean = this.sysMsgSendCommonService.setEmployeeBeanByAssignRecipientUserDTO(map, (TemplateAssignRecipientUserDTO)templateAssignRecipientUserDTO);
            return bean;
        }).filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        List employeeSentMsgParamDTOS = param.getSendTypeMessageMap();
        this.sendCustomRpcMsg(uuidBatch, sendUser, employeeList, employeeSentMsgParamDTOS, param.getMesJoinParamMap(), null, param.getReceiptAccount());
        return ApiResult.ok((Object)uuidBatch);
    }

    public ApiResult<List<SysSendResultParam>> customMsgTypeParamSend(List<AssignParamSendParamDTO> paramList) {
        ArrayList<SysSendResultParam> resultParamList = new ArrayList<SysSendResultParam>(paramList.size());
        for (AssignParamSendParamDTO paramDTO : paramList) {
            try {
                ApiResult<String> sendResult = this.customMsgTypeParamSend(paramDTO);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(sendResult.isSuccess()), sendResult.getMsg(), (String)sendResult.getData()));
            }
            catch (Throwable e) {
                log.error("\u53d1\u9001\u5931\u8d25\uff1a", e);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(false), e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    private void sendCustomRpcMsg(String uuidBatch, MsgSendEmployeeUserDTO sendUser, List<EmployeePagedRespBean> employeeList, List<EmployeeSentMsgParamDTO> employeeSentMsgParamDTOS, Map<String, String> mesJoinParamMap, Long receiptUserId, String receiptAccount) {
        List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList = SysMsgCustomSendRpcServiceImpl.getSysMsgTemplateConfigDOS(employeeSentMsgParamDTOS);
        SysMsgTemplateDO templateDo = SysMsgCustomSendRpcServiceImpl.getSysMsgTemplateDO();
        Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap = this.sysMsgSendCommonService.sysMsgTemplateConfigDoToVoGroupBySendTypeCode(sysMsgTemplateConfigDTOList);
        SendTempLateMsgBO sendBo = new SendTempLateMsgBO(null, null, mesJoinParamMap, uuidBatch, sendUser, employeeList, null, null, null);
        sendBo.setGroupedSendMap(groupedSendMap);
        sendBo.setTemplateDo(templateDo);
        sendBo.setReceiptUserId(receiptUserId);
        sendBo.setReceiptAccount(receiptAccount);
        sendBo.setDefaultReceiverMap(Collections.emptyMap());
        Map<MsgSendTypeEnum, List<MessageAccountVO>> sendPathMap = this.sysMsgSendCommonService.saveSendRecordToMsgSendTypeEnumListMap(sendBo, MsgTypeEnum.CUSTOM, true);
        Map templateParamsMap = employeeSentMsgParamDTOS == null ? Collections.emptyMap() : employeeSentMsgParamDTOS.stream().collect(Collectors.toMap(EmployeeSentMsgParamDTO::getMsgSendTypeEnum, t -> (Map)ObjectUtil.defaultIfNull((Object)t.getExternalTemplateParams(), Collections.emptyMap()), (t1, t2) -> t1));
        groupedSendMap.forEach((sendTypeEnum, msgTemplateTxtReplaceDTOS) -> this.sysMsgSendCommonService.sendBatchMsg(uuidBatch, (List)sendPathMap.get(sendTypeEnum), (MsgSendTypeEnum)sendTypeEnum, (SysMsgTemplateConfigVO)msgTemplateTxtReplaceDTOS, (Map)templateParamsMap.get(sendTypeEnum), null, null, sendBo.getReceiptAccount()));
    }
}

