/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateTxtReplaceDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.convert.SysMsgTemplateConfigConvert;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class SysMsgSendCommonServiceAbstract {
    private static final Logger log = LoggerFactory.getLogger(SysMsgSendCommonServiceAbstract.class);
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();
    private static final TemplateEngine engine = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig());

    public String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
    }

    public Map<MsgSendTypeEnum, List<TemplateTxtReplaceDTO>> msgTemplateTxtReplaceGroupBySendType(List<TemplateTxtReplaceDTO> templateContentReplaceDTOS) {
        if (!CollectionUtils.isEmpty(templateContentReplaceDTOS)) {
            return templateContentReplaceDTOS.stream().collect(Collectors.groupingBy(msgTemplateTxtReplaceDTO -> msgTemplateTxtReplaceDTO.getMsgSendTypeEnum()));
        }
        return new HashMap<MsgSendTypeEnum, List<TemplateTxtReplaceDTO>>();
    }

    public Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> sysMsgTemplateConfigDoToVoGroupBySendTypeCode(List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList) {
        List sysMsgTemplateConfigVOList = sysMsgTemplateConfigDTOList.stream().map(sysMsgTemplateConfigDO -> {
            try {
                MsgSendTypeEnum.valueOf((String)sysMsgTemplateConfigDO.getSendTypeCode());
            }
            catch (Exception e) {
                throw new BusinessException("\u6d88\u606f\u670d\u52a1\u8bf7\u6c42-\u7cfb\u7edf\u5f02\u5e38\uff1a\u4e0d\u5b58\u5728\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u7f16\u7801\uff1a" + sysMsgTemplateConfigDO.getSendTypeCode());
            }
            return SysMsgTemplateConfigConvert.INSTANCE.doToVo((SysMsgTemplateConfigDO)((Object)sysMsgTemplateConfigDO));
        }).collect(Collectors.toList());
        return sysMsgTemplateConfigVOList.stream().collect(Collectors.toMap(t -> MsgSendTypeEnum.valueOf((String)t.getSendTypeCode()), t -> t, (t1, t2) -> t1));
    }

    public void msgTemplateSetMesTitle(Long tid, Map<String, String> msgTemplateTitleMap, Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap) {
        if (CollUtil.isEmpty(msgTemplateTitleMap)) {
            log.warn("\u672a\u4f20\u9012\u6807\u9898\u6a21\u677f\u53c2\u6570\uff1a{}", (Object)tid);
            return;
        }
        for (Map.Entry<MsgSendTypeEnum, SysMsgTemplateConfigVO> entry : groupedSendMap.entrySet()) {
            if (CharSequenceUtil.isBlank((CharSequence)entry.getValue().getMesTitle())) continue;
            String text = SysMsgSendCommonServiceAbstract.msgTemplateRender(entry.getValue().getMesTitle(), msgTemplateTitleMap);
            entry.getValue().setMesTitle(text);
        }
    }

    public void msgTemplateSetMesText(Long tid, Map<String, String> msgTemplateTxtMap, Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap) {
        if (CollUtil.isEmpty(msgTemplateTxtMap)) {
            log.warn("\u672a\u4f20\u9012\u5185\u5bb9\u6a21\u677f\u53c2\u6570\uff1a{}", (Object)tid);
            return;
        }
        for (Map.Entry<MsgSendTypeEnum, SysMsgTemplateConfigVO> entry : groupedSendMap.entrySet()) {
            if (CharSequenceUtil.isBlank((CharSequence)entry.getValue().getMesText())) continue;
            String text = SysMsgSendCommonServiceAbstract.msgTemplateRender(entry.getValue().getMesText(), msgTemplateTxtMap);
            entry.getValue().setMesText(text);
            entry.getValue().setBusinessData(msgTemplateTxtMap);
        }
    }

    public static boolean checkMsgListEmptySize(Consumer<Logger> isEmptyMsgLogAction, String sizeGreaterErrorMsg, List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            isEmptyMsgLogAction.accept(log);
            return false;
        }
        if (list.size() > 1) {
            throw new BusinessException(sizeGreaterErrorMsg);
        }
        return list.size() == 1;
    }

    public static String msgTemplateRender(String mesTitle, Map<String, String> titleHashMap) {
        Template template = engine.getTemplate(mesTitle);
        return template.render(titleHashMap);
    }

    public static MsgSendEmployeeUserDTO autoGetSender(MsgSendEmployeeUserDTO userDTO) {
        if (userDTO != null && userDTO.getUserId() != null) {
            return userDTO;
        }
        userDTO = new MsgSendEmployeeUserDTO();
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser != null) {
            userDTO.setUserId(currentUser.getUserId());
            userDTO.setUserName(currentUser.getUsername());
            userDTO.setUserStandby(currentUser.getUser().getPrettyName());
            return userDTO;
        }
        userDTO.setUserId(Long.valueOf(-1L));
        userDTO.setUserName("\u7cfb\u7edf");
        userDTO.setUserStandby("\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001");
        return userDTO;
    }

    public void checkSendUser(MsgSendEmployeeUserDTO sendUser) {
        Assert.notNull((Object)sendUser, (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u53d1\u9001\u4eba\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)sendUser.getUserId(), (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u53d1\u9001\u4ebaID\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkRecipientEmployeeUserList(List<MsgRecipientUserDTO> recipientUserList) {
        Assert.notEmpty(recipientUserList, (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4eba\u96c6\u5408\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        recipientUserList.forEach(user -> {
            Assert.notNull((Object)user, (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4eba\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)user.getUserId(), (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    public void checkRecipientAssignUserList(List<TemplateAssignRecipientUserDTO> recipientUserList) {
        Assert.notEmpty(recipientUserList, (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4eba\u96c6\u5408\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        recipientUserList.forEach(user -> {
            Assert.notNull((Object)user, (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4eba\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notEmpty((Map)user.getRecipientUserAccountDtoMap(), (String)"\u6d88\u606f\u670d\u52a1-\u4fe1\u606f\u63a5\u6536\u4eba\u53d1\u9001\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    public void checkTemplateCode(String templateCode) {
        Assert.notNull((Object)templateCode, (String)"\u6d88\u606f\u670d\u52a1-\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public List<Long> checkFindMismatchedEmployeeIds(Collection<Long> userIds, List<EmployeePagedRespBean> employeeList) {
        List<Long> notUserIds = userIds.stream().filter(userId -> employeeList.stream().noneMatch(employee -> employee.getUserId().equals(userId))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notUserIds)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u8d26\u53f7id\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4fe1\u606f\uff0c\u5c06\u8df3\u8fc7\u53d1\u9001\uff0c{}", notUserIds);
        }
        return notUserIds;
    }

    public SysMsgSendRecordDO newSysMsgSendRecordDO(MsgTypeEnum msgType, EmployeePagedRespBean msgRecipientUserDTO, SendTempLateMsgBO sendBo) {
        SysMsgSendRecordDO sysMsgSendRecordDO = new SysMsgSendRecordDO();
        sysMsgSendRecordDO.setMsgType(msgType.name());
        sysMsgSendRecordDO.setSendUserId(sendBo.getSendUser().getUserId().toString());
        sysMsgSendRecordDO.setSendUserName(CharSequenceUtil.blankToDefault((CharSequence)sendBo.getSendUser().getUserStandby(), (String)sendBo.getSendUser().getUserName()));
        sysMsgSendRecordDO.setSendUserCode(sendBo.getSendUser().getUserCode());
        sysMsgSendRecordDO.setRecipientUserName(msgRecipientUserDTO.getLastName());
        sysMsgSendRecordDO.setRecipientUserId(msgRecipientUserDTO.getUserId() == null ? null : msgRecipientUserDTO.getUserId().toString());
        sysMsgSendRecordDO.setRecipientUserCode(msgRecipientUserDTO.getUsername());
        sysMsgSendRecordDO.setSendTime(LocalDateTime.now());
        sysMsgSendRecordDO.setBatchUuid(sendBo.getUuidBatch());
        sysMsgSendRecordDO.setDeleteFlag(0);
        sysMsgSendRecordDO.setTemplateCode(sendBo.getTemplateDo().getTemplateCode());
        sysMsgSendRecordDO.setTemplateName(sendBo.getTemplateDo().getTemplateName());
        return sysMsgSendRecordDO;
    }

    public SysMsgSendRecordDtlDO newSysMsgSendRecordDtlDO(SendTempLateMsgBO sendBo, SysMsgSendRecordDO sysMsgSendRecordDO, MsgSendTypeEnum sendTypeEnum, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO = new SysMsgSendRecordDtlDO();
        sysMsgSendRecordDtlDO.setMsgSendRecordId(sysMsgSendRecordDO.getId());
        sysMsgSendRecordDtlDO.setMsgType(sysMsgSendRecordDO.getMsgType());
        sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.SENDING.name());
        sysMsgSendRecordDtlDO.setSentTypeCode(sendTypeEnum.name());
        sysMsgSendRecordDtlDO.setSendTypeName(sendTypeEnum.getDescription());
        sysMsgSendRecordDtlDO.setSentTimeStart(LocalDateTime.now());
        sysMsgSendRecordDtlDO.setSendUserId(sysMsgSendRecordDO.getSendUserId());
        sysMsgSendRecordDtlDO.setSendUserName(sysMsgSendRecordDO.getSendUserName());
        sysMsgSendRecordDtlDO.setRecipientUserName(sysMsgSendRecordDO.getRecipientUserName());
        sysMsgSendRecordDtlDO.setRecipientUserId(sysMsgSendRecordDO.getRecipientUserId());
        sysMsgSendRecordDtlDO.setSendUserCode(sysMsgSendRecordDO.getSendUserCode());
        sysMsgSendRecordDtlDO.setRecipientUserCode(sysMsgSendRecordDO.getRecipientUserCode());
        sysMsgSendRecordDtlDO.setTemplateId(msgTemplateTxtReplaceDTO.getTemplateId());
        sysMsgSendRecordDtlDO.setTemplateCode(msgTemplateTxtReplaceDTO.getTemplateCode());
        sysMsgSendRecordDtlDO.setTemplateName(msgTemplateTxtReplaceDTO.getTemplateName());
        sysMsgSendRecordDtlDO.setTitleContent(msgTemplateTxtReplaceDTO.getMesTitle());
        sysMsgSendRecordDtlDO.setMessageContent(msgTemplateTxtReplaceDTO.getMesText());
        sysMsgSendRecordDtlDO.setExternalTemplateId(msgTemplateTxtReplaceDTO.getExternalTemplateId());
        sysMsgSendRecordDtlDO.setReadFlg(false);
        sysMsgSendRecordDtlDO.setBatchUuid(sendBo.getUuidBatch());
        return sysMsgSendRecordDtlDO;
    }

    public EmployeePagedRespBean setEmployeeBeanByAssignRecipientUserDTO(Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map, TemplateAssignRecipientUserDTO templateAssignRecipientUserDTO) {
        TemplateAssignRecipientUserAccountDTO accountDTO;
        if (CollUtil.isEmpty(map)) {
            return null;
        }
        EmployeePagedRespBean bean = new EmployeePagedRespBean();
        bean.setLastName(templateAssignRecipientUserDTO.getUserName());
        bean.setId(templateAssignRecipientUserDTO.getUserId());
        if (map.containsKey(MsgSendTypeEnum.EMAIL)) {
            TemplateAssignRecipientUserAccountDTO emailDto = map.get(MsgSendTypeEnum.EMAIL);
            bean.setEmail(emailDto.getAccount());
            bean.setUsername(emailDto.getNickName());
            bean.setLastName(emailDto.getNickName());
        }
        if (map.containsKey(MsgSendTypeEnum.MOBILE_SMS)) {
            TemplateAssignRecipientUserAccountDTO smsDto = map.get(MsgSendTypeEnum.MOBILE_SMS);
            bean.setPhone(smsDto.getAccount());
            bean.setUsername(smsDto.getAccount());
        }
        if (map.containsKey(MsgSendTypeEnum.APP)) {
            accountDTO = map.get(MsgSendTypeEnum.APP);
            bean.setUsername(accountDTO.getAccount());
        }
        if (map.containsKey(MsgSendTypeEnum.SYS_INTERIOR)) {
            accountDTO = map.get(MsgSendTypeEnum.SYS_INTERIOR);
            bean.setUsername(accountDTO.getAccount());
        }
        bean.setUserId(templateAssignRecipientUserDTO.getUserId());
        bean.setCode("");
        return bean;
    }

    public static void main(String[] args) {
        String msg = "${title!''}\u91c7\u8d2d\u8ba2\u5355 ";
        HashMap msgTemplateTitleMap = new HashMap();
        Template template = engine.getTemplate(msg);
        String text = template.render(msgTemplateTitleMap);
        System.out.println(text);
    }
}

