/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.OrgTreeNodeType;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.MultiOrgTreeQueryService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.MultiOrgTreeRepoProc;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiOrgTreeQueryServiceImpl
implements MultiOrgTreeQueryService {
    private static final Logger log = LoggerFactory.getLogger(MultiOrgTreeQueryServiceImpl.class);
    @Autowired
    private MultiOrgTreeRepoProc repoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private MultiOrgTreeRepoProc multiOrgTreeRepoProc;

    @Override
    public ApiResult<List<IdCodeNameParam>> listOrgTree() {
        List<IdCodeNameParam> treeList = this.repoProc.queryListTree();
        return ApiResult.ok(treeList);
    }

    @Override
    public ApiResult<List<OrgTreeNodeRespVO>> getTree(Long treeId, Boolean tree, Boolean employee, Boolean all) {
        Assert.notNull((Object)treeId, (String)"\u6811ID\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<OrgTreeNodeRespVO> respVoList = new ArrayList<OrgTreeNodeRespVO>(128);
        respVoList.addAll(this.queryOrgOfTree(treeId));
        if (Boolean.TRUE.equals(employee)) {
            Map<Long, String> orgIdCodeMap = respVoList.stream().collect(Collectors.toMap(TreeRespParam::getId, TreeRespParam::getCode, (t1, t2) -> t1));
            respVoList.addAll(this.queryEmployeeOfTree(treeId, orgIdCodeMap));
        }
        if (respVoList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        List result = tree == null || tree != false ? treeDataUtil.getRoots() : CollectionUtil.expandTree((List)treeDataUtil.getRoots(), TreeRespParam::getChildren);
        return ApiResult.ok((Object)result);
    }

    private List<OrgTreeNodeRespVO> queryEmployeeOfTree(long treeId, Map<Long, String> orgIdCodeMap) {
        return this.multiOrgTreeRepoProc.queryBoundEmployee(treeId).stream().map(t -> {
            OrgTreeNodeRespVO respVO = new OrgTreeNodeRespVO();
            respVO.setId(t.getId());
            respVO.setCode(t.getCode());
            respVO.setName(t.getFullName());
            respVO.setNodeType(OrgTreeNodeType.EMPLOYEE.getValue());
            respVO.setNodeTypeName(OrgTreeNodeType.EMPLOYEE.getDescription());
            respVO.setDataType(t.getType());
            respVO.setSortNo(t.getSortNo());
            respVO.setParentId(t.getOrgId());
            respVO.setParentCode((String)orgIdCodeMap.get(t.getOrgId()));
            respVO.setHasChildren(Boolean.valueOf(false));
            respVO.setChildren(Collections.emptyList());
            respVO.setUserId(t.getUserId());
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<OrgTreeNodeRespVO> queryOrgOfTree(long treeId) {
        List<OrgTreeNodeRespVO> treeLeafList = this.repoProc.queryTreeLeaf(treeId);
        if (treeLeafList.isEmpty()) {
            return Collections.emptyList();
        }
        SysOrgQueryDTO orgQueryDTO = new SysOrgQueryDTO();
        orgQueryDTO.setEnabled(Boolean.valueOf(true));
        Map orgMap = this.orgRepoProc.queryList(orgQueryDTO).stream().collect(Collectors.toMap(SysOrgBasicDTO::getId, Function.identity(), (t1, t2) -> t1));
        if (orgMap.isEmpty()) {
            return Collections.emptyList();
        }
        Map treeLeafMap = treeLeafList.stream().collect(Collectors.toMap(TreeRespParam::getId, Function.identity(), (t1, t2) -> t1));
        return treeLeafList.stream().filter(t -> orgMap.containsKey(t.getTempId())).map(t -> {
            SysOrgBasicDTO org = (SysOrgBasicDTO)orgMap.get(t.getTempId());
            OrgTreeNodeRespVO respVO = new OrgTreeNodeRespVO();
            respVO.setNodeType(OrgTreeNodeType.ORG.getValue());
            respVO.setNodeTypeName(OrgTreeNodeType.ORG.getDescription());
            respVO.setId(org.getId());
            respVO.setCode(org.getCode());
            respVO.setName(org.getPrettyName());
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)t.getSortNo(), (Object)0));
            if (t.getParentId() != null) {
                OrgTreeNodeRespVO parent = (OrgTreeNodeRespVO)treeLeafMap.get(t.getParentId());
                if (parent == null) {
                    log.info("\u4e0a\u7ea7\u4e0d\u5b58\u5728\uff1a{}\uff0c{}-{}", new Object[]{treeId, t.getId(), t.getParentId()});
                    return respVO;
                }
                SysOrgBasicDTO orgParent = (SysOrgBasicDTO)orgMap.get(parent.getTempId());
                if (orgParent == null) {
                    log.info("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1a{}\uff0c{}", (Object)treeId, (Object)parent.getTempId());
                    return respVO;
                }
                respVO.setParentId(orgParent.getId());
                respVO.setParentCode(orgParent.getCode());
            }
            return respVO;
        }).collect(Collectors.toList());
    }
}

