/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreePagingDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreePagingParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeStatusParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVPagingParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDetailVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreePagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeVersionDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepoProc;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuTreeServiceImpl
implements OrgBuTreeService {
    private final OrgBuTreeDomainService orgBuTreeDomainService;
    private final OrgBuTreeVersionDomainService orgBuTreeVersionDomainService;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #param.id", condition="#param.id != null && !#param.id.isEmpty()")
    @Transactional(rollbackFor={Exception.class})
    public Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param) {
        return this.orgBuTreeDomainService.orgBuTreeSaveOrUpdate(param);
    }

    @Override
    @SysCodeProc
    public OrgBuTreeDetailVO getOrgBuTreeDetailById(Long id) {
        OrgBuTreeDetailDTO result = this.orgBuTreeDomainService.getOrgBuTreeDetailById(id);
        return OrgTreeConvert.INSTANCE.dtoToVo(result);
    }

    @Override
    @SysCodeProc
    public OrgBuTreeDO getOrgBuTreeDetailByCode(String code) {
        OrgBuTreeDO orgBuTreeDO = this.orgBuTreeRepo.findByBuTreeCode(code).orElse(null);
        return orgBuTreeDO;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuTreePagingVO> queryOrgBuTreeByParams(OrgBuTreePagingParam param) {
        PagingVO<OrgBuTreePagingDTO> result = this.orgBuTreeDomainService.queryOrgBuTreeByParams(param);
        List records = result.getRecords();
        return PagingVO.builder().records(OrgTreeConvert.INSTANCE.treePDtoToVo(records)).total(result.getTotal()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(OrgBuTreeStatusParam param) {
        this.orgBuTreeDomainService.updateStatus(param);
    }

    @Override
    public PagingVO<OrgBuTreeVO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        PagingVO<OrgBuTreeDTO> result = this.orgBuTreeDomainService.getBuTreePagingByParam(param);
        List records = result.getRecords();
        return PagingVO.builder().records(OrgTreeConvert.INSTANCE.treeDtoToVo(records)).total(result.getTotal()).build();
    }

    @Override
    public Boolean getCreateNewVersionFlag(String buTreeCode) {
        return this.orgBuTreeDomainService.getCreateNewVersionFlag(buTreeCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBuTreeById(Long id) {
        this.orgBuTreeDomainService.deleteBuTreeById(id);
    }

    public OrgBuTreeServiceImpl(OrgBuTreeDomainService orgBuTreeDomainService, OrgBuTreeVersionDomainService orgBuTreeVersionDomainService, OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeRepoProc orgBuTreeRepoProc) {
        this.orgBuTreeDomainService = orgBuTreeDomainService;
        this.orgBuTreeVersionDomainService = orgBuTreeVersionDomainService;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
    }
}

