/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.wecom.controller;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.modules.wecom.model.login.WecomLoginPropsVO;
import com.elitescloud.cloudt.system.modules.wecom.service.WecomAuthService;
import com.elitescloud.cloudt.system.modules.wecom.util.crypt.WXBizMsgCrypt;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u5fae\u8ba4\u8bc1"})
@RestController
@RequestMapping(value={"/oauth/wecom"})
@Validated
public class WecomAuthController {
    private static final Logger logger = LoggerFactory.getLogger(WecomAuthController.class);
    @Autowired
    private WecomAuthService service;

    @ApiOperation(value="\u4f9b\u4f01\u5fae\u9a8c\u8bc1\u670d\u52a1", hidden=true)
    @GetMapping(value={"/verify"})
    public String validateServer(@RequestParam(name="msg_signature", required=false) String msg_signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr, HttpServletRequest request) {
        logger.info("\u968f\u673a\u5b57\u7b26\u4e32\uff1a{}", (Object)echostr);
        logger.info("\u8bf7\u6c42\uff1a{}", (Object)request.getQueryString());
        SysTenantDTO tenant = ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant();
        ThirdPartAccountBO accountCfg = (ThirdPartAccountBO)((ThirdPartAccountQueryService)SpringContextHolder.getBean(ThirdPartAccountQueryService.class)).get(tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId(), ThirdPartAccountType.WECOM, SysThirdPartyAccountBusinessType.DEFAULT).computeData();
        if (accountCfg == null) {
            logger.error("\u672a\u914d\u7f6e\u4f01\u5fae\u4fe1\u606f");
            return "fail";
        }
        String sToken = (String)accountCfg.getConfigValue("token");
        String sEncodingAESKey = (String)accountCfg.getConfigValue("encodingAESKey");
        String res = null;
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, (String)accountCfg.getConfigValue("corpid"));
            res = wxcpt.VerifyURL(msg_signature, timestamp, nonce, echostr);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        }
        logger.info("\u8fd4\u56de\uff1a{}", res);
        return res;
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u914d\u7f6e")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/props"})
    public ApiResult<WecomLoginPropsVO> getLoginProps() {
        return this.service.getLoginProps();
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba4\u8bc1\u5730\u5740")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="redirectUrl", value="\u8ba4\u8bc1\u6210\u529f\u540e\u8fd4\u56de\u81f3\u524d\u7aef\u7684url\u8def\u5f84", required=true), @ApiImplicitParam(name="state", value="\u81ea\u5b9a\u4e49\u53c2\u6570")})
    @GetMapping(value={"/authorizeUrl"})
    public ApiResult<String> getAuthorizeUrl(@NotBlank(message="\u8ba4\u8bc1\u540e\u7684\u56de\u8c03\u5730\u5740") @RequestParam(name="redirectUrl") @NotBlank(message="\u8ba4\u8bc1\u540e\u7684\u56de\u8c03\u5730\u5740") String redirectUrl, @RequestParam(name="state", required=false) String state) {
        return this.service.getAuthorizeUrl(redirectUrl, state);
    }

    @ApiOperation(value="\u6839\u636e\u6388\u6743\u7801\u83b7\u53d6token")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u6388\u6743\u7801", required=true)})
    @GetMapping(value={"/code2Token"})
    public ApiResult<OAuthToken> code2Token(HttpServletRequest request, HttpServletResponse response, @NotBlank(message="\u6388\u6743\u7801\u4e3a\u7a7a") @NotBlank(message="\u6388\u6743\u7801\u4e3a\u7a7a") String code) {
        return this.service.code2Token(request, response, code);
    }
}

