/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.xingyunzuo.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.modules.xingyunzuo.service.XingyunzuoService;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XingyunzuoServiceImpl
implements XingyunzuoService {
    @Autowired
    private SystemProperties systemProperties;

    @Override
    public ApiResult<String> generateToken() {
        SystemProperties.XingYunZuo props = this.systemProperties.getXingYunZuo();
        String secretKeyStr = props.getSecretKey();
        if (CharSequenceUtil.isBlank((CharSequence)secretKeyStr)) {
            return ApiResult.fail((String)"\u672a\u914d\u7f6eSecretKey\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        SecretKey secretKey = Keys.hmacShaKeyFor((byte[])Base64.decode((CharSequence)secretKeyStr));
        String mobile = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUser().getMobile();
        if (CharSequenceUtil.isBlank((CharSequence)mobile)) {
            return ApiResult.fail((String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u624b\u673a\u53f7");
        }
        long expirationMs = System.currentTimeMillis() + props.getTtl().toMillis();
        String jwt = Jwts.builder().claim("phoneNumber", (Object)mobile).claim("merchantId", (Object)props.getMerchantId()).claim("projectId", (Object)props.getProjectId()).setExpiration(new Date(expirationMs)).signWith((Key)secretKey).compact();
        return ApiResult.ok((Object)jwt);
    }
}

