/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.imports;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.imports.param.PageFieldImportBO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageFieldImportProvider
implements DataImport<PageFieldImportBO> {
    @Autowired
    private SysPageFieldConfigService service;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public String getTmplCode() {
        return "sys_fieldconfig_import";
    }

    public List<String> executeImport(List<PageFieldImportBO> dataList, int startRowIndex) {
        HashMap<String, String> appMap = new HashMap<String, String>(dataList.size());
        ArrayList<String> errorMsgList = new ArrayList<String>(dataList.size());
        for (PageFieldImportBO pageFieldImportBO : dataList) {
            try {
                String res = this.importData(pageFieldImportBO, appMap);
                errorMsgList.add(res);
            }
            catch (Exception e) {
                errorMsgList.add(e.getMessage());
            }
        }
        return errorMsgList;
    }

    public Integer stepSize() {
        return 10;
    }

    private String importData(PageFieldImportBO importBO, Map<String, String> appMap) {
        Assert.notBlank((CharSequence)importBO.getAppCode(), (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String appName = appMap.computeIfAbsent(importBO.getAppCode(), code -> (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getNameByCode(code)));
        Assert.notBlank((CharSequence)appName, (String)(importBO.getAppCode() + "\u4e0d\u5b58\u5728\u6216\u9519\u8bef"), (Object[])new Object[0]);
        importBO.setAppName(appName);
        Assert.notBlank((CharSequence)importBO.getConfigCode(), (String)"\u914d\u7f6e\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        importBO.setConfigName(CharSequenceUtil.blankToDefault((CharSequence)importBO.getConfigName(), (String)importBO.getConfigCode()));
        Assert.notBlank((CharSequence)importBO.getFieldCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        importBO.setFieldName(CharSequenceUtil.blankToDefault((CharSequence)importBO.getFieldName(), (String)importBO.getFieldCode()));
        importBO.setFieldRequired((Boolean)ObjectUtil.defaultIfNull((Object)importBO.getFieldRequired(), () -> "\u662f".equals(importBO.getFieldRequiredName())));
        importBO.setFieldOrder((Integer)ObjectUtil.defaultIfNull((Object)importBO.getFieldOrder(), (Object)1));
        importBO.setFieldHidden((Boolean)ObjectUtil.defaultIfNull((Object)importBO.getFieldHidden(), () -> "\u662f".equals(importBO.getFieldHiddenName())));
        importBO.setFieldEdit((Boolean)ObjectUtil.defaultIfNull((Object)importBO.getFieldEdit(), () -> "\u662f".equals(importBO.getFieldEditName())));
        ApiResult<Long> saveResult = this.service.save(importBO);
        Assert.isTrue((boolean)saveResult.isSuccess(), (String)saveResult.getMsg(), (Object[])new Object[0]);
        return null;
    }
}

