/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.orgsync;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserCreateResultParam;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserSaveParam;
import com.elitescloud.cloudt.system.modules.wecom.util.WeComTool;
import com.elitescloud.cloudt.system.provider.orgsync.BaseWecomSync;
import com.elitescloud.cloudt.system.provider.orgsync.WecomOrgSync;
import com.elitescloud.cloudt.system.service.callback.EmployeeChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.SyncDataType;
import com.elitescloud.cloudt.system.service.manager.SysSyncManager;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysSyncSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.SyncRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WecomEmpSync
extends BaseWecomSync
implements EmployeeChangedCallback {
    private static final Logger logger = LoggerFactory.getLogger(WecomEmpSync.class);
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private TaskExecutor taskExecutor;

    public void onUpsert(boolean add, SysEmployeeSaveBO saveBO, SysEmployeeDO employeeDO) {
        this.taskExecutor.execute(() -> {
            boolean needSync = this.employeeRepoProc.needSyncOuter(employeeDO.getId());
            if (!needSync) {
                logger.info("\u5458\u5de5\u65e0\u9700\u5411\u4f01\u5fae\u540c\u6b65");
                return;
            }
            BaseWecomSync.WecomConfig cfg = WecomEmpSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            WecomEmpSync.syncToWeCom(employeeDO, cfg);
        });
    }

    public void onEnabled(Long employeeId, boolean enabled) {
        this.taskExecutor.execute(() -> {
            boolean needSync = this.employeeRepoProc.needSyncOuter(employeeId);
            if (!needSync) {
                logger.info("\u5458\u5de5\u65e0\u9700\u5411\u4f01\u5fae\u540c\u6b65");
                return;
            }
            BaseWecomSync.WecomConfig cfg = WecomEmpSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            SysEmployeeDO employeeDO = (SysEmployeeDO)this.employeeRepoProc.get(employeeId);
            if (employeeDO != null) {
                WecomEmpSync.syncToWeCom(employeeDO, cfg);
            }
        });
    }

    public void onDelete(Long employeeId) {
        this.taskExecutor.execute(() -> {
            boolean needSync = this.employeeRepoProc.needSyncOuter(employeeId);
            if (!needSync) {
                logger.info("\u5458\u5de5\u65e0\u9700\u5411");
                return;
            }
            BaseWecomSync.WecomConfig cfg = WecomEmpSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            logger.info("\u5220\u9664\u4f01\u5fae\u5458\u5de5\uff1a{}", (Object)employeeId);
            WecomEmpSync.syncDeleteToWecom(employeeId, cfg);
        });
    }

    static void syncDeleteToWecom(long employeeId, BaseWecomSync.WecomConfig cfg) {
        SyncRepoProc syncRepoProc = (SyncRepoProc)SpringContextHolder.getBean(SyncRepoProc.class);
        IdCodeNameParam syncInfo = ((SyncRepoProc)SpringContextHolder.getBean(SyncRepoProc.class)).getIdCode(SyncDataType.EMPLOYEE.name(), "" + employeeId, cfg.getCorpid());
        if (syncInfo == null) {
            return;
        }
        syncRepoProc.delete(syncInfo.getId().longValue());
        if (CharSequenceUtil.isBlank((CharSequence)syncInfo.getCode())) {
            return;
        }
        String token = WecomEmpSync.getAccessTokenOfWecom(cfg);
        WeComTool.userDelete(token, "" + employeeId);
    }

    static void syncToWeCom(SysEmployeeDO employee, BaseWecomSync.WecomConfig cfg) {
        Long syncId;
        logger.info("\u540c\u6b65\u4f01\u5fae\u5458\u5de5\uff1a{}", (Object)employee.getId());
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{employee.getMobile(), employee.getEmail()})) {
            logger.info("\u90ae\u7bb1\u548c\u624b\u673a\u53f7\u90fd\u4e3a\u7a7a\uff0c\u5ffd\u7565\u540c\u6b65");
            return;
        }
        IdCodeNameParam syncInfo = ((SyncRepoProc)SpringContextHolder.getBean(SyncRepoProc.class)).getIdCode(SyncDataType.EMPLOYEE.name(), "" + employee.getId(), cfg.getCorpid());
        Long l = syncId = syncInfo == null ? null : syncInfo.getId();
        if (syncInfo == null) {
            SysSyncSaveBO sysSyncSaveBO = WecomEmpSync.initSyncSaveBO(employee.getId(), cfg.getCorpid());
            syncId = ((SysSyncManager)SpringContextHolder.getBean(SysSyncManager.class)).save(sysSyncSaveBO);
        }
        List<SysEmployeeOrgDO> empOrgList = ((EmployeeOrgRepoProc)((Object)SpringContextHolder.getBean(EmployeeOrgRepoProc.class))).getEmployeeOrgByEmployeeId(employee.getId());
        List<Long> orgIds = Collections.emptyList();
        List<Long> leaderOrgIds = Collections.emptyList();
        Long leaderId = null;
        Long mainOrgId = null;
        List<Long> executiveOrgIds = empOrgList.stream().map(SysEmployeeOrgDO::getOrgId).filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        if (!executiveOrgIds.isEmpty()) {
            executiveOrgIds = ((OrgRepoProc)((Object)SpringContextHolder.getBean(OrgRepoProc.class))).filterExecutiveOrg(executiveOrgIds);
        }
        if (!executiveOrgIds.isEmpty()) {
            Map<Long, Long> wecomDepartmentIdMap = WecomOrgSync.getWecomIds(executiveOrgIds, cfg.getCorpid());
            orgIds = new ArrayList<Long>();
            leaderOrgIds = new ArrayList<Long>();
            for (SysEmployeeOrgDO sysEmployeeOrgDO : empOrgList) {
                Long departmentId;
                if (!executiveOrgIds.contains(sysEmployeeOrgDO.getOrgId()) || (departmentId = wecomDepartmentIdMap.get(sysEmployeeOrgDO.getOrgId())) == null) continue;
                orgIds.add(departmentId);
                if (Boolean.TRUE.equals(sysEmployeeOrgDO.getAssignee())) {
                    leaderOrgIds.add(departmentId);
                }
                if (leaderId == null && sysEmployeeOrgDO.getLeaderEmployeeId() != null) {
                    leaderId = sysEmployeeOrgDO.getLeaderEmployeeId();
                }
                if (mainOrgId != null || !Boolean.TRUE.equals(sysEmployeeOrgDO.getAssignee())) continue;
                mainOrgId = departmentId;
            }
        }
        UserSaveParam saveParam = WecomEmpSync.convertSaveParam(employee, orgIds, leaderOrgIds, leaderId, mainOrgId);
        String token = WecomEmpSync.getAccessTokenOfWecom(cfg);
        UserCreateResultParam syncResult = syncInfo != null && StringUtils.hasText((String)syncInfo.getCode()) ? WeComTool.userUpdate(token, saveParam) : WeComTool.userCreate(token, saveParam);
        ((SysSyncManager)SpringContextHolder.getBean(SysSyncManager.class)).updateSyncResult(syncId, syncResult.isSuccess(), employee.getId().toString(), syncResult.isSuccess() ? null : syncResult.getErrcode() + ":" + syncResult.getErrmsg());
    }

    static UserSaveParam convertSaveParam(SysEmployeeDO employeeDO, List<Long> departmentIds, List<Long> isLeaderDepartmentIds, Long directLeader, Long mainDepartment) {
        UserSaveParam saveParam = new UserSaveParam();
        saveParam.setUserid(employeeDO.getId().toString());
        saveParam.setName(employeeDO.getFullName());
        saveParam.setMobile(employeeDO.getMobile());
        saveParam.setDepartment(departmentIds);
        saveParam.setPosition(employeeDO.getDuty());
        saveParam.setGender(Gender.FEMALE.getValue().equals(employeeDO.getGender()) ? 2 : 1);
        saveParam.setEmail(employeeDO.getEmail());
        saveParam.setTelephone(employeeDO.getPhone());
        if (CollUtil.isNotEmpty(departmentIds)) {
            ArrayList<Integer> leaderDepartmentIds = new ArrayList<Integer>();
            for (Long departmentId : departmentIds) {
                leaderDepartmentIds.add(isLeaderDepartmentIds != null && isLeaderDepartmentIds.contains(departmentId) ? 1 : 0);
            }
            saveParam.setIs_leader_in_dept(leaderDepartmentIds);
        }
        saveParam.setDirect_leader(directLeader == null ? null : List.of(directLeader));
        saveParam.setEnable(Boolean.FALSE.equals(employeeDO.getEnabled()) ? 0 : 1);
        saveParam.setTo_invite(true);
        saveParam.setNickname(employeeDO.getNickName());
        saveParam.setAddress(employeeDO.getAddress());
        saveParam.setMain_department(mainDepartment);
        return saveParam;
    }

    static SysSyncSaveBO initSyncSaveBO(Long employeeId, String corpid) {
        SysSyncSaveBO sysSyncSaveBO = new SysSyncSaveBO();
        sysSyncSaveBO.setDataType(SyncDataType.EMPLOYEE.name());
        sysSyncSaveBO.setDataKey(employeeId.toString());
        sysSyncSaveBO.setSyncOuter(Boolean.valueOf(true));
        sysSyncSaveBO.setOuterApp(corpid);
        sysSyncSaveBO.setSyncDataTime(LocalDateTime.now());
        sysSyncSaveBO.setManual(Boolean.valueOf(true));
        sysSyncSaveBO.setSyncSuccess(Boolean.valueOf(false));
        return sysSyncSaveBO;
    }
}

