/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.orgsync;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentDeleteResult;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentIdListResult;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentSaveParam;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentSaveResult;
import com.elitescloud.cloudt.system.modules.wecom.util.WeComTool;
import com.elitescloud.cloudt.system.provider.orgsync.BaseWecomSync;
import com.elitescloud.cloudt.system.provider.orgsync.WecomEmpSync;
import com.elitescloud.cloudt.system.service.callback.OrgChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.SyncDataType;
import com.elitescloud.cloudt.system.service.manager.SysSyncManager;
import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysSyncSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.SyncRepoProc;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WecomOrgSync
extends BaseWecomSync
implements OrgChangedCallback {
    private static final Logger logger = LoggerFactory.getLogger(WecomOrgSync.class);
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private SyncRepoProc syncRepoProc;
    @Autowired
    private SysSyncManager sysSyncManager;
    @Autowired
    private TaskExecutor taskExecutor;

    public void onUpsert(boolean add, SysOrgSaveBO saveBO, SysOrgDO orgDO) {
        if (add && Boolean.FALSE.equals(orgDO.getSyncOuter()) && Boolean.TRUE.equals(orgDO.getExecutive())) {
            return;
        }
        this.taskExecutor.execute(() -> {
            BaseWecomSync.WecomConfig cfg = WecomOrgSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            if (Boolean.FALSE.equals(orgDO.getSyncOuter())) {
                this.delete(orgDO.getId(), cfg);
                return;
            }
            this.update(orgDO, cfg);
        });
    }

    public void onEnabled(Long orgId, boolean enabled) {
    }

    public void onDelete(Long orgId) {
        this.taskExecutor.execute(() -> {
            BaseWecomSync.WecomConfig cfg = WecomOrgSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            this.delete(orgId, cfg);
        });
    }

    public void deleteAllOrg(Long orgId) {
        this.taskExecutor.execute(() -> {
            List childrenIds;
            BaseWecomSync.WecomConfig cfg = WecomOrgSync.getConfig();
            if (cfg == null) {
                logger.info("\u4f01\u5fae\u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u540c\u6b65");
                return;
            }
            List<Object> list = childrenIds = orgId == null ? this.orgRepoProc.allId() : this.orgRepoProc.getChildrenIdByPid(orgId);
            if (childrenIds.isEmpty()) {
                if (orgId == null) {
                    this.deleteAllByWecom(cfg);
                }
                return;
            }
            childrenIds = childrenIds.stream().sorted(Comparator.comparingLong(t -> (Long)t).reversed()).collect(Collectors.toList());
            for (Long childrenId : childrenIds) {
                this.delete(childrenId, cfg);
            }
            if (orgId == null) {
                this.deleteAllByWecom(cfg);
            }
        });
    }

    private void deleteAllByWecom(BaseWecomSync.WecomConfig cfg) {
        String token = WecomOrgSync.getAccessTokenOfWecom(cfg);
        DepartmentIdListResult departmentIdList = WeComTool.departmentIdList(token, null);
        if (!departmentIdList.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u4f01\u5fae\u7ec4\u7ec7\u5931\u8d25\uff0c" + departmentIdList.getErrcode() + ":" + departmentIdList.getErrmsg());
        }
        if (CollUtil.isNotEmpty(departmentIdList.getDepartment_id())) {
            for (DepartmentIdListResult.DepartmentId departmentId : departmentIdList.getDepartment_id()) {
                DepartmentDeleteResult deleteDepartmentResult = WeComTool.departmentDelete(token, departmentId.getId());
                if (deleteDepartmentResult.isSuccess()) continue;
                logger.info("\u5220\u9664\u4f01\u5fae\u7ec4\u7ec7\u5931\u8d25\uff0c" + departmentIdList.getErrcode() + ":" + departmentIdList.getErrmsg());
            }
        }
    }

    private void delete(long orgId, BaseWecomSync.WecomConfig cfg) {
        IdCodeNameParam syncInfo = this.syncRepoProc.getIdCode(SyncDataType.ORG.name(), "" + orgId, cfg.getCorpid());
        if (syncInfo == null) {
            logger.info("\u672a\u5411\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\uff0c\u5219\u5ffd\u7565\u5220\u9664");
            return;
        }
        logger.info("\u5220\u9664\u4f01\u5fae\u7684\u7ec4\u7ec7\uff1a{}", (Object)orgId);
        this.sysSyncManager.delete(syncInfo.getId());
        if (!StringUtils.hasText((String)syncInfo.getCode())) {
            return;
        }
        String token = WecomOrgSync.getAccessTokenOfWecom(cfg);
        DepartmentDeleteResult syncResult = WeComTool.departmentDelete(token, Long.valueOf(syncInfo.getCode()));
        if (!syncResult.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u4f01\u5fae\u7ec4\u7ec7\u5931\u8d25\uff0c" + syncResult.getErrcode() + ":" + syncResult.getErrmsg());
        }
    }

    private void update(SysOrgDO orgDOUpdate, BaseWecomSync.WecomConfig cfg) {
        Long orgId = orgDOUpdate.getId();
        IdCodeNameParam syncInfo = this.syncRepoProc.getIdCode(SyncDataType.ORG.name(), "" + orgId, cfg.getCorpid());
        Long syncId = syncInfo == null ? null : syncInfo.getId();
        String token = null;
        if (syncInfo != null && StringUtils.hasText((String)syncInfo.getCode())) {
            logger.info("\u66f4\u65b0\u4f01\u5fae\u7684\u7ec4\u7ec7\uff1a{}", (Object)orgId);
            DepartmentSaveParam saveParam = WecomOrgSync.convertSaveParam(orgDOUpdate, cfg.getCorpid());
            token = WecomOrgSync.getAccessTokenOfWecom(cfg);
            DepartmentSaveResult syncResult = WeComTool.departmentUpdate(token, saveParam);
            this.sysSyncManager.updateSyncResult(syncId, syncResult.isSuccess(), syncInfo.getCode(), syncResult.isSuccess() ? null : syncResult.getErrcode() + ":" + syncResult.getErrmsg());
            return;
        }
        List orgList = this.orgRepoProc.listChildrens(orgId).stream().sorted(Comparator.comparingLong(BaseModel::getId)).collect(Collectors.toList());
        for (SysOrgDO sysOrgDO : orgList) {
            orgId = sysOrgDO.getId();
            logger.info("\u65b0\u589e\u4f01\u5fae\u7684\u7ec4\u7ec7\uff1a{}", (Object)orgId);
            syncInfo = this.syncRepoProc.getIdCode(SyncDataType.ORG.name(), "" + orgId, cfg.getCorpid());
            Long l = syncId = syncInfo == null ? null : syncInfo.getId();
            if (syncInfo == null) {
                SysSyncSaveBO sysSyncSaveBO = WecomOrgSync.initSyncSaveBO(orgId, cfg.getCorpid());
                syncId = this.sysSyncManager.save(sysSyncSaveBO);
            }
            DepartmentSaveParam saveParam = WecomOrgSync.convertSaveParam(sysOrgDO, cfg.getCorpid());
            token = WecomOrgSync.getAccessTokenOfWecom(cfg);
            DepartmentSaveResult syncResult = syncInfo != null && StringUtils.hasText((String)syncInfo.getCode()) ? WeComTool.departmentUpdate(token, saveParam) : WeComTool.departmentCreate(token, saveParam);
            this.sysSyncManager.updateSyncResult(syncId, syncResult.isSuccess(), syncResult.getId() != null ? syncResult.getId().toString() : null, syncResult.isSuccess() ? null : syncResult.getErrcode() + ":" + syncResult.getErrmsg());
        }
        this.syncEmployee(orgDOUpdate.getId(), cfg);
    }

    private void syncEmployee(Long orgId, BaseWecomSync.WecomConfig cfg) {
        logger.info("\u540c\u6b65\u7ec4\u7ec7\u4e0b\u7684\u5458\u5de5\uff1a{}", (Object)orgId);
        EmployeeQueryDTO employeeQueryDTO = new EmployeeQueryDTO();
        employeeQueryDTO.setOrgIdBelong(orgId);
        List<SysEmployeeDO> employeeList = this.employeeRepoProc.queryList(employeeQueryDTO);
        if (employeeList.isEmpty()) {
            return;
        }
        for (SysEmployeeDO employee : employeeList) {
            WecomEmpSync.syncToWeCom(employee, cfg);
        }
    }

    static SysSyncSaveBO initSyncSaveBO(Long orgId, String corpid) {
        SysSyncSaveBO sysSyncSaveBO = new SysSyncSaveBO();
        sysSyncSaveBO.setDataType(SyncDataType.ORG.name());
        sysSyncSaveBO.setDataKey(orgId.toString());
        sysSyncSaveBO.setSyncOuter(Boolean.valueOf(true));
        sysSyncSaveBO.setOuterApp(corpid);
        sysSyncSaveBO.setSyncDataTime(LocalDateTime.now());
        sysSyncSaveBO.setManual(Boolean.valueOf(true));
        sysSyncSaveBO.setSyncSuccess(Boolean.valueOf(false));
        return sysSyncSaveBO;
    }

    static DepartmentSaveParam convertSaveParam(SysOrgDO orgDO, String corpid) {
        DepartmentSaveParam saveParam = new DepartmentSaveParam();
        saveParam.setName(orgDO.getName());
        saveParam.setName_en(orgDO.getEnglishName());
        if (orgDO.getPId() != null && orgDO.getPId() != -1L) {
            saveParam.setParentid(WecomOrgSync.getWecomId(orgDO.getPId(), corpid));
        }
        saveParam.setOrder(orgDO.getSortNo());
        saveParam.setId(WecomOrgSync.getWecomId(orgDO.getId(), corpid));
        return saveParam;
    }

    static Long getWecomId(Long dataKey, String corpid) {
        String pid = ((SyncRepoProc)SpringContextHolder.getBean(SyncRepoProc.class)).getOuterDataKey(SyncDataType.ORG.name(), dataKey.toString(), corpid);
        return StringUtils.hasText((String)pid) ? Long.valueOf(Long.parseLong(pid)) : null;
    }

    static Map<Long, Long> getWecomIds(Collection<Long> dataKeys, String corpid) {
        List keys = dataKeys.stream().map(Object::toString).collect(Collectors.toList());
        Map pidList = ((SyncRepoProc)SpringContextHolder.getBean(SyncRepoProc.class)).getOuterDataKeys(SyncDataType.ORG.name(), keys, corpid);
        if (pidList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(pidList.size());
        for (Map.Entry entry : pidList.entrySet()) {
            result.put(Long.parseLong((String)entry.getKey()), Long.parseLong((String)entry.getValue()));
        }
        return result;
    }
}

