/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.usersync.jde;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.vo.save.user.sync.JdeUserSaveVO;
import com.elitescloud.cloudt.system.provider.usersync.SyncUserResult;
import com.elitescloud.cloudt.system.provider.usersync.UserSyncProvider;
import com.elitescloud.cloudt.system.provider.usersync.jde.params.JdeUserSyncDTO;
import com.elitescloud.cloudt.system.provider.usersync.jde.params.JdeUserSyncResultDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import io.jsonwebtoken.lang.Assert;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

@Component
public class JdeUserSyncProvider
implements UserSyncProvider<JdeUserSaveVO, JdeUserSyncDTO> {
    private static final Logger logger = LoggerFactory.getLogger(JdeUserSyncProvider.class);
    public static final String CODE = "JDE";
    private final RestTemplate restTemplate = RestTemplateFactory.instance();
    @Autowired
    private SystemProperties props;

    @Override
    public String sysCode() {
        return CODE;
    }

    @Override
    public String sysName() {
        return "ERP";
    }

    @Override
    public String getSyncUrl() {
        return this.props.getJdeConfig().getServerAddr();
    }

    @Override
    public JdeUserSyncDTO convertSyncData(HttpServletRequest request, SysUserBasicDTO userDTO, JdeUserSaveVO reqData) {
        JdeUserSyncDTO dto = new JdeUserSyncDTO();
        dto.setUluser(reqData.getJdeAccount());
        dto.setUllngp(reqData.getJdeLang());
        dto.setUlutctime(reqData.getJdeTimeZone());
        return dto;
    }

    @Override
    public SyncUserResult syncUser(Long userId, JdeUserSyncDTO syncData) {
        try {
            return this.executeSync(userId, syncData);
        }
        catch (RestClientResponseException e) {
            throw new BusinessException("\u540c\u6b65\u8d26\u53f7\u5931\u8d25\uff0c\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getRawStatusCode() + "-" + e.getStatusText(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65\u8d26\u53f7\u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    private SyncUserResult executeSync(Long userId, JdeUserSyncDTO syncData) throws Exception {
        String url = this.props.getJdeConfig().getServerAddr();
        Assert.hasText((String)url, (String)(this.sysName() + "\u670d\u52a1\u7aef\u5730\u5740\u672a\u914d\u7f6e"));
        String clientId = this.props.getJdeConfig().getClientId();
        Assert.hasText((String)clientId, (String)"\u5ba2\u6237\u7aefID\u672a\u914d\u7f6e");
        String clientSecret = this.props.getJdeConfig().getClientSecret();
        Assert.hasText((String)clientSecret, (String)"\u5ba2\u6237\u7aef\u5bc6\u7801\u672a\u914d\u7f6e");
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(clientId, clientSecret, StandardCharsets.UTF_8);
        ResponseEntity respResult = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)syncData, (MultiValueMap)headers), String.class, new Object[0]);
        if (!respResult.getStatusCode().is2xxSuccessful()) {
            logger.info("\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38\uff1a{}, {}", (Object)url, (Object)respResult);
            throw new BusinessException("\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38\uff1a" + url + "\uff0c" + String.valueOf(respResult.getStatusCode()));
        }
        SyncUserResult syncUserResult = new SyncUserResult(userId);
        syncUserResult.setOuterUserCode(syncData.getUluser());
        syncUserResult.setReceipt((String)respResult.getBody());
        JdeUserSyncResultDTO jdeResult = this.convertJdeResult((String)respResult.getBody());
        syncUserResult.setSuccess(Boolean.TRUE.equals(jdeResult.getSuccess()));
        if (!syncUserResult.isSuccess()) {
            syncUserResult.setFailMsg(jdeResult.getMessage());
        }
        return syncUserResult;
    }

    private JdeUserSyncResultDTO convertJdeResult(String result) {
        JdeUserSyncResultDTO jdeResult;
        block2: {
            jdeResult = null;
            try {
                jdeResult = (JdeUserSyncResultDTO)JSONUtil.json2Obj((String)result, JdeUserSyncResultDTO.class, (boolean)true);
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362JDE\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)result, (Object)e);
                jdeResult = new JdeUserSyncResultDTO();
                jdeResult.setSuccess(false);
                HashMap mapResult = (HashMap)JSONUtil.json2Obj((String)result, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                if (mapResult == null) break block2;
                jdeResult.setSuccess(Boolean.FALSE.equals(mapResult.get("success")));
                jdeResult.setMessage(ObjUtil.defaultIfNull(mapResult.get("message"), (Object)result).toString());
            }
        }
        return jdeResult;
    }
}

