/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import com.elitescloud.cloudt.system.service.MenuMngService;
import com.elitescloud.cloudt.system.service.MenuQueryService;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/Menu"}, produces={"application/json"})
public class SysMenuRpcServiceImpl
implements SysMenuRpcService {
    private SysPlatformMenusRepo sysPlatformMenusRepo;
    private MenuMngService mngService;
    private MenuQueryService queryService;
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;

    public ApiResult<Long> addMenu(SysMenuSaveDTO saveDTO) {
        return this.mngService.addMenu(saveDTO);
    }

    public ApiResult<String> removeMenu(String menuCode) {
        return this.mngService.removeMenu(menuCode);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public ApiResult<List<SysPlatformMenusDTO>> getPlatformMenuByAppCodeList(List<String> appCodeList) {
        ArrayList listDto = new ArrayList();
        this.sysPlatformMenusRepo.findAll((Predicate)SysMenuRpcServiceImpl.QDO.menusAppCode.in(appCodeList)).iterator().forEachRemaining(sysPlatformMenusDO -> listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO)));
        return ApiResult.ok(listDto);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public ApiResult<List<SysPlatformMenusDTO>> getTenantMenuByAppCodeList(Long tenantId, List<String> appCodeList) {
        ArrayList listDto = new ArrayList();
        this.sysPlatformMenusRepo.findAll((Predicate)SysMenuRpcServiceImpl.QDO.menusAppCode.in(appCodeList).and((Predicate)SysMenuRpcServiceImpl.QDO.tenantId.eq((Object)tenantId))).iterator().forEachRemaining(sysPlatformMenusDO -> listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO)));
        return ApiResult.ok(listDto);
    }

    public ApiResult<SysPlatformMenusDTO> getMenuInfo(String menuCode) {
        return this.queryService.getMenuInfo(menuCode);
    }

    public ApiResult<List<SysPlatformMenusDTO>> getMenuInfo(Set<String> menuCodes) {
        return this.queryService.getMenuInfo(menuCodes);
    }

    public ApiResult<List<IdCodeNameParam>> getMenuWithParents(String menuCode) {
        return this.queryService.getMenuWithParents(menuCode);
    }

    @Autowired
    public void setSysPlatformMenusRepo(SysPlatformMenusRepo sysPlatformMenusRepo) {
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
    }

    @Autowired
    public void setMngService(MenuMngService mngService) {
        this.mngService = mngService;
    }

    @Autowired
    public void setQueryService(MenuQueryService queryService) {
        this.queryService = queryService;
    }
}

