/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc.org;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgDetailRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.service.OrgMngService;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/org"}, produces={"application/json"})
public class OrgRpcServiceImpl
implements OrgRpcService {
    private OrgQueryService queryService;
    private OrgMngService mngService;

    public ApiResult<Long> upsert(OrgUpsertDTO upsertDTO) {
        return this.mngService.upsert(upsertDTO);
    }

    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        return this.mngService.updateEnabled(id, enabled);
    }

    public ApiResult<Boolean> rebuildtree(Long rootId) {
        return this.mngService.updateTreeRebuild(rootId);
    }

    public ApiResult<Long> delete(Long id) {
        return this.mngService.delete(id);
    }

    public ApiResult<SysOrgBasicDTO> getById(Long id) {
        return this.queryService.getById(id);
    }

    public ApiResult<SysOrgDetailRespDTO> getDetailById(Long id, String withParentType) {
        return this.queryService.getDetailById(id, withParentType);
    }

    public ApiResult<SysOrgBasicDTO> getByCode(String code) {
        return this.queryService.getByCode(code);
    }

    public ApiResult<SysOrgDetailRespDTO> getDetailByCode(String code, String withParentType) {
        return this.queryService.getDetailByCode(code, withParentType);
    }

    public ApiResult<SysOrgBasicDTO> getParentByCode(String code, String parentType) {
        return this.queryService.getParentByCode(code, parentType);
    }

    public ApiResult<Map<String, SysOrgBasicDTO>> getParentByCode(Set<String> codes, String parentType) {
        return this.queryService.getParentByCode(codes, parentType);
    }

    public ApiResult<List<IdCodeNameParam>> queryChildren(String code) {
        return this.queryService.queryChildren(code);
    }

    public ApiResult<Map<String, List<IdCodeNameParam>>> queryChildrenList(Set<String> codes) {
        return this.queryService.queryChildrenList(codes);
    }

    public ApiResult<List<SysOrgBasicDTO>> queryList(SysOrgQueryDTO queryDTO) {
        return this.queryService.queryList(queryDTO);
    }

    public ApiResult<PagingVO<SysOrgPageRespDTO>> queryPage(SysOrgPageQueryDTO queryDTO) {
        return this.queryService.queryPage(queryDTO);
    }

    public ApiResult<List<IdCodeNameParam>> queryCodeAndName(Set<Long> ids) {
        return this.queryService.queryCodeAndName(ids);
    }

    public ApiResult<IdCodeNameParam> getCodeAndName(Long id) {
        ApiResult<List<IdCodeNameParam>> result = this.queryService.queryCodeAndName(Set.of(id));
        if (result.isFailed()) {
            return ApiResult.fail((String)result.getMsg());
        }
        return ApiResult.ok(CollUtil.isEmpty((Collection)((Collection)result.getData())) ? null : (IdCodeNameParam)((List)result.getData()).get(0));
    }

    public ApiResult<List<IdCodeNameParam>> queryIdAndName(Set<String> codes) {
        return this.queryService.queryIdAndName(codes);
    }

    public ApiResult<IdCodeNameParam> getIdAndName(String code) {
        ApiResult<List<IdCodeNameParam>> result = this.queryService.queryIdAndName(Set.of(code));
        if (result.isFailed()) {
            return ApiResult.fail((String)result.getMsg());
        }
        return ApiResult.ok(CollUtil.isEmpty((Collection)((Collection)result.getData())) ? null : (IdCodeNameParam)((List)result.getData()).get(0));
    }

    @Autowired
    public void setOrgQueryService(OrgQueryService queryService) {
        this.queryService = queryService;
    }

    @Autowired
    public void setOrgMngService(OrgMngService mngService) {
        this.mngService = mngService;
    }
}

