/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.alert;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;
import com.elitescloud.cloudt.system.service.alert.AlertProvider;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAlertProvider<T extends AlertConfigBaseSaveVO, R extends AlertConfigBaseRespVO>
implements AlertProvider<T, R> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAlertProvider.class);
    private final RedisUtils redisUtils;

    public AbstractAlertProvider(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }

    protected boolean isDuplicate(BaseCfg cfg, Map<String, Object> tmplParams, String category) {
        if (!Boolean.TRUE.equals(cfg.getDeduplicate())) {
            return false;
        }
        StringBuffer txt = new StringBuffer();
        for (String field : cfg.getDeduplicateFields()) {
            String key = this.normalizeTmplField(field);
            String value = ObjectUtil.defaultIfNull((Object)tmplParams.get(key), (Object)"").toString();
            if (CharSequenceUtil.isBlank((CharSequence)value)) continue;
            txt.append(value + ":");
        }
        if (txt.length() == 0) {
            return false;
        }
        String digestHex = MD5.create().digestHex((String)ObjectUtil.defaultIfNull((Object)category, (Object)"default") + ":" + String.valueOf(txt), StandardCharsets.UTF_8);
        Boolean exists = this.redisUtils.getRedisTemplate().opsForValue().setIfAbsent((Object)digestHex, (Object)"1", Duration.ofMinutes(cfg.getDeduplicateIntervals().intValue()));
        logger.info("\u53bb\u91cd\uff1a{}\uff0c{}", (Object)txt, (Object)exists);
        return exists != null && exists == false;
    }

    protected String normalizeTmplField(String tmplField) {
        return CharSequenceUtil.strip((CharSequence)tmplField, (CharSequence)"{", (CharSequence)"}");
    }

    static class BaseCfg
    implements Serializable {
        private static final long serialVersionUID = -3924675064627694599L;
        private String tmplContent;
        private Boolean deduplicate;
        private List<String> deduplicateFields;
        private Integer deduplicateIntervals;

        public BaseCfg(String tmplContent) {
            this.tmplContent = tmplContent;
        }

        public String getTmplContent() {
            return this.tmplContent;
        }

        public void setTmplContent(String tmplContent) {
            this.tmplContent = tmplContent;
        }

        public Boolean getDeduplicate() {
            return this.deduplicate;
        }

        public void setDeduplicate(Boolean deduplicate) {
            this.deduplicate = deduplicate;
        }

        public List<String> getDeduplicateFields() {
            return this.deduplicateFields;
        }

        public void setDeduplicateFields(List<String> deduplicateFields) {
            this.deduplicateFields = deduplicateFields;
        }

        public Integer getDeduplicateIntervals() {
            return this.deduplicateIntervals;
        }

        public void setDeduplicateIntervals(Integer deduplicateIntervals) {
            this.deduplicateIntervals = deduplicateIntervals;
        }
    }
}

