/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.alert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.nacos.common.codec.Base64;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigDingdingRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigDingdingSaveVO;
import com.elitescloud.cloudt.system.service.alert.AbstractAlertProvider;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DingdingAlertProvider
extends AbstractAlertProvider<AlertConfigDingdingSaveVO, AlertConfigDingdingRespVO> {
    private static final Logger logger = LoggerFactory.getLogger(DingdingAlertProvider.class);
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    public DingdingAlertProvider(RedisUtils redisUtils) {
        super(redisUtils);
    }

    @Override
    public SysAlertType alertType() {
        return SysAlertType.DINGDING;
    }

    @Override
    public String toString(AlertConfigDingdingSaveVO saveVO) {
        if (saveVO == null) {
            return null;
        }
        Assert.notEmpty(saveVO.getWebhookUrls(), (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Cfg cfg = new Cfg(saveVO.getWebhookUrls(), saveVO.getTmplContent());
        cfg.setSecret(saveVO.getSecret());
        boolean deduplicate = (Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getDeduplicate(), (Object)false);
        cfg.setDeduplicate(deduplicate);
        cfg.setDeduplicateFields(saveVO.getDeduplicateFields());
        cfg.setDeduplicateIntervals((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getDeduplicateIntervals(), (Object)0));
        if (deduplicate) {
            Assert.notEmpty(cfg.getDeduplicateFields(), (String)"\u8bf7\u9009\u62e9\u53bb\u91cd\u5b57\u6bb5", (Object[])new Object[0]);
            Assert.isTrue((cfg.getDeduplicateIntervals() > 0 ? 1 : 0) != 0, (String)"\u53bb\u91cd\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        }
        return JSONUtil.toJsonString((Object)cfg);
    }

    @Override
    public AlertConfigDingdingRespVO parse(String cfgJson) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            return null;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        AlertConfigDingdingRespVO respVO = new AlertConfigDingdingRespVO();
        respVO.setWebhookUrls(cfg.getWebhookUrlMap());
        respVO.setTmplContent(cfg.getTmplContent());
        respVO.setSecret(cfg.getSecret());
        boolean deduplicate = (Boolean)ObjectUtil.defaultIfNull((Object)cfg.getDeduplicate(), (Object)false);
        respVO.setDeduplicate(deduplicate);
        respVO.setDeduplicateFields((List)ObjectUtil.defaultIfNull(cfg.getDeduplicateFields(), Collections.emptyList()));
        respVO.setDeduplicateIntervals((Integer)ObjectUtil.defaultIfNull((Object)cfg.getDeduplicateIntervals(), (Object)0));
        return respVO;
    }

    @Override
    public boolean send(String cfgJson, String content, String category) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        return this.execute(cfg, content, category);
    }

    @Override
    public boolean sendByTmpl(String cfgJson, Map<String, Object> tmplParams, String category) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        String tmplContent = cfg.getTmplContent();
        if (CharSequenceUtil.isBlank((CharSequence)tmplContent)) {
            logger.info("\u6a21\u677f\u5185\u5bb9\u672a\u914d\u7f6e\uff1a{}", (Object)cfgJson);
            return false;
        }
        if (this.isDuplicate(cfg, tmplParams, category)) {
            logger.info("\u6d88\u606f\u91cd\u590d\uff1a{}", (Object)JSONUtil.toJsonString((Object)cfgJson));
            return false;
        }
        String content = StrUtil.format((CharSequence)tmplContent, tmplParams, (boolean)true);
        return this.execute(cfg, content, category);
    }

    private boolean execute(Cfg cfg, String content, String category) {
        List<String> urls;
        List<String> list = urls = CollUtil.isEmpty(cfg.getWebhookUrlMap()) ? null : cfg.getWebhookUrlMap().get(CharSequenceUtil.blankToDefault((CharSequence)category, (String)"default"));
        if (urls != null) {
            urls = urls.stream().filter(StringUtils::hasText).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty((Collection)urls)) {
            logger.info("\u9489\u9489\u5730\u5740\u914d\u7f6e\u672a\u914d\u7f6e\uff1a{}\uff0c{}", (Object)category, (Object)JSONUtil.toJsonString((Object)cfg));
            return false;
        }
        for (String webhookUrl : urls) {
            this.execute(webhookUrl, cfg.getSecret(), content);
        }
        return true;
    }

    private void execute(String url, String secret, String content) {
        if (StrUtil.isNotBlank((CharSequence)secret)) {
            Long timestamp = System.currentTimeMillis();
            String sign = null;
            try {
                String stringToSign = timestamp + "\n" + secret;
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                logger.error("\u7b7e\u540d\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            }
            url = (String)url + "&timestamp=" + timestamp + "&sign=" + sign;
        }
        logger.info("\u3010\u9489\u9489\u673a\u5668\u4eba\u3011\u53d1\u9001\u9884\u8b66\uff1a{}, {}", url, (Object)content);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("msgtype", "markdown");
        body.put("markdown", Map.of("title", "\u9884\u8b66\u63d0\u9192", "text", content));
        MsgSendStateEnum state = MsgSendStateEnum.FAILED;
        String msg = "\u53d1\u9001\u5931\u8d25";
        String receipt = null;
        ResponseEntity resp = null;
        try {
            resp = this.restTemplate.exchange((String)url, HttpMethod.POST, new HttpEntity(body), String.class, new Object[0]);
            receipt = (String)resp.getBody();
            if (resp.getStatusCode().is2xxSuccessful()) {
                logger.info("\u53d1\u9001\u6210\u529f\uff01");
            }
        }
        catch (RestClientException e) {
            logger.error("\u53d1\u9001\u9884\u8b66\u5f02\u5e38\uff1a", (Throwable)e);
            return;
        }
        logger.info("\u53d1\u9001\u5931\u8d25\uff1a{}, {}", (Object)resp.getStatusCodeValue(), resp.getBody());
    }

    private Cfg parseCfg(String cfgJson) {
        Cfg cfg = (Cfg)JSONUtil.json2Obj((String)cfgJson, Cfg.class);
        if (CollUtil.isEmpty(cfg.getWebhookUrlMap()) && CollUtil.isNotEmpty(cfg.getWebhookUrls())) {
            cfg.setWebhookUrlMap(Map.of("default", cfg.getWebhookUrls()));
        }
        return cfg;
    }

    static class Cfg
    extends AbstractAlertProvider.BaseCfg
    implements Serializable {
        private static final long serialVersionUID = 4537456626636877998L;
        private List<String> webhookUrls;
        private Map<String, List<String>> webhookUrlMap;
        private String secret;

        public Cfg(Map<String, List<String>> webhookUrlMap, String tmplContent) {
            super(tmplContent);
            this.webhookUrlMap = webhookUrlMap;
        }

        public Cfg() {
            super(null);
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public Map<String, List<String>> getWebhookUrlMap() {
            return this.webhookUrlMap;
        }

        public void setWebhookUrlMap(Map<String, List<String>> webhookUrlMap) {
            this.webhookUrlMap = webhookUrlMap;
        }

        public List<String> getWebhookUrls() {
            return this.webhookUrls;
        }

        public void setWebhookUrls(List<String> webhookUrls) {
            this.webhookUrls = webhookUrls;
        }
    }
}

