/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.impl.SystemDataServiceImpl;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public abstract class AbstractBasicDataInitProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBasicDataInitProvider.class);
    private List<AbstractBasicDataInitProvider> children;
    private String databaseType;

    public abstract String typeName();

    public abstract String tableName();

    public abstract List<String> fields();

    public abstract Map<String, String> fieldTitles();

    public boolean isTenantData() {
        return false;
    }

    public String tenantField() {
        return "tenant_id";
    }

    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"create_time"));
    }

    public abstract String fieldAppCode();

    public void prepareExport(File workDir) {
    }

    public void prepareForImport(SystemDataServiceImpl.ImportedData importData, Long tenantId) {
    }

    public void afterExecute(boolean export, Throwable e) {
    }

    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        return data;
    }

    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        return UpdateType.IGNORE;
    }

    public final List<AbstractBasicDataInitProvider> thenImport() {
        return (List)ObjectUtil.defaultIfNull(this.children, Collections.emptyList());
    }

    public final AbstractBasicDataInitProvider thenImport(AbstractBasicDataInitProvider ... children) {
        if (ArrayUtil.isNotEmpty((Object[])children)) {
            this.children = Arrays.asList(children);
        }
        return this;
    }

    public Object normalizeSqlParam(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "".equals(value) ? null : value;
        }
        String db = this.getDataBaseType();
        if (db == null) {
            return value;
        }
        db = db.toUpperCase();
        if (value instanceof Boolean) {
            if (db.equals(Database.POSTGRESQL.name())) {
                return value;
            }
            return (Boolean)value != false ? 1 : 0;
        }
        return value;
    }

    public Map<String, Object> normalizeSqlParams(Map<String, Object> param) {
        HashMap<String, Object> newParam = new HashMap<String, Object>(param);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            Object value = this.normalizeSqlParam(entry.getValue());
            newParam.put(entry.getKey(), value);
        }
        return newParam;
    }

    private String getDataBaseType() {
        if (StringUtils.hasText((String)this.databaseType)) {
            return this.databaseType;
        }
        try {
            this.databaseType = ((DataSource)SpringContextHolder.getBean(DataSource.class)).getConnection().getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return this.databaseType;
    }

    final void normalizeBooleanValue(Map<String, Object> data, String key) {
        Boolean value = this.getBooleanValue(data.get(key), null);
        data.put(key, value);
    }

    final Boolean getBooleanValue(Object value, Boolean def) {
        if (value == null) {
            return def;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value == 1;
        }
        if (value.toString().equalsIgnoreCase("true")) {
            return true;
        }
        if (value.toString().equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    final String getStringValue(Map<String, Object> map, String key, String def) {
        Object value = map.get(key);
        if (value == null || CharSequenceUtil.isBlank((CharSequence)value.toString())) {
            return def;
        }
        return value.toString();
    }

    final void normalizeLongValue(Map<String, Object> map, String key) {
        map.put(key, this.getLongValue(map, key, null));
    }

    final Long getLongValue(Map<String, Object> map, String key, Long def) {
        Object value = map.get(key);
        if (value == null) {
            return def;
        }
        if (CharSequenceUtil.isBlank((CharSequence)value.toString())) {
            return def;
        }
        return Long.parseLong(value.toString());
    }

    final void normalizeIntegerValue(Map<String, Object> map, String key) {
        map.put(key, this.getIntegerValue(map, key, null));
    }

    final Integer getIntegerValue(Map<String, Object> map, String key, Integer def) {
        Object value = map.get(key);
        if (value == null) {
            return def;
        }
        if (CharSequenceUtil.isBlank((CharSequence)value.toString())) {
            return def;
        }
        return Integer.parseInt(value.toString());
    }

    public static enum UpdateType {
        ADD,
        UPDATE,
        IGNORE;

    }
}

