/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.AreaMngService;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.task.TaskExecutor;

public class PlatformAreaInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u884c\u653f\u533a\u57df";
    }

    @Override
    public String tableName() {
        return "sys_platform_area";
    }

    @Override
    public List<String> fields() {
        return List.of("id", "area_name", "area_code", "parent_area_code", "short_name", "area_type", "zip_code", "enabled", "sort_no", "pinyin", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("id", "ID");
        titles.put("area_name", "\u540d\u79f0");
        titles.put("area_code", "\u7f16\u7801");
        titles.put("parent_area_code", "\u4e0a\u7ea7\u7f16\u7801");
        titles.put("short_name", "\u7b80\u79f0");
        titles.put("area_type", "\u533a\u57df\u7c7b\u578b");
        titles.put("zip_code", "\u90ae\u7f16");
        titles.put("sort_no", "\u987a\u5e8f");
        titles.put("pinyin", "\u62fc\u97f3");
        titles.put("enabled", "\u72b6\u6001");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"area_code"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String area_code = this.getStringValue(data, "area_code", null);
        Assert.notBlank((CharSequence)area_code, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "enabled");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.stream().filter(t -> area_code.equals(t.get("area_code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    @Override
    public void afterExecute(boolean export, Throwable e) {
        if (export || e != null) {
            return;
        }
        ((TaskExecutor)SpringContextHolder.getBean(TaskExecutor.class)).execute(() -> ((AreaMngService)SpringContextHolder.getBean(AreaMngService.class)).rebuildTree(null));
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("enabled", this.getBooleanValue(data.get("enabled"), true));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("enabled", ObjectUtil.defaultIfNull((Object)dataExists.get("enabled"), (Object)this.getBooleanValue(data.get("enabled"), true)));
    }
}

