/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlatformCurrencyInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u8d27\u5e01";
    }

    @Override
    public String tableName() {
        return "sys_platform_currency";
    }

    @Override
    public List<String> fields() {
        return List.of("curr_code", "curr_name", "disp_decimal", "enabled", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("curr_code", "\u8d27\u5e01\u7f16\u7801");
        titles.put("curr_name", "\u8d27\u5e01\u540d\u79f0");
        titles.put("disp_decimal", "\u5c0f\u6570\u4f4d\u6570");
        titles.put("enabled", "\u72b6\u6001");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String curr_code = this.getStringValue(data, "curr_code", null);
        Assert.notBlank((CharSequence)curr_code, (String)"\u8d27\u5e01\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "enabled");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.parallelStream().filter(t -> curr_code.equals(t.get("curr_code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("enabled", this.getBooleanValue(data.get("enabled"), true));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("enabled", ObjectUtil.defaultIfNull((Object)dataExists.get("enabled"), (Object)this.getBooleanValue(data.get("enabled"), true)));
    }
}

