/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import com.elitescloud.cloudt.system.service.impl.SystemDataServiceImpl;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformMenusApiInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(PlatformMenusApiInitProvider.class);
    private Map<String, SysPlatformAppDO> appMap;
    private Map<String, SysPlatformMenusDO> menuMap;

    @Override
    public String typeName() {
        return "\u83dc\u5355\u4e0eAPI\u63a5\u53e3\u7ed1\u5b9a";
    }

    @Override
    public String tableName() {
        return "sys_platform_menus_api";
    }

    @Override
    public List<String> fields() {
        return List.of("menus_id", "api_id", "app_code", "menus_code", "api_code", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("menus_code", "\u83dc\u5355\u7f16\u7801");
        titles.put("api_code", "\u63a5\u53e3\u7f16\u7801");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public void prepareForImport(SystemDataServiceImpl.ImportedData importData, Long tenantId) {
        this.appMap = ((AppRepoProc)SpringContextHolder.getBean(AppRepoProc.class)).all().stream().collect(Collectors.toMap(SysPlatformAppDO::getAppCode, t -> t, (t1, t2) -> t1));
        this.menuMap = ((MenuRepoProc)((Object)SpringContextHolder.getBean(MenuRepoProc.class))).all().stream().collect(Collectors.toMap(SysPlatformMenusDO::getMenusCode, t -> t, (t1, t2) -> t1));
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        if (CollUtil.isEmpty(lastStepData)) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        String apiCode = this.getStringValue(data, "api_code", null);
        if (CharSequenceUtil.isBlank((CharSequence)apiCode)) {
            Long originalApiId = this.getLongValue(data, "api_id", null);
            Assert.notNull((Object)originalApiId, (String)"\u7f3a\u5c11api_id", (Object[])new Object[0]);
            Map<String, Object> originalApiMap = lastStepData.parallelStream().filter(t -> Objects.equals(originalApiId, t.get("original_id"))).findFirst().orElse(Collections.emptyMap());
            apiCode = this.getStringValue(originalApiMap, "api_code", null);
            if (CharSequenceUtil.isBlank((CharSequence)apiCode)) {
                log.info("\u672a\u67e5\u8be2\u5230API\uff1a{}", (Object)originalApiId);
                return AbstractBasicDataInitProvider.UpdateType.IGNORE;
            }
        }
        String appCode = this.getStringValue(data, "app_code", null);
        Assert.notBlank((CharSequence)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String menusCode = this.getStringValue(data, "menus_code", null);
        Assert.notBlank((CharSequence)menusCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        String finalApiCode = apiCode;
        Object id = currentData.stream().filter(t -> appCode.equals(t.get("app_code")) && menusCode.equals(t.get("menus_code")) && finalApiCode.equals(t.get("api_code"))).findFirst().map(t -> t.get("id")).orElse(null);
        if (id != null) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        Long apiId = lastStepData.parallelStream().filter(t -> finalApiCode.equals(this.getStringValue((Map<String, Object>)t, "api_code", ""))).findFirst().map(t -> this.getLongValue((Map<String, Object>)t, "id", null)).orElse(null);
        if (apiId == null) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        if (CollUtil.isEmpty(this.appMap)) {
            log.info("\u5e94\u7528\u4e3a\u7a7a\uff0c\u5ffd\u7565");
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        if (CollUtil.isEmpty(this.menuMap)) {
            log.info("\u83dc\u5355\u4e3a\u7a7a\uff0c\u5ffd\u7565");
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        SysPlatformMenusDO menu = this.menuMap.get(menusCode);
        if (menu == null) {
            log.info("\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565");
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        data.put("id", null);
        data.put("api_id", apiId);
        data.put("menus_id", menu.getId());
        return AbstractBasicDataInitProvider.UpdateType.ADD;
    }
}

