/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.constant.NextValuePeriod;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlatformNextNumberInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u4e0b\u4e00\u7f16\u53f7";
    }

    @Override
    public String tableName() {
        return "sys_platform_next_number";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "app_code", "code", "name", "step", "next_number", "nn_period", "nn_time", "version", "enabled", "internal", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("code", "\u7f16\u7801");
        titles.put("name", "\u540d\u79f0");
        titles.put("step", "\u6b65\u957f");
        titles.put("nn_period", "\u7f16\u53f7\u5468\u671f");
        titles.put("nn_period_name", "\u7f16\u53f7\u5468\u671f\u540d\u79f0");
        titles.put("internal", "\u662f\u5426\u5185\u7f6e");
        titles.put("next_number", "\u4e0b\u4e00\u7f16\u53f7");
        titles.put("enabled", "\u662f\u5426\u542f\u7528");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"app_code"), OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        NextValuePeriod type = NextValuePeriod.parse((String)ObjectUtil.defaultIfNull((Object)data.get("nn_period"), (Object)"").toString());
        if (type != null) {
            data.put("nn_period_name", type.getDescription());
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String code = this.getStringValue(data, "code", null);
        Assert.notBlank((CharSequence)code, (String)"\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "internal");
        this.normalizeBooleanValue(data, "enabled");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.stream().filter(t -> code.equals(t.get("code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        return AbstractBasicDataInitProvider.UpdateType.IGNORE;
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("enabled", this.getBooleanValue(data.get("enabled"), true));
    }
}

