/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.task.TaskExecutor;

public class PlatformNumberRuleDtlInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u53d1\u53f7\u89c4\u5219\u660e\u7ec6";
    }

    @Override
    public String tableName() {
        return "sys_platform_number_ruledtl";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "modify_time", "app_code", "rule_id", "seq", "number_type", "number_pattern", "nn_len", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("rule_id", "\u89c4\u5219ID");
        titles.put("seq", "\u987a\u5e8f");
        titles.put("number_type", "\u53d6\u53f7\u7c7b\u578b");
        titles.put("number_pattern", "\u53d6\u53f7\u6a21\u5f0f");
        titles.put("nn_len", "\u5e8f\u53f7\u5bbd\u5ea6");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"app_code"), OrderItem.desc((String)"rule_id"), OrderItem.asc((String)"seq"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        Long rule_id_original = this.getLongValue(data, "rule_id", null);
        Assert.notNull((Object)rule_id_original, (String)"\u89c4\u5219ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(lastStepData, (String)"\u53d1\u53f7\u89c4\u5219\u4e3a\u7a7a", (Object[])new Object[0]);
        Long rule_id = lastStepData.parallelStream().filter(t -> rule_id_original.longValue() == ((Long)ObjUtil.defaultIfNull((Object)((Long)t.get("original_id")), (Object)-1L)).longValue()).findFirst().map(t -> t.get("id")).orElse(null);
        if (rule_id == null) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        data.put("rule_id", rule_id);
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        boolean exists = currentData.stream().anyMatch(t -> rule_id.longValue() == ((Long)ObjUtil.defaultIfNull((Object)((Long)t.get("rule_id")), (Object)-1L)).longValue());
        if (exists) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        return AbstractBasicDataInitProvider.UpdateType.ADD;
    }

    @Override
    public void afterExecute(boolean export, Throwable e) {
        if (e == null || export) {
            return;
        }
        ((TaskExecutor)SpringContextHolder.getBean(TaskExecutor.class)).execute(() -> {
            SysTenantBasicDataService tenantBasicDataService = (SysTenantBasicDataService)SpringContextHolder.getBean(SysTenantBasicDataService.class);
            ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getAllTenants().forEach(tenant -> tenantBasicDataService.syncSequence(tenant.getId()));
        });
    }
}

