/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlatformNumberRuleInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u53d1\u53f7\u89c4\u5219";
    }

    @Override
    public String tableName() {
        return "sys_platform_number_rule";
    }

    @Override
    public List<String> fields() {
        return List.of("id", "create_time", "modify_time", "app_code", "rule_code", "rule_name", "sample_code", "enabled", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("id", "ID");
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("rule_code", "\u89c4\u5219\u7f16\u7801");
        titles.put("rule_name", "\u540d\u79f0");
        titles.put("sample_code", "\u793a\u4f8b");
        titles.put("enabled", "\u72b6\u6001");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"app_code"), OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String rule_code = this.getStringValue(data, "rule_code", null);
        Assert.notBlank((CharSequence)rule_code, (String)"\u53d1\u53f7\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Long id = this.getLongValue(data, "id", null);
        Assert.notNull((Object)id, (String)"\u53d1\u53f7\u89c4\u5219ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "enabled");
        data.put("original_id", id);
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Object currentId = currentData.stream().filter(t -> rule_code.equals(t.get("rule_code"))).findFirst().map(t -> t.get("id")).orElse(null);
        data.put("id", currentId);
        return currentId == null ? AbstractBasicDataInitProvider.UpdateType.ADD : AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }
}

