/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.AreaType;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.platform.convert.SysPlatformAreaConvert;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.platform.provider.area.GrabAreaCodeTool;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAreaRepo;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.provider.imports.param.ImportAreaBO;
import com.elitescloud.cloudt.system.service.AreaMngService;
import com.elitescloud.cloudt.system.service.manager.AreaManager;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAreaDO;
import com.elitescloud.cloudt.system.service.repo.AreaRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantAreaRepoProc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class AreaMngServiceImpl
extends BaseServiceImpl
implements AreaMngService {
    private static final Logger logger = LoggerFactory.getLogger(AreaMngServiceImpl.class);
    private static final SysPlatformAreaConvert CONVERT = SysPlatformAreaConvert.INSTANCE;
    @Autowired
    private TenantAreaRepoProc tenantAreaRepoProc;
    @Autowired
    private SysPlatformAreaRepo areaRepo;
    @Autowired
    private AreaRepoProc areaRepoProc;
    @Autowired
    private AreaManager areaManager;

    @Override
    public ApiResult<Boolean> getEnabledPlatform() {
        boolean enabled = this.enabledPlatform();
        return ApiResult.ok((Object)enabled);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateEnabledPlatform() {
        this.areaManager.clearCache();
        Long tenantId = super.currentTenantId();
        Boolean enabled = this.tenantAreaRepoProc.getEnabled(tenantId.longValue());
        if (enabled == null) {
            SysTenantAreaDO tenantAreaDO = new SysTenantAreaDO();
            tenantAreaDO.setSysTenantId(tenantId);
            tenantAreaDO.setEnabled(Boolean.valueOf(tenantId.longValue() != TenantConstant.DEFAULT_TENANT_ID.longValue()));
            this.tenantAreaRepoProc.save((Serializable)tenantAreaDO);
            return ApiResult.ok((Object)tenantAreaDO.getEnabled());
        }
        enabled = enabled == false;
        this.tenantAreaRepoProc.updateEnabled(tenantId.longValue(), enabled);
        return ApiResult.ok((Object)enabled);
    }

    @Override
    public ApiResult<List<AreaMngTreeRespVO>> tree(Boolean tree) {
        boolean enabled = this.enabledPlatform();
        List areaList = null;
        areaList = enabled || TenantConstant.DEFAULT_TENANT_ID.longValue() == super.currentTenantId().longValue() ? (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.areaRepoProc.getTree(null, null, null, this::do2TreeRespVO)) : this.areaRepoProc.getTree(null, null, null, this::do2TreeRespVO);
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)tree, (Object)true)).booleanValue() || areaList.isEmpty()) {
            return ApiResult.ok((Object)areaList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(areaList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        List result = treeDataUtil.getRoots();
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PlatformAreaSaveVO saveVO) {
        Long parentId;
        this.validatePermission();
        SysPlatformAreaDO areaDO = null;
        try {
            areaDO = saveVO.getId() == null ? this.checkForInsert(saveVO) : this.checkForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.areaManager.clearCache();
        Long l = parentId = StringUtils.hasText((String)areaDO.getParentAreaCode()) ? this.areaRepoProc.getId(areaDO.getParentAreaCode()) : null;
        if (areaDO.getEnabled() == null) {
            areaDO.setEnabled(Boolean.valueOf(true));
        }
        if (areaDO.getSortNo() == null) {
            areaDO.setSortNo(Integer.valueOf(this.areaRepoProc.findMaxSortNo(parentId) + 1));
        }
        String oldCodePath = saveVO.getId() == null ? null : this.areaRepoProc.getCodePath(saveVO.getId().longValue());
        this.areaRepo.save((Object)areaDO);
        this.areaRepoProc.saveTreeNode((BaseTreeModel)areaDO, parentId, areaDO.getSortNo());
        if (oldCodePath != null && !StrUtil.equals((CharSequence)oldCodePath, (CharSequence)areaDO.getCodePath())) {
            Map idAndCodePathMap = this.areaRepoProc.getIdAndCodePathByCodePath(oldCodePath);
            int len = oldCodePath.length();
            for (Map.Entry entry : idAndCodePathMap.entrySet()) {
                String newPath = areaDO.getCodePath() + ((String)entry.getValue()).substring(len);
                this.areaRepoProc.updateCodePath(((Long)entry.getKey()).longValue(), newPath);
            }
        }
        return ApiResult.ok((Object)areaDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ImportAreaBO areaBO) {
        Long parentId;
        this.validatePermission();
        SysPlatformAreaDO areaDO = null;
        try {
            areaDO = this.checkForInsert(areaBO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.areaManager.clearCache();
        Long l = parentId = StringUtils.hasText((String)areaDO.getParentAreaCode()) ? this.areaRepoProc.getId(areaDO.getParentAreaCode()) : null;
        if (areaDO.getEnabled() == null) {
            areaDO.setEnabled(Boolean.valueOf(true));
        }
        if (areaDO.getSortNo() == null) {
            areaDO.setSortNo(Integer.valueOf(this.areaRepoProc.findMaxSortNo(parentId) + 1));
        }
        this.areaRepo.save((Object)areaDO);
        this.areaRepoProc.saveTreeNode((BaseTreeModel)areaDO, parentId, areaDO.getSortNo());
        return ApiResult.ok((Object)areaDO.getId());
    }

    @Override
    public ApiResult<AreaDetailRespVO> get(Long id) {
        boolean enabled = this.enabledPlatform();
        AreaDetailRespVO respVO = enabled || TenantConstant.DEFAULT_TENANT_ID.longValue() == super.currentTenantId().longValue() ? (AreaDetailRespVO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.getDetailRespVO(id)) : this.getDetailRespVO(id);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.validatePermission();
        SysPlatformAreaDO data = (SysPlatformAreaDO)this.areaRepoProc.get(id.longValue());
        if (data == null) {
            return ApiResult.ok((Object)id);
        }
        this.areaManager.clearCache();
        this.areaRepoProc.removeTreeNode((BaseTreeModel)data);
        this.areaRepoProc.delete(id.longValue());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> rebuildTree(Long rootId) {
        this.rebuildTree(rootId, null);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<String> grabUrl() {
        return ApiResult.ok((Object)((SystemProperties)SpringContextHolder.getBean(SystemProperties.class)).getArea().getGrabAreaUrl());
    }

    @Override
    public ApiResult<Object> grabPreview(String url, Boolean forceLevel, Boolean json) {
        if (CharSequenceUtil.isBlank((CharSequence)url)) {
            url = ((SystemProperties)SpringContextHolder.getBean(SystemProperties.class)).getArea().getGrabAreaUrl();
        }
        if (CharSequenceUtil.isBlank((CharSequence)url)) {
            return ApiResult.fail((String)"\u91c7\u96c6\u5730\u5740\u4e3a\u7a7a");
        }
        GrabAreaCodeTool tool = new GrabAreaCodeTool(url);
        List roots = tool.buildTree(forceLevel == null || forceLevel != false);
        if (json == null || !json.booleanValue()) {
            StringBuilder preview = new StringBuilder();
            for (GrabAreaCodeTool.AreaNode areaNode : roots) {
                areaNode.preview("", preview);
            }
            return ApiResult.ok((Object)preview.toString());
        }
        return ApiResult.ok(this.convertTreeForGrab(roots, null));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> grab(String url, Boolean forceLevel) {
        this.validatePermission();
        SystemProperties.Area props = ((SystemProperties)SpringContextHolder.getBean(SystemProperties.class)).getArea();
        if (CharSequenceUtil.isBlank((CharSequence)url)) {
            url = props.getGrabAreaUrl();
        }
        if (CharSequenceUtil.isBlank((CharSequence)url)) {
            return ApiResult.fail((String)"\u91c7\u96c6\u5730\u5740\u4e3a\u7a7a");
        }
        GrabAreaCodeTool test = new GrabAreaCodeTool(url);
        List roots = test.buildTree(forceLevel == null || forceLevel != false);
        if (roots.isEmpty()) {
            return ApiResult.fail((String)"\u91c7\u96c6\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        Map<String, SysPlatformAreaDO> oldDataMap = this.areaRepoProc.all().stream().collect(Collectors.toMap(SysPlatformAreaDO::getAreaCode, t -> t, (t1, t2) -> t1));
        SysPlatformAreaDO china = oldDataMap.get(props.getChinaCode());
        if (china == null) {
            china = new SysPlatformAreaDO();
            oldDataMap.put(props.getChinaCode(), china);
            china.setId(IdGenerator.generateLong());
            china.setAreaName("\u4e2d\u56fd");
            china.setAreaCode(props.getChinaCode());
            china.setAreaType(AreaType.COUNTRY.getValue());
            china.setEnabled(Boolean.valueOf(true));
            china.setCodePath("|");
            china.setPinyin(this.convertPinyin(china.getAreaName()));
            china.setRootId(china.getId());
            china.setSortNo(Integer.valueOf(0));
        }
        List<SysPlatformAreaDO> areaList = this.convertGrabAreaNodes(china, china, roots, oldDataMap);
        areaList.add(china);
        this.areaRepoProc.deleteChildren(china.getAreaCode(), china.getId());
        this.areaRepoProc.save(areaList);
        Map<String, Long> idCodeMap = areaList.stream().collect(Collectors.toMap(SysPlatformAreaDO::getAreaCode, BaseModel::getId, (t1, t2) -> t1));
        this.rebuildTree(china.getId(), idCodeMap);
        return ApiResult.ok((Object)true);
    }

    private List<Area> convertTreeForGrab(List<GrabAreaCodeTool.AreaNode> nodes, String pCode) {
        if (CollUtil.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        return nodes.stream().map(t -> {
            Area param = new Area();
            param.setCode(t.getCode());
            param.setName(t.getName());
            param.setParentCode(pCode);
            param.setChildren(this.convertTreeForGrab(t.getChildren(), t.getCode()));
            return param;
        }).collect(Collectors.toList());
    }

    private void rebuildTree(Long rootId, Map<String, Long> idCodeMap) {
        if (idCodeMap == null) {
            idCodeMap = this.areaRepoProc.getIdAndCode();
        }
        if (idCodeMap.isEmpty()) {
            logger.info("\u884c\u653f\u533a\u57df\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6784\u5efa");
            return;
        }
        Map finalIdCodeMap = idCodeMap;
        CompletableFuture.runAsync(() -> {
            this.areaRepoProc.rebuildTree(rootId, t -> StringUtils.hasText((String)t.getParentAreaCode()) ? (Long)finalIdCodeMap.get(t.getParentAreaCode()) : null);
            this.areaManager.clearCache();
        }, (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e == null) {
                logger.info("\u91cd\u6784\u884c\u653f\u533a\u57df\u6811\u6210\u529f");
                return;
            }
            logger.error("\u91cd\u6784\u884c\u653f\u533a\u57df\u6811\u5931\u8d25", e);
        });
    }

    private List<SysPlatformAreaDO> convertGrabAreaNodes(SysPlatformAreaDO china, SysPlatformAreaDO parent, List<GrabAreaCodeTool.AreaNode> nodes, Map<String, SysPlatformAreaDO> oldDataMap) {
        if (CollUtil.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        ArrayList<SysPlatformAreaDO> areaList = new ArrayList<SysPlatformAreaDO>(256);
        int i = 0;
        for (GrabAreaCodeTool.AreaNode node : nodes) {
            SysPlatformAreaDO areaDO = new SysPlatformAreaDO();
            SysPlatformAreaDO oldArea = oldDataMap.get(node.getCode());
            areaDO.setAreaName(node.getName());
            areaDO.setAreaCode(node.getCode());
            if (parent != null) {
                areaDO.setParentAreaCode(parent.getAreaCode());
            }
            areaDO.setShortName(oldArea != null ? oldArea.getShortName() : null);
            areaDO.setAreaType(this.convertLevel2AreaType(node.getLevel()));
            areaDO.setZipCode(oldArea != null ? oldArea.getZipCode() : null);
            areaDO.setEnabled(Boolean.valueOf(oldArea != null ? oldArea.getEnabled() : true));
            areaDO.setCodePath(parent != null ? parent.getCodePath() + "|" + areaDO.getAreaCode() : "|" + areaDO.getAreaCode());
            areaDO.setPinyin(this.convertPinyin(areaDO.getAreaName()));
            areaDO.setRootId(china.getId());
            areaDO.setSortNo(Integer.valueOf(i++));
            areaDO.setRemark(oldArea != null ? oldArea.getRemark() : null);
            areaList.add(areaDO);
            areaList.addAll(this.convertGrabAreaNodes(china, areaDO, node.getChildren(), oldDataMap));
        }
        return areaList;
    }

    private String convertLevel2AreaType(int level) {
        switch (level) {
            case 0: {
                return AreaType.COUNTRY.getValue();
            }
            case 1: {
                return AreaType.PROVINCE.getValue();
            }
            case 2: {
                return AreaType.CITY.getValue();
            }
            case 3: {
                return AreaType.AREA.getValue();
            }
            case 4: {
                return AreaType.TOWN.getValue();
            }
            case 5: {
                return AreaType.VILLAGE.getValue();
            }
        }
        return null;
    }

    private boolean enabledPlatform() {
        Long tenantId = super.currentTenantId();
        Boolean enabled = this.tenantAreaRepoProc.getEnabled(tenantId.longValue());
        return (Boolean)ObjectUtil.defaultIfNull((Object)enabled, (Object)true);
    }

    private void validatePermission() {
        boolean enabled;
        Long tenantId = super.currentTenantId();
        if (TenantConstant.DEFAULT_TENANT_ID.longValue() != tenantId.longValue() && (enabled = this.enabledPlatform())) {
            throw new BusinessException("\u65e0\u6743\u9650\u4fee\u6539\u5e73\u53f0\u9ed8\u8ba4\u914d\u7f6e");
        }
    }

    private AreaMngTreeRespVO do2TreeRespVO(SysPlatformAreaDO t) {
        AreaMngTreeRespVO respVO = new AreaMngTreeRespVO();
        respVO.setEnabled(t.getEnabled());
        respVO.setPinyin(t.getPinyin());
        respVO.setId(t.getId());
        respVO.setCode(t.getAreaCode());
        respVO.setName(t.getAreaName());
        respVO.setSortNo(t.getSortNo());
        respVO.setParentId(t.getPId());
        respVO.setParentCode(t.getParentAreaCode());
        return respVO;
    }

    private SysPlatformAreaDO checkForInsert(ImportAreaBO saveBO) {
        SysPlatformAreaDO areaDO = AreaConvert.INSTANCE.bo2Do(saveBO);
        boolean exists = this.areaRepoProc.existsCode(areaDO.getAreaCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5730\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)areaDO.getParentAreaCode())) {
            exists = this.areaRepoProc.existsCode(areaDO.getParentAreaCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
            String parentCodePath = this.areaRepoProc.getCodePath(areaDO.getParentAreaCode());
            areaDO.setCodePath(parentCodePath + "|" + areaDO.getAreaCode());
        } else {
            areaDO.setCodePath("|" + areaDO.getAreaCode());
        }
        areaDO.setPinyin(this.convertPinyin(saveBO.getName()));
        return areaDO;
    }

    private String convertPinyin(String name) {
        if (CharSequenceUtil.isBlank((CharSequence)name)) {
            return null;
        }
        return PinyinUtil.getPinyin((String)name);
    }

    private SysPlatformAreaDO checkForInsert(PlatformAreaSaveVO saveVO) {
        SysPlatformAreaDO areaDO = CONVERT.saveVo2Do(saveVO);
        boolean exists = this.areaRepoProc.existsCode(areaDO.getAreaCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5730\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)areaDO.getParentAreaCode())) {
            exists = this.areaRepoProc.existsCode(areaDO.getParentAreaCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
            String parentCodePath = this.areaRepoProc.getCodePath(areaDO.getParentAreaCode());
            areaDO.setCodePath(parentCodePath + "|" + areaDO.getAreaCode());
        } else {
            areaDO.setCodePath("|" + areaDO.getAreaCode());
        }
        areaDO.setPinyin(this.convertPinyin(saveVO.getAreaName()));
        return areaDO;
    }

    private SysPlatformAreaDO checkForUpdate(PlatformAreaSaveVO saveVO) {
        boolean exists;
        SysPlatformAreaDO areaDO = (SysPlatformAreaDO)this.areaRepoProc.get(saveVO.getId().longValue());
        Assert.notNull((Object)areaDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        if (!StrUtil.equals((CharSequence)saveVO.getAreaCode(), (CharSequence)areaDO.getAreaCode())) {
            exists = this.areaRepoProc.existsCode(saveVO.getAreaCode(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5730\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)saveVO.getParentAreaCode())) {
            areaDO.setCodePath("|" + areaDO.getAreaCode());
        } else if (!StrUtil.equals((CharSequence)saveVO.getParentAreaCode(), (CharSequence)areaDO.getParentAreaCode())) {
            exists = this.areaRepoProc.existsCode(saveVO.getParentAreaCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
            String parentCodePath = this.areaRepoProc.getCodePath(areaDO.getParentAreaCode());
            areaDO.setCodePath(parentCodePath + "|" + areaDO.getAreaCode());
        }
        if (!StrUtil.equals((CharSequence)saveVO.getAreaName(), (CharSequence)areaDO.getAreaName()) || StrUtil.isBlank((CharSequence)areaDO.getAreaName())) {
            areaDO.setPinyin(PinyinUtil.getPinyin((String)saveVO.getAreaName()));
        }
        CONVERT.saveVo2Do(saveVO, areaDO);
        return areaDO;
    }

    private AreaDetailRespVO getDetailRespVO(long id) {
        return this.areaRepoProc.getOptional(id).map(t -> {
            AreaDetailRespVO respVO = CONVERT.do2DetailRespVO(t);
            if (StringUtils.hasText((String)t.getParentAreaCode())) {
                respVO.setParentAreaName(this.areaRepoProc.getAreaName(t.getParentAreaCode()));
            }
            if (StringUtils.hasText((String)t.getAreaType())) {
                respVO.setAreaTypeName(super.udcValue((BaseUdc)new AreaType(t.getAreaType())));
            }
            return respVO;
        }).orElse(null);
    }

    public static class Area
    extends TreeRespParam<Area> {
    }
}

