/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;
import com.elitescloud.cloudt.system.service.alert.AlertProvider;
import com.elitescloud.cloudt.system.service.alert.DingdingAlertProvider;
import com.elitescloud.cloudt.system.service.alert.WxWorkAlertProvider;
import com.elitescloud.cloudt.system.service.repo.AlertConfigRepoProc;
import com.elitescloud.cloudt.system.service.repo.AlertRepoProc;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

class BaseAlertServiceImpl
extends BaseServiceImpl
implements InitializingBean {
    private final Map<SysAlertType, AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO>> alertProviderMap = new HashMap<SysAlertType, AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO>>(8);
    @Autowired
    protected AlertRepoProc alertRepoProc;
    @Autowired
    protected AlertConfigRepoProc alertConfigRepoProc;

    BaseAlertServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        this.addAlertProvider(new WxWorkAlertProvider(this.redisUtils));
        this.addAlertProvider(new DingdingAlertProvider(this.redisUtils));
    }

    public AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO> getAlertProvider(SysAlertType alertType) {
        return this.alertProviderMap.get(alertType);
    }

    private void addAlertProvider(AlertProvider<?, ?> alertProvider) {
        Assert.notNull((Object)alertProvider.alertType(), (String)"\u63d0\u9192\u7c7b\u578b\u4e3a\u7a7a\uff1a{}", (Object[])new Object[]{alertProvider.getClass().getName()});
        this.alertProviderMap.put(alertProvider.alertType(), alertProvider);
    }
}

