/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.model.vo.BotMessage;
import com.elitescloud.cloudt.system.model.vo.BotRequest;
import com.elitescloud.cloudt.system.service.BotMessageBuilder;
import com.elitescloud.cloudt.system.util.ExceptionUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotSenderService {
    private static final Logger logger = LoggerFactory.getLogger(BotSenderService.class);
    private static final int SEGMENT_LEN = 256;
    private final BotMessageBuilder messageBuilder;

    public void push(Supplier<BotRequest> botSupplier, String message) {
        try {
            BotMessage botMessage = new BotMessage();
            botMessage.setBizKey("");
            botMessage.setMessages(Collections.singletonList(message));
            BotRequest request = botSupplier.get();
            request.setMessages(Collections.singletonList(botMessage));
            this.push(request);
        }
        catch (Exception var5) {
            Exception e = var5;
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", (Object)ExceptionUtils.formatException(e));
        }
    }

    public void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        try {
            BotRequest request = botSupplier.get();
            request.setMessages(messages);
            this.push(request);
        }
        catch (Exception var4) {
            Exception e = var4;
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", (Object)ExceptionUtils.formatException(e));
        }
    }

    public void push(Supplier<BotRequest> botSupplier, Exception e) {
        this.push(botSupplier, ExceptionUtils.stacktraceToOneLineString((Throwable)e, (int)256));
    }

    public void push(BotRequest request) {
        logger.info("[PHOENIX-SNS] BOT REQUEST: dinger remove");
    }

    public BotSenderService(BotMessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
    }
}

