/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.common.BusinessObjectNodeType;
import com.elitescloud.cloudt.system.convert.BusinessObjectConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.bo.BusinessRefBO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.BusinessObjectQueryService;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRefRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessParamRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class BusinessObjectQueryServiceImpl
extends BaseServiceImpl
implements BusinessObjectQueryService {
    private static final Logger log = LoggerFactory.getLogger(BusinessObjectQueryServiceImpl.class);
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private BusinessOperationRepoProc businessOperationRepoProc;
    @Autowired
    private BusinessParamRepoProc businessParamRepoProc;
    @Autowired
    private BusinessObjectRefRepoProc refRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    @Override
    public ApiResult<List<BusinessObjectTreeNodeRespVO>> businessObjectTree(Boolean tree, Boolean withApp, Boolean withOperation, Boolean withRef, Boolean permissionOnly) {
        if (tree == null) {
            tree = true;
        }
        if (withApp == null) {
            withApp = true;
        }
        if (withOperation == null) {
            withOperation = true;
        }
        if (withRef == null) {
            withRef = false;
        }
        if (permissionOnly == null) {
            permissionOnly = false;
        }
        List<BusinessObjectTreeNodeRespVO> businessObjectList = this.queryBusinessObjectTree(tree, withApp, withOperation, withRef, permissionOnly);
        return ApiResult.ok(businessObjectList);
    }

    @Override
    public ApiResult<List<SysBusinessObjectDTO>> allBusinessObject() {
        List dtoList = this.businessObjectRepoProc.listSimple(true).stream().map(this::simpleBo2DTO).collect(Collectors.toList());
        return ApiResult.ok(dtoList);
    }

    @Override
    public ApiResult<SysBusinessObjectDTO> getBusinessObjectDetail(String businessObjectCode) {
        Assert.hasText((String)businessObjectCode, (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
        BusinessObjectBO businessObject = this.businessObjectRepoProc.getSimple(businessObjectCode);
        if (businessObject == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        SysBusinessObjectDTO dto = this.simpleBo2DTO(businessObject);
        dto.setOperationList(this.businessOperationRepoProc.listByBusinessObjectCode(businessObjectCode).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(t -> {
            SysBusinessOperationDTO operationDTO = BusinessObjectConvert.INSTANCE.do2Dto((SysBusinessOperationDO)t);
            operationDTO.setOperationDescription(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getOperationDescription()));
            return operationDTO;
        }).collect(Collectors.toList()));
        dto.setParamList(this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(businessObjectCode).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(BusinessObjectConvert.INSTANCE::do2Dto).collect(Collectors.toList()));
        this.cacheBusinessObject(dto);
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<List<SysBusinessOperationDTO>> allOperationDTO() {
        List<SysBusinessOperationDTO> dtoList = this.businessOperationRepoProc.allDtoList(true);
        this.cacheBusinessObjects(dtoList);
        return ApiResult.ok(dtoList);
    }

    private SysBusinessObjectDTO simpleBo2DTO(BusinessObjectBO t) {
        SysBusinessObjectDTO dto = new SysBusinessObjectDTO();
        dto.setAppCode(t.getAppCode());
        dto.setCode(t.getCode());
        dto.setName(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getName()));
        dto.setEntityClassName(t.detectName());
        dto.setOperationList(Collections.emptyList());
        dto.setParamList(Collections.emptyList());
        return dto;
    }

    private void cacheBusinessObject(SysBusinessObjectDTO businessObjectDTO) {
        if (businessObjectDTO == null) {
            return;
        }
        this.redisUtils.hset("system:businessObject:all", businessObjectDTO.getCode(), (Object)businessObjectDTO);
    }

    private void cacheBusinessObjects(List<SysBusinessOperationDTO> dtoList) {
        Map businessMap = dtoList.stream().collect(Collectors.toMap(SysBusinessOperationDTO::getOperationCode, Function.identity(), (t1, t2) -> t1));
        this.redisUtils.del(new String[]{"system:businessOperation:all"});
        if (!businessMap.isEmpty()) {
            this.redisUtils.hmset("system:businessOperation:all", businessMap);
        }
    }

    private List<BusinessObjectTreeNodeRespVO> queryBusinessObjectTree(boolean tree, boolean withApp, boolean withOperation, boolean withRef, boolean permissionOnly) {
        Map<String, AppBO> tenantApps = this.tenantApps();
        if (tenantApps.isEmpty()) {
            return Collections.emptyList();
        }
        List<BusinessObjectTreeNodeRespVO> businessObjectList = this.queryBusinessObjectTreeNode(tenantApps, withApp);
        if (businessObjectList.isEmpty()) {
            return Collections.emptyList();
        }
        List<BusinessObjectTreeNodeRespVO> respVoList = new ArrayList<BusinessObjectTreeNodeRespVO>(128);
        if (withApp) {
            Map<String, List<BusinessObjectTreeNodeRespVO>> businessObjectAppMap = businessObjectList.stream().collect(Collectors.groupingBy(TreeRespParam::getParentCode));
            List<BusinessObjectTreeNodeRespVO> appNodeList = this.convertApp2BusinessObjectTreeNode(tenantApps);
            for (BusinessObjectTreeNodeRespVO appNode : appNodeList) {
                List<BusinessObjectTreeNodeRespVO> businessObjects = businessObjectAppMap.get(appNode.getCode());
                if (CollUtil.isEmpty(businessObjects)) continue;
                appNode.setChildren(businessObjects);
                respVoList.add(appNode);
            }
        } else {
            respVoList.addAll(businessObjectList);
        }
        if (withOperation) {
            List<BusinessObjectTreeNodeRespVO> operationList = this.queryBusinessOperationTreeNode(tenantApps, permissionOnly);
            Map<Long, List<BusinessObjectTreeNodeRespVO>> operationsMap = operationList.stream().collect(Collectors.groupingBy(TreeRespParam::getParentId));
            Map businessObjectMap = businessObjectList.stream().collect(Collectors.toMap(TreeRespParam::getId, Function.identity(), (t1, t2) -> t1));
            for (Map.Entry<Long, List<BusinessObjectTreeNodeRespVO>> entry : operationsMap.entrySet()) {
                BusinessObjectTreeNodeRespVO businessObject = (BusinessObjectTreeNodeRespVO)((Object)businessObjectMap.get(entry.getKey()));
                if (businessObject == null) continue;
                businessObject.setChildren(entry.getValue());
            }
            if (withRef) {
                this.queryRefForTree(businessObjectList, operationList);
            }
        } else if (permissionOnly) {
            Map<Long, Long> permissionEnabledMap = this.businessOperationRepoProc.countBusinessObjectOfPermissionEnabled();
            for (BusinessObjectTreeNodeRespVO businessObjectTreeNodeRespVO : businessObjectList) {
                businessObjectTreeNodeRespVO.setHasChildren(permissionEnabledMap.getOrDefault(businessObjectTreeNodeRespVO.getId(), 0L) > 0L);
            }
        }
        if (permissionOnly) {
            respVoList = this.filteredHasChildren(respVoList);
        }
        if (respVoList.isEmpty() || tree) {
            return respVoList;
        }
        return CollectionUtil.expandTree(respVoList, TreeRespParam::getChildren);
    }

    private void queryRefForTree(List<BusinessObjectTreeNodeRespVO> businessObjectList, List<BusinessObjectTreeNodeRespVO> operationList) {
        Map<String, List<BusinessRefBO>> refMap = this.refRepoProc.listSimpleBo().stream().collect(Collectors.groupingBy(BusinessRefBO::getBusinessObjectCode));
        if (!refMap.isEmpty()) {
            Map operationMap = operationList.stream().collect(Collectors.toMap(TreeRespParam::getCode, Function.identity(), (t1, t2) -> t1));
            for (BusinessObjectTreeNodeRespVO businessObject : businessObjectList) {
                List refList = refMap.getOrDefault(businessObject.getCode(), Collections.emptyList());
                if (refList.isEmpty()) continue;
                List refVoList = refList.stream().filter(t -> operationMap.containsKey(t.getRef())).map(t -> {
                    BusinessObjectTreeNodeRespVO operation = (BusinessObjectTreeNodeRespVO)((Object)((Object)operationMap.get(t.getRef())));
                    BusinessObjectTreeNodeRespVO respVO = new BusinessObjectTreeNodeRespVO();
                    respVO.setNodeType(BusinessObjectNodeType.REF_OPERATION);
                    respVO.setRefNode(true);
                    respVO.setIcon(null);
                    respVO.setId(t.getId());
                    respVO.setCode(t.getRef());
                    respVO.setName(operation.getName());
                    respVO.setSortNo(t.getSortNo());
                    respVO.setAppCode(operation.getAppCode());
                    respVO.setApiMethod(operation.getApiMethod());
                    respVO.setApiUrl(operation.getApiUrl());
                    respVO.setParentId(businessObject.getId());
                    respVO.setParentCode(businessObject.getCode());
                    respVO.setChildren(Collections.emptyList());
                    return respVO;
                }).collect(Collectors.toList());
                if (CollUtil.isEmpty((Collection)businessObject.getChildren())) {
                    businessObject.setChildren(refVoList);
                    return;
                }
                businessObject.getChildren().addAll(refVoList);
            }
        }
    }

    private List<BusinessObjectTreeNodeRespVO> filteredHasChildren(List<BusinessObjectTreeNodeRespVO> respVoList) {
        if (respVoList.isEmpty()) {
            return respVoList;
        }
        ArrayList<BusinessObjectTreeNodeRespVO> dataList = new ArrayList<BusinessObjectTreeNodeRespVO>();
        for (BusinessObjectTreeNodeRespVO respVO : respVoList) {
            if (respVO.getNodeType() == BusinessObjectNodeType.APP) {
                List<BusinessObjectTreeNodeRespVO> businessObjectList = this.filteredHasChildren(respVO.getChildren());
                respVO.setChildren(businessObjectList);
                if (businessObjectList.isEmpty()) continue;
            }
            if (respVO.getNodeType() == BusinessObjectNodeType.BUSINESS_OBJECT) {
                List<BusinessObjectTreeNodeRespVO> businessOperationList = respVO.getChildren();
                if (CollUtil.isEmpty((Collection)businessOperationList)) {
                    if (Boolean.FALSE.equals(respVO.getHasChildren())) {
                        continue;
                    }
                } else {
                    businessOperationList = this.filteredHasChildren(businessOperationList);
                    respVO.setChildren(businessOperationList);
                    if (businessOperationList.isEmpty()) continue;
                }
            }
            dataList.add(respVO);
        }
        return dataList;
    }

    private List<BusinessObjectTreeNodeRespVO> convertApp2BusinessObjectTreeNode(Map<String, AppBO> tenantApps) {
        if (tenantApps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BusinessObjectTreeNodeRespVO> businessObjectTreeNodeRespVOList = new ArrayList<BusinessObjectTreeNodeRespVO>();
        int appOrder = 1;
        for (Map.Entry<String, AppBO> entry : tenantApps.entrySet()) {
            BusinessObjectTreeNodeRespVO respVO = new BusinessObjectTreeNodeRespVO();
            respVO.setNodeType(BusinessObjectNodeType.APP);
            respVO.setRefNode(false);
            respVO.setIcon(entry.getValue().getIcon());
            respVO.setAppCode(entry.getValue().getAppCode());
            respVO.setId(entry.getValue().getId());
            respVO.setCode(entry.getValue().getAppCode());
            respVO.setName(entry.getValue().getAppName());
            respVO.setSortNo(appOrder++);
            respVO.setChildren(Collections.emptyList());
            businessObjectTreeNodeRespVOList.add(respVO);
        }
        return businessObjectTreeNodeRespVOList;
    }

    private List<BusinessObjectTreeNodeRespVO> queryBusinessObjectTreeNode(Map<String, AppBO> tenantApps, boolean withApp) {
        AtomicInteger businessObjectOrder = new AtomicInteger(1);
        return this.businessObjectRepoProc.all().stream().filter(t -> {
            if (!Boolean.TRUE.equals(t.getEnabled())) {
                return false;
            }
            return tenantApps.containsKey(t.getAppCode());
        }).map(t -> {
            BusinessObjectTreeNodeRespVO respVO = new BusinessObjectTreeNodeRespVO();
            respVO.setNodeType(BusinessObjectNodeType.BUSINESS_OBJECT);
            respVO.setRefNode(false);
            respVO.setId(t.getId());
            respVO.setCode(t.getCode());
            respVO.setName(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getName()));
            respVO.setSortNo(businessObjectOrder.getAndAdd(1));
            respVO.setAppCode(t.getAppCode());
            if (withApp) {
                respVO.setParentId(((AppBO)tenantApps.get(t.getAppCode())).getId());
                respVO.setParentCode(t.getAppCode());
            }
            respVO.setChildren(Collections.emptyList());
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<BusinessObjectTreeNodeRespVO> queryBusinessOperationTreeNode(Map<String, AppBO> tenantApps, boolean permissionOnly) {
        return this.businessOperationRepoProc.listSimpleByType(permissionOnly).stream().filter(t -> {
            if (!Boolean.TRUE.equals(t.getEnabled())) {
                return false;
            }
            return tenantApps.containsKey(t.getAppCode());
        }).map(t -> {
            BusinessObjectTreeNodeRespVO respVO = new BusinessObjectTreeNodeRespVO();
            respVO.setNodeType(BusinessObjectNodeType.BUSINESS_OPERATION);
            respVO.setRefNode(false);
            respVO.setId(t.getId());
            respVO.setCode(t.getOperationCode());
            respVO.setName(t.getOperationDescription());
            respVO.setSortNo(t.getDisplayOrder());
            respVO.setAppCode(t.getAppCode());
            respVO.setApiMethod(t.getApiMethod());
            respVO.setApiUrl(t.getApiUrl());
            respVO.setParentId(t.getBusinessObjectId());
            respVO.setParentCode(t.getBusinessObjectCode());
            respVO.setChildren(Collections.emptyList());
            if (StringUtils.hasText((String)t.getPermissionRef())) {
                respVO.setRefPermission(t.getPermissionRef());
            }
            return respVO;
        }).collect(Collectors.toList());
    }

    private Map<String, AppBO> tenantApps() {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null && CollUtil.isEmpty((Collection)tenant.getAppCodes())) {
            return Collections.emptyMap();
        }
        List appList = this.appRepoProc.allBO(Boolean.valueOf(true));
        Set tenantAppCodes = tenant == null ? null : tenant.getAppCodes();
        LinkedHashMap<String, AppBO> appsMap = new LinkedHashMap<String, AppBO>(appList.size());
        for (AppBO param : appList) {
            if (tenantAppCodes != null && !tenantAppCodes.contains(param.getAppCode())) continue;
            appsMap.put(param.getAppCode(), param);
        }
        return appsMap;
    }
}

