/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.CurrencyRateConvert;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyRateQueryDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRateQueryVO;
import com.elitescloud.cloudt.system.service.CurrencyRateQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysCurrencyRateDO;
import com.elitescloud.cloudt.system.service.repo.CurrencyRateRepoProc;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class CurrencyRateQueryServiceImpl
extends BaseServiceImpl
implements CurrencyRateQueryService {
    private static final CurrencyRateConvert CONVERT = CurrencyRateConvert.INSTANCE;
    @Autowired
    private CurrencyRateRepoProc repoProc;

    @Override
    public ApiResult<Double> findRatio(SysCurrencyRateQueryDTO queryDTO) {
        if (CharSequenceUtil.equals((CharSequence)queryDTO.getFromCurr(), (CharSequence)queryDTO.getToCurr())) {
            return ApiResult.ok((Object)1.0);
        }
        SysCurrencyRateDO currencyRate = this.repoProc.queryOne(queryDTO);
        if (currencyRate != null) {
            return ApiResult.ok((Object)currencyRate.getRatio().doubleValue());
        }
        String from = queryDTO.getFromCurr();
        String to = queryDTO.getToCurr();
        queryDTO.setFromCurr(to);
        queryDTO.setToCurr(from);
        currencyRate = this.repoProc.queryOne(queryDTO);
        if (currencyRate != null) {
            BigDecimal val = BigDecimal.ONE.divide(currencyRate.getRatio(), 6, RoundingMode.HALF_UP);
            return ApiResult.ok((Object)val.doubleValue());
        }
        return ApiResult.ok(null);
    }

    @Override
    public ApiResult<Double> findRatio(CurrencyRateQueryVO queryVO) {
        SysCurrencyRateQueryDTO dto = CONVERT.vo2dto(queryVO);
        return this.findRatio(dto);
    }
}

