/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataRelationConvert;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstValueBO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationInstEditQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationInstEditRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationInstSaveVO;
import com.elitescloud.cloudt.system.service.DataRelationInstMngService;
import com.elitescloud.cloudt.system.service.manager.DataRelationManager;
import com.elitescloud.cloudt.system.service.manager.DataSelectorManager;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationInstanceDO;
import com.elitescloud.cloudt.system.service.repo.DataRelationCategoryRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataRelationInstRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataRelationRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataRelationInstMngServiceImpl
implements DataRelationInstMngService {
    @Autowired
    private DataRelationRepoProc repoProc;
    @Autowired
    private DataRelationCategoryRepoProc categoryRepoProc;
    @Autowired
    private DataRelationInstRepoProc instRepoProc;
    @Autowired
    private DataRelationManager manager;
    @Autowired
    private DataSelectorManager dataSelectorManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<DataRelationConfigRespVO> getConfig(String drCode) {
        Assert.notBlank((CharSequence)drCode, (String)"\u6570\u636e\u5173\u7cfb\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        SysDataRelationDO drDO = this.repoProc.getByCode(drCode);
        if (drDO == null || Boolean.FALSE.equals(drDO.getEnabled())) {
            return ApiResult.fail((String)"\u6570\u636e\u5173\u7cfb\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        }
        DataRelationConfigRespVO respVO = DataRelationConvert.INSTANCE.do2ConfigRespVO(drDO);
        List<DataRelationConfigRespVO.Cat> catList = this.categoryRepoProc.listByDrCode(drDO.getCode()).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(DataRelationConvert.INSTANCE::do2ConfigRespVO).collect(Collectors.toList());
        respVO.setCats(catList);
        if (StringUtils.hasText((String)drDO.getDataSelectorCode())) {
            respVO.setDataSelector(this.dataSelectorManager.getRespVO(drDO.getDataSelectorCode()));
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveValues(DataRelationInstSaveVO saveVO) {
        try {
            this.checkForSave(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        List instDoList = CollUtil.isEmpty(saveVO.getCatList()) ? Collections.emptyList() : saveVO.getCatList().stream().flatMap(cat -> {
            if (CollUtil.isEmpty(cat.getDataList())) {
                return Stream.empty();
            }
            String dataExtJson = CollUtil.isEmpty(cat.getDataExt()) ? null : JSONUtil.toJsonString(cat.getDataExt());
            return cat.getDataList().stream().flatMap(cateData -> {
                String refDataExtJson = CollUtil.isEmpty(cateData.getRefDataExt()) ? null : JSONUtil.toJsonString(cateData.getRefDataExt());
                AtomicInteger sortNo = new AtomicInteger(0);
                return saveVO.getDataKeyList().stream().map(dataKey -> {
                    SysDataRelationInstanceDO instDO = new SysDataRelationInstanceDO();
                    instDO.setDrCode(saveVO.getDrCode());
                    instDO.setCatCode(cat.getCatCode());
                    instDO.setDataKey(dataKey);
                    instDO.setDataAttribute((String)ObjectUtil.defaultIfNull((Object)cat.getDataAttribute(), (Object)""));
                    instDO.setDataExtJson(dataExtJson);
                    instDO.setRefDataKey(cateData.getRefDataKey());
                    instDO.setRefDataAttribute((String)ObjectUtil.defaultIfNull((Object)cateData.getRefDataAttribute(), (Object)""));
                    instDO.setRefDataExtJson(refDataExtJson);
                    instDO.setSortNo(Integer.valueOf(sortNo.getAndIncrement()));
                    return instDO;
                });
            });
        }).collect(Collectors.toList());
        this.instRepoProc.deleteForInst(saveVO.getDrCode(), saveVO.getDataKeyList());
        if (!instDoList.isEmpty()) {
            this.instRepoProc.save(instDoList);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<DataRelationInstEditRespVO> getValues(DataRelationInstEditQueryVO queryVO) {
        Assert.notNull((Object)queryVO, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)queryVO.getDataKey(), (String)"\u6570\u636e\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)queryVO.getDrCode(), (String)"\u6570\u636e\u5173\u7cfb\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        DataRelationInstQueryBO queryBO = DataRelationConvert.INSTANCE.queryVo2Bo(queryVO);
        List<DataRelationInstValueBO> valueBoList = this.manager.queryValues(queryBO);
        DataRelationInstEditRespVO respVO = new DataRelationInstEditRespVO();
        respVO.setDataKey(queryVO.getDataKey());
        respVO.setDrCode(queryVO.getDrCode());
        respVO.setCatList(Collections.emptyList());
        if (valueBoList.isEmpty()) {
            return ApiResult.ok((Object)respVO);
        }
        LinkedHashMap<String, DataRelationInstEditRespVO.CatData> catDataMap = new LinkedHashMap<String, DataRelationInstEditRespVO.CatData>();
        DataRelationInstEditRespVO.InstData instData = null;
        for (DataRelationInstValueBO valueBO : valueBoList) {
            DataRelationInstEditRespVO.CatData dataList = catDataMap.computeIfAbsent(valueBO.getCatCode() + "#::#" + (String)ObjUtil.defaultIfNull((Object)valueBO.getDataAttribute(), (Object)"__undefined"), catCode -> {
                DataRelationInstEditRespVO.CatData catData = new DataRelationInstEditRespVO.CatData();
                catData.setCatCode(valueBO.getCatCode());
                catData.setDataAttribute(valueBO.getDataAttribute());
                catData.setDataExt(valueBO.getDataExt());
                catData.setDataList(new ArrayList<DataRelationInstEditRespVO.InstData>(valueBoList.size()));
                return catData;
            });
            instData = new DataRelationInstEditRespVO.InstData();
            instData.setRefDataKey(valueBO.getRefDataKey());
            instData.setRefDataAttribute(valueBO.getRefDataAttribute());
            instData.setRefDataExt(valueBO.getRefDataExt());
            dataList.getDataList().add(instData);
        }
        respVO.setCatList(new ArrayList<DataRelationInstEditRespVO.CatData>(catDataMap.values()));
        return ApiResult.ok((Object)respVO);
    }

    private void checkForSave(DataRelationInstSaveVO saveVO) {
        List<String> dataKeyList = CollUtil.isEmpty(saveVO.getDataKeyList()) ? Collections.emptyList() : saveVO.getDataKeyList().stream().filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        Assert.notEmpty(dataKeyList, (String)"\u4e1a\u52a1\u6570\u636e\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getDrCode(), (String)"\u6570\u636e\u5173\u7cfb\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        saveVO.setDataKeyList(dataKeyList);
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            boolean exists = this.repoProc.existsCode(saveVO.getDrCode(), null);
            if (!exists) {
                throw new BusinessException("\u6570\u636e\u5173\u7cfb\u4e0d\u5b58\u5728");
            }
            List<String> catCodes = this.categoryRepoProc.getCodesByDrCode(saveVO.getDrCode());
            if (CollUtil.isNotEmpty(saveVO.getCatList())) {
                for (DataRelationInstSaveVO.CatData catData : saveVO.getCatList()) {
                    Assert.notBlank((CharSequence)catData.getCatCode(), (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Assert.isTrue((boolean)catCodes.contains(catData.getCatCode()), (String)("\u5206\u7c7b" + catData.getCatCode() + "\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
                    if (!CollUtil.isNotEmpty(catData.getDataList())) continue;
                    for (DataRelationInstSaveVO.InstData instData : catData.getDataList()) {
                        Assert.notBlank((CharSequence)instData.getRefDataKey(), (String)"\u5173\u8054\u6570\u636e\u7684\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                }
            }
            return null;
        });
    }
}

