/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorListRespVO;
import com.elitescloud.cloudt.system.service.DataSelectorQueryService;
import com.elitescloud.cloudt.system.service.repo.DataSelectorGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataSelectorQueryServiceImpl
implements DataSelectorQueryService {
    @Autowired
    private DataSelectorRepoProc repoProc;
    @Autowired
    private DataSelectorGroupRepoProc groupRepoProc;

    @Override
    public ApiResult<List<CommonDataSelectorListRespVO>> listTree(Boolean tree) {
        List<CommonDataSelectorListRespVO> groupList = this.listTreeOfGroup();
        if (groupList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        ArrayList<CommonDataSelectorListRespVO> respVoList = new ArrayList<CommonDataSelectorListRespVO>(128);
        respVoList.addAll(groupList);
        respVoList.addAll(this.listTreeOfDataSelector(groupList));
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        List resultList = treeDataUtil.getRoots().stream().filter(t -> Boolean.FALSE.equals(t.getDataSelector())).collect(Collectors.toList());
        if (tree == null || tree.booleanValue()) {
            return ApiResult.ok(resultList);
        }
        resultList = CollectionUtil.expandTree(resultList, TreeRespParam::getChildren);
        return ApiResult.ok((Object)resultList);
    }

    private List<CommonDataSelectorListRespVO> listTreeOfDataSelector(List<CommonDataSelectorListRespVO> groups) {
        Map<String, Long> groupMap = groups.stream().collect(Collectors.toMap(TreeRespParam::getCode, TreeRespParam::getId, (t1, t2) -> t1));
        AtomicInteger sortNO = new AtomicInteger(0);
        return this.repoProc.queryList().stream().map(t -> {
            CommonDataSelectorListRespVO respVO = new CommonDataSelectorListRespVO();
            respVO.setDataSelector(true);
            respVO.setId(t.getId());
            respVO.setCode(t.getSelectorCode());
            respVO.setName(t.getSelectorName());
            respVO.setSortNo(sortNO.getAndIncrement());
            respVO.setParentId((Long)groupMap.get(t.getGroupCode()));
            respVO.setParentCode(t.getGroupCode());
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<CommonDataSelectorListRespVO> listTreeOfGroup() {
        AtomicInteger sortNO = new AtomicInteger(0);
        return this.groupRepoProc.listGroup().stream().map(t -> {
            CommonDataSelectorListRespVO respVO = new CommonDataSelectorListRespVO();
            respVO.setDataSelector(false);
            respVO.setId(t.getId());
            respVO.setCode(t.getCode());
            respVO.setName(t.getName());
            respVO.setSortNo(sortNO.getAndIncrement());
            return respVO;
        }).collect(Collectors.toList());
    }
}

