/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class EmployeeBaseServiceImpl
extends BaseServiceImpl {
    protected static final EmployeeConvert CONVERT = EmployeeConvert.INSTANCE;
    protected static final UserConvert CONVERT_USER = UserConvert.INSTANCE;
    protected static final AreaConvert CONVERT_AREA = AreaConvert.INSTANCE;
    @Autowired
    protected EmployeeRepoProc employeeRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    protected UserQueryService userQueryService;

    EmployeeBaseServiceImpl() {
    }

    protected void fillUserInfo(List<EmployeePagedRespVO> dataList, Map<Long, SysUserBasicDTO> userMap) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        if (CollectionUtils.isEmpty(userMap)) {
            Set userIds = dataList.stream().filter(t -> t.getUserId() != null && t.getUserId() != -1L).map(EmployeePagedRespVO::getUserId).collect(Collectors.toSet());
            UserQueryDTO queryDTO = new UserQueryDTO();
            queryDTO.setUserIds(userIds);
            List users = this.userRepoCall(repo -> repo.queryBasicDto(queryDTO));
            userMap = users.stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
        }
        for (EmployeePagedRespVO record : dataList) {
            SysUserBasicDTO user = userMap.get(record.getUserId());
            if (user == null) {
                record.setFullName(this.convertFullName(record.getLastName(), record.getFirstName()));
                record.setGenderName(new Gender(record.getGender()).getDescription());
                continue;
            }
            record.setUsername(user.getUsername());
            record.setFullName(user.getFullName());
            if (!StringUtils.hasText((String)record.getGender())) {
                record.setGender(user.getGender());
            }
            record.setGenderName(new Gender(record.getGender()).getDescription());
            record.setMobile(user.getMobile());
            if (StringUtils.hasText((String)record.getEmail())) continue;
            record.setEmail(user.getEmail());
        }
    }

    protected String convertFullName(String lastName, String firstName) {
        if (!StringUtils.hasText((String)lastName)) {
            return firstName;
        }
        return lastName + CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)"");
    }

    protected void fillUserInfoDTO(PagingVO<EmployeePageRespDTO> pagingVO, Map<Long, SysUserBasicDTO> userMap) {
        if (pagingVO.isEmpty()) {
            return;
        }
        if (CollectionUtils.isEmpty(userMap)) {
            Set userIds = pagingVO.getRecords().stream().map(EmployeePageRespDTO::getUserId).filter(t -> t != null && t != -1L).collect(Collectors.toSet());
            UserQueryDTO queryDTO = new UserQueryDTO();
            queryDTO.setUserIds(userIds);
            List users = this.userRepoCall(repo -> repo.queryBasicDto(queryDTO));
            userMap = users.stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
        }
        for (EmployeePageRespDTO record : pagingVO.getRecords()) {
            SysUserBasicDTO user = userMap.get(record.getUserId());
            if (user == null) continue;
            record.setUsername(user.getUsername());
            record.setFullName(user.getFullName());
            if (!StringUtils.hasText((String)record.getGender())) {
                record.setGender(user.getGender());
            }
            record.setGenderName(new Gender(record.getGender()).getDescription());
            if (!StringUtils.hasText((String)record.getPhone())) {
                record.setPhone(user.getMobile());
            }
            if (!StringUtils.hasText((String)record.getEmail())) {
                record.setEmail(user.getEmail());
            }
            record.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(record.getEnabled()) && Boolean.TRUE.equals(user.getEnabled())));
        }
    }

    protected SysEmployeeBasicDTO fillTenantUserInfo(SysEmployeeBasicDTO employee) {
        if (employee == null) {
            return null;
        }
        if (employee.getUserId() == null || employee.getUserId() == -1L) {
            return null;
        }
        if (Boolean.TRUE.equals(employee.getEnabled())) {
            Boolean enabled = this.userRepoCall(repo -> repo.getEnabled(employee.getUserId()));
            employee.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(enabled)));
        }
        return employee;
    }

    protected List<EmployeeUnderlingDTO> fillTenantUserInfo(List<EmployeeUnderlingDTO> underlingList) {
        if (CollUtil.isEmpty(underlingList)) {
            return underlingList;
        }
        Set userIds = underlingList.stream().map(EmployeeUnderlingDTO::getUserId).collect(Collectors.toSet());
        Long tenantId = super.currentTenantId();
        Map tenantUserMap = this.userRepoCall(repo -> repo.getEnabled(tenantId, userIds));
        for (EmployeeUnderlingDTO dto : underlingList) {
            dto.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(dto.getEnabled()) && Boolean.TRUE.equals(tenantUserMap.get(dto.getUserId()))));
        }
        return underlingList;
    }

    protected <T> T userRepoCall(Function<UserRepoProc, T> function) {
        return (T)this.tenantDataIsolateProvider.byDefaultDirectly(() -> function.apply(this.userRepoProc));
    }
}

