/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysBusinessUnit;
import com.elitescloud.cloudt.constant.SysFunctionType;
import com.elitescloud.cloudt.constant.SysProfitablyCenter;
import com.elitescloud.cloudt.constant.SysRegion;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.convert.OrgConvert;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgDetailRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysOrgPageRespDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonOrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgPagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.MultiOrgTreeQueryService;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import com.elitescloud.cloudt.system.service.manager.OrgTreeManager;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class OrgQueryServiceImpl
extends BaseServiceImpl
implements OrgQueryService {
    private static final Logger log = LoggerFactory.getLogger(OrgQueryServiceImpl.class);
    private static final OrgConvert CONVERT = OrgConvert.INSTANCE;
    @Autowired
    private OrgRepoProc repoProc;
    @Autowired
    private OuRepoProc ouRepoProc;
    @Autowired
    private OrgTreeManager orgTreeManager;
    @Autowired
    private MultiOrgTreeQueryService multiOrgTreeQueryService;

    @Override
    public ApiResult<List<OrgTreeNodeRespVO>> getOrgTree(String pCode, Boolean tree, Boolean employee, Boolean all) {
        tree = tree == null || tree != false;
        employee = employee != null && employee != false;
        GeneralUserDetails currentUser = super.currentUser(true);
        Long orgIdBelong = null;
        if (CharSequenceUtil.isNotBlank((CharSequence)pCode)) {
            orgIdBelong = this.repoProc.getIdByCode(pCode);
            if (orgIdBelong == null) {
                return ApiResult.fail((String)("\u7ec4\u7ec7" + pCode + "\u4e0d\u5b58\u5728"));
            }
        } else if (!(currentUser.isSystemAdmin() || currentUser.isTenantAdmin() || Boolean.TRUE.equals(all) || (orgIdBelong = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantOrgId(), (Object)currentUser.getOrgId())) != null)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<OrgTreeNodeRespVO> respVO = this.orgTreeManager.getTreeCacheable(orgIdBelong, tree, false, employee);
        return ApiResult.ok(respVO);
    }

    @Override
    public ApiResult<List<OrgTreeNodeRespVO>> getOrgTreeAsync(String pCode, Long pId, Boolean employee, Boolean all) {
        employee = employee != null && employee != false;
        if (CharSequenceUtil.isNotBlank((CharSequence)pCode) && pId == null && (pId = this.repoProc.getIdByCode(pCode)) == null) {
            return ApiResult.fail((String)("\u7ec4\u7ec7" + pCode + "\u4e0d\u5b58\u5728"));
        }
        GeneralUserDetails currentUser = super.currentUser(true);
        if (!(currentUser.isSystemAdmin() || currentUser.isTenantAdmin() || pId != null && pId != -1L || Boolean.TRUE.equals(all))) {
            pId = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantOrgId(), (Object)currentUser.getOrgId());
        }
        List<OrgTreeNodeRespVO> respVO = this.orgTreeManager.getTreeAsync(pId, false, employee);
        return ApiResult.ok(respVO);
    }

    @Override
    public ApiResult<Map<IdCodeNameParam, List<OrgTreeNodeRespVO>>> getMultiOrgTree(Boolean tree, Boolean employee, Boolean all, String[] treeCode) {
        Set treeCodeFilter = ArrayUtil.isEmpty((Object[])treeCode) ? null : Arrays.stream(treeCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        CompletableFuture<List> executiveOrgTreeThread = CompletableFuture.supplyAsync(() -> treeCodeFilter == null || treeCodeFilter.contains("default") ? (List)this.getOrgTree(null, tree, employee, all).getData() : null, (Executor)this.taskExecutor);
        CompletionStage multiTreeThread = CompletableFuture.supplyAsync(() -> (List)this.multiOrgTreeQueryService.listOrgTree().getData(), (Executor)this.taskExecutor).thenApplyAsync(trees -> {
            if (trees.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap multiOrgTrees = new HashMap(trees.size());
            ArrayList<CompletableFuture<Void>> completableFuturesMultiOrgTree = new ArrayList<CompletableFuture<Void>>(trees.size());
            for (IdCodeNameParam idCodeNameParam : trees) {
                if (treeCodeFilter != null && !treeCodeFilter.contains(idCodeNameParam.getCode())) continue;
                completableFuturesMultiOrgTree.add(CompletableFuture.runAsync(() -> multiOrgTrees.put(idCodeNameParam, (List)this.multiOrgTreeQueryService.getTree(idCodeNameParam.getId(), tree, employee, all).getData()), (Executor)this.taskExecutor));
            }
            try {
                CompletableFuture.allOf((CompletableFuture[])completableFuturesMultiOrgTree.toArray(CompletableFuture[]::new)).get();
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u591a\u7ec4\u7ec7\u6811\u5f02\u5e38\uff1a", (Throwable)e);
            }
            LinkedHashMap<IdCodeNameParam, List> multiOrgTreeMap = new LinkedHashMap<IdCodeNameParam, List>(32);
            List multiOrgTree = null;
            for (IdCodeNameParam idCodeNameParam : trees) {
                multiOrgTree = (List)multiOrgTrees.get(idCodeNameParam);
                if (multiOrgTree == null) continue;
                multiOrgTreeMap.put(idCodeNameParam, multiOrgTree);
            }
            return multiOrgTreeMap;
        }, (Executor)this.taskExecutor);
        Map allResult = (Map)((CompletableFuture)((CompletableFuture)executiveOrgTreeThread.thenCombine(multiTreeThread, (executiveOrgTree, multiOrgTree) -> {
            LinkedHashMap<IdCodeNameParam, List> result = new LinkedHashMap<IdCodeNameParam, List>(32);
            if (CollUtil.isNotEmpty((Collection)executiveOrgTree)) {
                result.put(new IdCodeNameParam(Long.valueOf(-1L), "default", "\u884c\u653f\u7ec4\u7ec7\u6811"), (List)executiveOrgTree);
            }
            if (CollUtil.isNotEmpty((Map)multiOrgTree)) {
                result.putAll((Map<IdCodeNameParam, List>)multiOrgTree);
            }
            return result;
        })).whenComplete((r, e) -> {
            if (e != null) {
                throw new BusinessException("\u591a\u7ec4\u7ec7\u6811\u67e5\u8be2\u5931\u8d25", e);
            }
        })).join();
        return ApiResult.ok((Object)allResult);
    }

    @Override
    public ApiResult<List<Long>> querySubOrgIds(Long id) {
        List ids = this.repoProc.getIdByPid(id);
        return ApiResult.ok((Object)ids);
    }

    @Override
    public ApiResult<List<Long>> queryBelongOrgIds(Long id) {
        List ids = this.repoProc.getChildrenIdByPid(id);
        return ApiResult.ok((Object)ids);
    }

    @Override
    public ApiResult<List<Long>> getIdsByOrgName(String orgName) {
        Assert.hasText((String)orgName, (String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        List<Long> ids = this.repoProc.getIdsByName(orgName);
        return ApiResult.ok(ids);
    }

    @Override
    public ApiResult<Long> getIdByOrgCode(String orgCode) {
        Assert.hasText((String)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        Long id = this.repoProc.getIdByCode(orgCode);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryCodeAndName(Set<Long> ids) {
        Assert.notEmpty(ids, (String)"ID\u4e3a\u7a7a");
        List<IdCodeNameParam> dataList = this.repoProc.queryIdCodeName(ids);
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryIdAndName(Set<String> codes) {
        Assert.notEmpty(codes, (String)"\u7f16\u7801\u4e3a\u7a7a");
        List<IdCodeNameParam> dataList = this.repoProc.queryIdCodeNameByCodes(codes);
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getById(Long id) {
        SysOrgBasicDTO dto = this.repoProc.getBasicDto(id);
        this.wrapBasicDTO(dto);
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<SysOrgDetailRespDTO> getDetailById(Long id, String withParentType) {
        SysOrgDO orgDO = (SysOrgDO)this.repoProc.get(id);
        if (orgDO == null) {
            return ApiResult.ok(null);
        }
        return ApiResult.ok((Object)this.wrapDetailDTO(orgDO, withParentType));
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getByCode(String code) {
        SysOrgBasicDTO dto = this.repoProc.getBasicDtoByCode(code);
        this.wrapBasicDTO(dto);
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<SysOrgDetailRespDTO> getDetailByCode(String code, String withParentType) {
        SysOrgDO orgDO = this.repoProc.getByCode(code);
        if (orgDO == null) {
            return ApiResult.ok(null);
        }
        return ApiResult.ok((Object)this.wrapDetailDTO(orgDO, withParentType));
    }

    @Override
    public ApiResult<SysOrgBasicDTO> getParentByCode(String code, String parentType) {
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            return ApiResult.fail((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)parentType)) {
            return ApiResult.ok((Object)this.repoProc.getParentBasicDtoByCode(code));
        }
        Long id = this.repoProc.getIdByCode(code);
        if (id == null) {
            return ApiResult.ok(null);
        }
        IdCodeNameParam withParent = this.repoProc.queryParentNameForType(List.of(id), parentType, true).get(id);
        if (withParent == null) {
            return ApiResult.ok();
        }
        return ApiResult.ok((Object)this.repoProc.getBasicDto(withParent.getId()));
    }

    @Override
    public ApiResult<Map<String, SysOrgBasicDTO>> getParentByCode(Set<String> codes, String parentType) {
        if (CollUtil.isEmpty(codes)) {
            return ApiResult.fail((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)parentType)) {
            Map<String, String> parentCodeMap = this.repoProc.getParentCodeByCode(codes);
            if (parentCodeMap.isEmpty()) {
                return ApiResult.ok(Collections.emptyMap());
            }
            Map<String, SysOrgBasicDTO> parentMap = this.repoProc.getParentBasicDtoByCode(codes).stream().collect(Collectors.toMap(SysOrgBasicDTO::getCode, t -> t, (t1, t2) -> t1));
            HashMap<String, SysOrgBasicDTO> result = new HashMap<String, SysOrgBasicDTO>(parentCodeMap.size());
            for (Map.Entry<String, String> entry : parentCodeMap.entrySet()) {
                SysOrgBasicDTO parent = parentMap.get(entry.getValue());
                if (parent == null) continue;
                result.put(entry.getKey(), parent);
            }
            return ApiResult.ok(result);
        }
        Map<String, Long> idMap = this.repoProc.getIdByCode(codes);
        if (idMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Map<Long, IdCodeNameParam> parentMap = this.repoProc.queryParentNameForType(idMap.values(), parentType, true);
        if (parentMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Set<Long> parentIds = parentMap.values().stream().map(IdCodeNameParam::getId).collect(Collectors.toSet());
        Map<Long, SysOrgBasicDTO> parentDtoMap = this.repoProc.getBasicDtoList(parentIds).stream().collect(Collectors.toMap(SysOrgBasicDTO::getId, t -> t, (t1, t2) -> t1));
        HashMap<String, SysOrgBasicDTO> result = new HashMap<String, SysOrgBasicDTO>(idMap.size());
        for (Map.Entry<String, Long> entry : idMap.entrySet()) {
            SysOrgBasicDTO parent;
            IdCodeNameParam parentIdName = parentMap.get(entry.getValue());
            if (parentIdName == null || (parent = parentDtoMap.get(parentIdName.getId())) == null) continue;
            result.put(entry.getKey(), parent);
        }
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryChildren(String code) {
        Assert.hasText((String)code, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        Long id = this.repoProc.getIdByCode(code);
        Assert.notNull((Object)id, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        List<IdCodeNameParam> children = this.repoProc.listChildrenNames(id);
        return ApiResult.ok(children);
    }

    @Override
    public ApiResult<Map<String, List<IdCodeNameParam>>> queryChildrenList(Set<String> codes) {
        Assert.notEmpty(codes, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        Map<String, Long> codeIdMap = this.repoProc.getIdByCode(codes);
        HashMap<String, List<IdCodeNameParam>> childrenMap = new HashMap<String, List<IdCodeNameParam>>(codes.size());
        for (Map.Entry<String, Long> entry : codeIdMap.entrySet()) {
            childrenMap.put(entry.getKey(), this.repoProc.listChildrenNames(entry.getValue()));
        }
        return ApiResult.ok(childrenMap);
    }

    @Override
    public ApiResult<List<SysOrgBasicDTO>> queryList(SysOrgQueryDTO queryDTO) {
        List dataList = this.repoProc.queryList(queryDTO).stream().map(this::wrapBasicDTO).collect(Collectors.toList());
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<PagingVO<OrgPagedRespVO>> page(CommonOrgPageQueryVO queryVO) {
        Map<Object, Object> ouNameMap;
        PagingVO<SysOrgDO> pageData = this.repoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(CONVERT::do2PageRespVO));
        }
        Map udcType = super.udcMap((BaseUdc)new OrgType());
        Set<String> parentCodes = pageData.stream().map(SysOrgDO::getParentCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map nameMap = parentCodes.isEmpty() ? Collections.emptyMap() : this.repoProc.getNameByCode(parentCodes);
        Set<Long> ouIds = pageData.stream().map(SysOrgDO::getOuId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> map = ouNameMap = ouIds.isEmpty() ? new HashMap(0) : this.ouRepoProc.getNameMapById(ouIds);
        if (StringUtils.hasText((String)queryVO.getWithParentType()) && !udcType.containsKey(queryVO.getWithParentType())) {
            log.warn("\u4e0d\u5305\u542b\u7684\u7ec4\u7ec7\u4e0a\u7ea7\u7c7b\u578b\uff1a{}\uff0c\u5c06\u5ffd\u7565", (Object)queryVO.getWithParentType());
            queryVO.setWithParentType(null);
        }
        List<Long> ids = pageData.getRecords().stream().map(BaseModel::getId).collect(Collectors.toList());
        Map withParent = StringUtils.hasText((String)queryVO.getWithParentType()) ? this.repoProc.queryParentNameForType(ids, queryVO.getWithParentType(), Boolean.TRUE.equals(queryVO.getEnabled())) : Collections.emptyMap();
        PagingVO pageResult = pageData.map(t -> {
            OrgPagedRespVO vo = CONVERT.do2PageRespVO((SysOrgDO)t);
            vo.setParentName((String)nameMap.get(t.getParentCode()));
            vo.setTypeName((String)udcType.get(t.getType()));
            vo.setOuName((String)ouNameMap.get(t.getOuId()));
            IdCodeNameParam tempParent = (IdCodeNameParam)withParent.get(vo.getId());
            if (tempParent != null) {
                vo.setWithParentId(tempParent.getId());
                vo.setWithParentCode(tempParent.getCode());
                vo.setWithParentName(tempParent.getName());
            }
            return vo;
        });
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<PagingVO<SysOrgPageRespDTO>> queryPage(SysOrgPageQueryDTO queryDTO) {
        PagingVO<SysOrgDO> pageData = this.repoProc.pageQuery(queryDTO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(CONVERT::do2PageRespDTO));
        }
        List<Long> ids = pageData.getRecords().stream().map(BaseModel::getId).collect(Collectors.toList());
        Map udcType = super.udcMap((BaseUdc)new OrgType());
        if (StringUtils.hasText((String)queryDTO.getWithParentType()) && !udcType.containsKey(queryDTO.getWithParentType())) {
            log.warn("\u4e0d\u5305\u542b\u7684\u7ec4\u7ec7\u4e0a\u7ea7\u7c7b\u578b\uff1a{}\uff0c\u5c06\u5ffd\u7565", (Object)queryDTO.getWithParentType());
            queryDTO.setWithParentType(null);
        }
        Map withParent = StringUtils.hasText((String)queryDTO.getWithParentType()) ? this.repoProc.queryParentNameForType(ids, queryDTO.getWithParentType(), Boolean.TRUE.equals(queryDTO.getEnabled())) : Collections.emptyMap();
        PagingVO pageResult = pageData.map(t -> {
            SysOrgPageRespDTO vo = CONVERT.do2PageRespDTO((SysOrgDO)t);
            vo.setTypeName((String)udcType.get(vo.getType()));
            IdCodeNameParam tempParent = (IdCodeNameParam)withParent.get(vo.getId());
            if (tempParent != null) {
                vo.setWithParentId(tempParent.getId());
                vo.setWithParentCode(tempParent.getCode());
                vo.setWithParentName(tempParent.getName());
            }
            return vo;
        });
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<IdCodeNameParam> getParentOrgByType(Long id, String code, String parentType) {
        if (id == null && CharSequenceUtil.isBlank((CharSequence)code)) {
            GeneralUserDetails currentUser = super.currentUser(false);
            if (currentUser != null) {
                id = currentUser.getOrgId();
            }
            if (id == null) {
                return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
            }
        }
        if (id == null) {
            id = this.repoProc.getIdByCode(code);
        }
        if (id == null) {
            return ApiResult.ok(null);
        }
        IdCodeNameParam parent = this.repoProc.queryParentNameForType(List.of(id), parentType, true).get(id);
        return ApiResult.ok((Object)parent);
    }

    private SysOrgDetailRespDTO wrapDetailDTO(SysOrgDO orgDO, String withParentType) {
        SysOrgDetailRespDTO respDTO = CONVERT.do2DetailRespDTO(orgDO);
        if (orgDO.getPId() != null) {
            respDTO.setParentId(orgDO.getPId());
            respDTO.setParentName(this.repoProc.getNameById(orgDO.getPId()));
        }
        respDTO.setTypeName(super.udcValue((BaseUdc)new OrgType(respDTO.getType())));
        if (respDTO.getOuId() != null) {
            respDTO.setOuName(this.ouRepoProc.getOuName(respDTO.getOuId()));
        }
        respDTO.setTypeName(super.udcValue((BaseUdc)new OrgType(respDTO.getType())));
        respDTO.setRegionName(super.udcValue((BaseUdc)new SysRegion(respDTO.getRegion())));
        respDTO.setBusinessUnitName(super.udcValue((BaseUdc)new SysBusinessUnit(respDTO.getBusinessUnit())));
        respDTO.setProfitablyCenterName(super.udcValue((BaseUdc)new SysProfitablyCenter(respDTO.getProfitablyCenter())));
        respDTO.setFunctionTypeName(super.udcValue((BaseUdc)new SysFunctionType(respDTO.getFunctionType())));
        if (CharSequenceUtil.isNotBlank((CharSequence)withParentType)) {
            IdCodeNameParam withParent = this.repoProc.queryParentNameForType(List.of(orgDO.getId()), withParentType, true).get(orgDO.getId());
            respDTO.setWithParent(withParent);
        }
        return respDTO;
    }

    private SysOrgBasicDTO wrapBasicDTO(SysOrgBasicDTO dto) {
        if (dto == null) {
            return null;
        }
        if (CharSequenceUtil.isBlank((CharSequence)dto.getParentCode())) {
            dto.setParentId(null);
        }
        return dto;
    }
}

