/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.SysOuType;
import com.elitescloud.cloudt.system.convert.OuConvert;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonCompanyPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuPageRespVO;
import com.elitescloud.cloudt.system.service.OuQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysOuDO;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class OuQueryServiceImpl
extends BaseServiceImpl
implements OuQueryService {
    private static final OuConvert CONVERT = OuConvert.INSTANCE;
    @Autowired
    private OuRepoProc repoProc;

    @Override
    public ApiResult<PagingVO<OuPageRespVO>> pageQuery(CommonCompanyPageQueryVO queryVO) {
        PagingVO<SysOuDO> pageData = this.repoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(CONVERT::do2PageRespVO));
        }
        Map ouTypeNames = super.udcMap((BaseUdc)new SysOuType());
        PagingVO result = pageData.map(t -> {
            OuPageRespVO vo = CONVERT.do2PageRespVO((SysOuDO)t);
            vo.setOuTypeName((String)ouTypeNames.get(t.getOuType()));
            return vo;
        });
        return ApiResult.ok((Object)result);
    }
}

