/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusApiRepoProc;
import com.elitescloud.cloudt.system.common.DprPropagateStrategyEnum;
import com.elitescloud.cloudt.system.convert.PermissionConverter;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprApiCustomRuleSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprApiFieldSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.MenuApiSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.OrgRolePermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RolePermissionCopySaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RolePermissionPropagationSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RolePermissionSaveVO;
import com.elitescloud.cloudt.system.service.PermissionMngService;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysAppPermissionBatchSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysAppPermissionSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprApiCustomRuleSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprBatchSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysPermissionSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.repo.ApiManageRepoProc;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class PermissionMngServiceImpl
extends BaseServiceImpl
implements PermissionMngService {
    @Autowired
    private PermissionMngManager permissionMngManager;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private SysPlatformMenusApiRepoProc menusApiRepoProc;
    @Autowired
    private MenuRepoProc menuRepoProc;
    @Autowired
    private ApiManageRepoProc apiRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveUserRoles(Long userId, List<Long> roleIds) {
        this.permissionMngManager.saveUserRole(userId, roleIds);
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> saveUserRoles(List<UserRoleSaveDTO> saveDTOList) {
        Map<Object, Object> roleIdMap;
        Map userIdMap;
        if (CollUtil.isEmpty(saveDTOList)) {
            return ApiResult.fail((String)"\u4fdd\u5b58\u6570\u636e\u4e3a\u7a7a");
        }
        HashSet<String> usernames = new HashSet<String>(64);
        HashSet<String> roleCodes = new HashSet<String>(64);
        for (UserRoleSaveDTO userRoleSaveDTO : saveDTOList) {
            if (userRoleSaveDTO.getUserId() == null) {
                if (CharSequenceUtil.isBlank((CharSequence)userRoleSaveDTO.getUsername())) {
                    return ApiResult.fail((String)"\u5b58\u5728\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\u7684\u8bb0\u5f55");
                }
                usernames.add(userRoleSaveDTO.getUsername());
            }
            if (!CollUtil.isEmpty((Collection)userRoleSaveDTO.getRoleIds()) || !CollUtil.isNotEmpty((Collection)userRoleSaveDTO.getRoleCodes())) continue;
            roleCodes.addAll(userRoleSaveDTO.getRoleCodes());
        }
        if (usernames.isEmpty()) {
            userIdMap = Collections.emptyMap();
        } else {
            userIdMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.getIdAndUsernameByUsername(usernames));
            String notExistsUsernames = usernames.stream().filter(t -> !userIdMap.containsKey(t)).collect(Collectors.joining(","));
            if (CharSequenceUtil.isNotBlank((CharSequence)notExistsUsernames)) {
                return ApiResult.fail((String)("\u4ee5\u4e0b\u7528\u6237\u4e0d\u5b58\u5728\uff1a" + notExistsUsernames));
            }
        }
        if (!roleCodes.isEmpty()) {
            roleIdMap = this.roleRepoProc.getIdAndCodeByCode(roleCodes);
            String notExistsRoles = roleCodes.stream().filter(t -> !roleIdMap.containsKey(t)).collect(Collectors.joining(","));
            if (CharSequenceUtil.isNotBlank((CharSequence)notExistsRoles)) {
                return ApiResult.fail((String)("\u4ee5\u4e0b\u89d2\u8272\u4e0d\u5b58\u5728\uff1a" + notExistsRoles));
            }
        } else {
            roleIdMap = Collections.emptyMap();
        }
        ArrayList userIdList = new ArrayList();
        for (UserRoleSaveDTO dto : saveDTOList) {
            Long userId = (Long)ObjectUtil.defaultIfNull((Object)dto.getUserId(), (Object)((Long)userIdMap.get(dto.getUsername())));
            List<Long> roleIds = null;
            roleIds = CollUtil.isEmpty((Collection)dto.getRoleIds()) && CollUtil.isNotEmpty((Collection)dto.getRoleCodes()) ? dto.getRoleCodes().stream().map(roleIdMap::get).collect(Collectors.toList()) : (CollUtil.isEmpty((Collection)dto.getRoleIds()) ? Collections.emptyList() : new ArrayList<Long>(dto.getRoleIds()));
            this.saveUserRoles(userId, roleIds);
        }
        return ApiResult.ok(userIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveRoleUser(Long roleId, List<Long> userIds, Boolean incremental) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u89d2\u8272ID\u4e3a\u7a7a");
        }
        if (incremental == null) {
            incremental = false;
        }
        this.permissionMngManager.saveRoleUser(roleId, userIds, incremental, false);
        return ApiResult.ok((Object)roleId);
    }

    @Override
    public ApiResult<Long> saveRoleEmployee(Long roleId, List<Long> userIds, Boolean incremental) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u89d2\u8272ID\u4e3a\u7a7a");
        }
        if (incremental == null) {
            incremental = false;
        }
        this.permissionMngManager.saveRoleUser(roleId, userIds, incremental, true);
        return ApiResult.ok((Object)roleId);
    }

    @Override
    public ApiResult<Boolean> saveUserRoleByOrg(OrgRolePermissionSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getOrgCodes()) || CollUtil.isEmpty(saveVO.getRoleCodes())) {
            return ApiResult.fail((String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        Set<Long> userIds = this.orgRepoProc.queryEmployeeByOrg(saveVO.getOrgCodes(), Boolean.TRUE.equals(saveVO.getWithChildrenOrg()), true);
        if (userIds.isEmpty()) {
            return ApiResult.ok((Object)true);
        }
        this.permissionMngManager.addUserRole(userIds, saveVO.getRoleCodes());
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> removeRoleUser(Long roleId, Long userId) {
        if (ObjectUtil.hasNull((Object[])new Object[]{roleId, userId})) {
            return ApiResult.fail((String)"\u89d2\u8272\u548c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.permissionMngManager.removeRoleUser(roleId, List.of(userId));
        return ApiResult.ok((Object)roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> savePermissionMenu(Long roleId, List<RoleAppPermissionSaveVO> saveVOList) {
        List<Object> saveBos = null;
        saveBos = CollectionUtils.isEmpty(saveVOList) ? Collections.emptyList() : saveVOList.stream().map(this::vo2Bo).collect(Collectors.toList());
        this.permissionMngManager.saveRoleMenu(roleId, saveBos);
        return ApiResult.ok((Object)roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addPermissionMenu(Long roleId, RoleAppPermissionSaveVO saveVO) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u89d2\u8272ID\u4e3a\u7a7a");
        }
        if (saveVO == null || CharSequenceUtil.isBlank((CharSequence)saveVO.getAppCode()) || CollUtil.isEmpty(saveVO.getPermissionList())) {
            return ApiResult.fail((String)"\u6743\u9650\u4fe1\u606f\u4e3a\u7a7a");
        }
        SysAppPermissionSaveBO saveBO = this.vo2Bo(saveVO);
        this.permissionMngManager.addRoleMenu(roleId, saveBO);
        return ApiResult.ok((Object)roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> removePermissionMenu(Long roleId, RoleAppPermissionSaveVO saveVO) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u89d2\u8272ID\u4e3a\u7a7a");
        }
        if (saveVO == null || CharSequenceUtil.isBlank((CharSequence)saveVO.getAppCode()) || CollUtil.isEmpty(saveVO.getPermissionList())) {
            return ApiResult.fail((String)"\u6743\u9650\u4fe1\u606f\u4e3a\u7a7a");
        }
        SysAppPermissionSaveBO saveBO = this.vo2Bo(saveVO);
        this.permissionMngManager.removeRoleMenu(roleId, saveBO);
        return ApiResult.ok((Object)roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> savePermissionMenuBatch(RoleAppPermissionBatchSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getRoleIds())) {
            return ApiResult.fail((String)"\u89d2\u8272\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)saveVO.getAppCode()) || CollUtil.isEmpty(saveVO.getPermissionList())) {
            return ApiResult.fail((String)"\u6743\u9650\u4fe1\u606f\u4e3a\u7a7a");
        }
        SysAppPermissionBatchSaveBO saveBO = this.vo2Bo(saveVO);
        this.permissionMngManager.saveRoleMenuBatch(saveBO);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveApiDataPermission(SysDprSaveVO saveVO) {
        SysDprApiCustomRuleSaveBO bo;
        SysDprSaveBO saveBO = new SysDprSaveBO();
        saveBO.setRoleId(saveVO.getRoleId());
        saveBO.setMenuCode(saveVO.getMenuCode());
        saveBO.setApiCode(saveVO.getApiCode());
        saveBO.setRange(saveVO.getRange());
        saveBO.setCustomRuleList(new ArrayList(16));
        if (CollUtil.isNotEmpty(saveVO.getCustomRuleList())) {
            for (SysDprApiCustomRuleSaveVO sysDprApiCustomRuleSaveVO : saveVO.getCustomRuleList()) {
                bo = PermissionConverter.INSTANCE.convertCustomRuleSaveBO(sysDprApiCustomRuleSaveVO);
                saveBO.getCustomRuleList().add(bo);
            }
        }
        saveBO.setFieldList(new ArrayList(16));
        if (CollUtil.isNotEmpty(saveVO.getFieldList())) {
            bo = null;
            for (SysDprApiFieldSaveVO sysDprApiFieldSaveVO : saveVO.getFieldList()) {
                bo = PermissionConverter.INSTANCE.convertFieldSaveBO(sysDprApiFieldSaveVO);
                saveBO.getFieldList().add(bo);
            }
        }
        this.permissionMngManager.saveDataPermission(saveBO);
        return ApiResult.ok((Object)saveVO.getRoleId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveDataPermission(DataPermissionSaveVO saveVO) {
        this.permissionMngManager.saveDataPermission(saveVO);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveApiDataPermission(SysDprBatchSaveVO saveVO) {
        SysDprBatchSaveBO saveBO = new SysDprBatchSaveBO();
        saveBO.setRoleId(saveVO.getRoleId());
        saveBO.setStrategy(this.convertSaveStrategy(saveVO.getSaveStrategy()));
        if (CollUtil.isEmpty(saveVO.getMenuApiList())) {
            return ApiResult.fail((String)"\u8bf7\u5148\u9009\u62e9API\u63a5\u53e3");
        }
        saveBO.setMenuApiList(saveVO.getMenuApiList().stream().map(t -> {
            SysDprBatchSaveBO.MenuApiSaveBO menuApi = new SysDprBatchSaveBO.MenuApiSaveBO();
            menuApi.setMenuCode(t.getMenuCode());
            menuApi.setApiCode(t.getApiCode());
            return menuApi;
        }).collect(Collectors.toList()));
        saveBO.setCustomRuleList(new ArrayList(16));
        if (CollUtil.isNotEmpty(saveVO.getCustomRuleList())) {
            for (SysDprApiCustomRuleSaveVO vo : saveVO.getCustomRuleList()) {
                SysDprApiCustomRuleSaveBO bo = PermissionConverter.INSTANCE.convertCustomRuleSaveBO(vo);
                saveBO.getCustomRuleList().add(bo);
            }
        }
        this.permissionMngManager.saveDataPermissionBatch(saveBO);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveMenuApi(MenuApiSaveVO saveVO) {
        Assert.notNull((Object)saveVO.getApiId(), (String)"\u8bf7\u9009\u62e9\u63a5\u53e3");
        String apiCode = this.apiRepoProc.getCode(saveVO.getApiId());
        if (CharSequenceUtil.isBlank((CharSequence)apiCode)) {
            return ApiResult.fail((String)"\u63a5\u53e3\u6570\u636e\u5f02\u5e38\uff0c\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a");
        }
        Map<String, Long> appMap = this.appRepoProc.all().stream().collect(Collectors.toMap(SysPlatformAppDO::getAppCode, BaseModel::getId, (t1, t2) -> t1));
        Set menuIds = (Set)ObjectUtil.defaultIfNull(saveVO.getMenuIds(), Collections.emptySet());
        Map menuMap = menuIds.isEmpty() ? Collections.emptyMap() : this.menuRepoProc.get(menuIds).stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        Map<Long, SysPlatformMenusApiDO> existsList = this.menusApiRepoProc.queryListByApi(saveVO.getApiId().longValue(), saveVO.getAppCode()).stream().collect(Collectors.toMap(SysPlatformMenusApiDO::getMenusId, t -> t, (t1, t2) -> t1));
        ArrayList<SysPlatformMenusApiDO> toAddList = new ArrayList<SysPlatformMenusApiDO>();
        for (Map.Entry entry : menuMap.entrySet()) {
            if (existsList.containsKey(entry.getKey())) continue;
            SysPlatformMenusApiDO menusApiDO = new SysPlatformMenusApiDO();
            menusApiDO.setAppId(appMap.get(((SysPlatformMenusDO)entry.getValue()).getMenusAppCode()));
            menusApiDO.setAppCode(((SysPlatformMenusDO)entry.getValue()).getMenusAppCode());
            menusApiDO.setMenusId(((SysPlatformMenusDO)entry.getValue()).getId());
            menusApiDO.setMenusCode(((SysPlatformMenusDO)entry.getValue()).getMenusCode());
            menusApiDO.setApiId(saveVO.getApiId());
            menusApiDO.setApiCode(apiCode);
            toAddList.add(menusApiDO);
        }
        HashSet<Long> toDelIds = new HashSet<Long>();
        for (Map.Entry<Long, SysPlatformMenusApiDO> entry : existsList.entrySet()) {
            if (menuMap.containsKey(entry.getKey())) continue;
            toDelIds.add(entry.getValue().getId());
        }
        if (!toDelIds.isEmpty()) {
            this.menusApiRepoProc.delete(toDelIds);
        }
        if (!toAddList.isEmpty()) {
            this.menusApiRepoProc.save(toAddList);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> clearPermission(Long roleId, String appCode) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u89d2\u8272");
        }
        this.permissionMngManager.clearRoleMenu(roleId, appCode);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> copyPermission(RolePermissionCopySaveVO saveVO) {
        if (saveVO.getOriginalRoleId() == null) {
            return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u539f\u89d2\u8272");
        }
        if (CollUtil.isEmpty(saveVO.getTargetIds())) {
            return ApiResult.ok((Object)true);
        }
        this.permissionMngManager.copyRoleMenu(saveVO.getOriginalRoleId(), saveVO.getTargetIds(), saveVO.getAppCode(), (Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getMerge(), (Object)true));
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> propagateDataPermission(RolePermissionPropagationSaveVO saveVO) {
        if (saveVO.getRoleId() == null) {
            return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u89d2\u8272");
        }
        if (CharSequenceUtil.isBlank((CharSequence)saveVO.getBusinessObjectCode())) {
            return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u8d44\u6e90");
        }
        this.permissionMngManager.propagateDataPermission(saveVO.getRoleId(), saveVO.getBusinessObjectCode(), (DprPropagateStrategyEnum)((Object)ObjectUtil.defaultIfNull((Object)((Object)saveVO.getStrategy()), (Object)((Object)DprPropagateStrategyEnum.OVERWRITE))));
        return ApiResult.ok((Object)true);
    }

    private SysAppPermissionSaveBO vo2Bo(RoleAppPermissionSaveVO saveVO) {
        List<SysPermissionSaveBO> permissionList = this.convertPermissionVo(saveVO.getPermissionList());
        return new SysAppPermissionSaveBO(saveVO.getAppCode(), permissionList);
    }

    private SysAppPermissionBatchSaveBO vo2Bo(RoleAppPermissionBatchSaveVO saveVO) {
        List<SysPermissionSaveBO> permissionList = this.convertPermissionVo(saveVO.getPermissionList());
        return new SysAppPermissionBatchSaveBO(saveVO.getAppCode(), saveVO.getAdd() != null && saveVO.getAdd() != false, saveVO.getRoleIds(), permissionList);
    }

    private List<SysPermissionSaveBO> convertPermissionVo(List<RolePermissionSaveVO> permissionList) {
        if (CollUtil.isEmpty(permissionList)) {
            return Collections.emptyList();
        }
        return permissionList.stream().filter(tt -> {
            MenuTreeNodeType nodeType = MenuTreeNodeType.valueOf((String)tt.getNodeType());
            return nodeType == MenuTreeNodeType.APP || nodeType == MenuTreeNodeType.MENU || nodeType == MenuTreeNodeType.ACTION;
        }).map(tt -> new SysPermissionSaveBO(tt.getCode(), tt.getNodeType())).collect(Collectors.toList());
    }

    private SysDprBatchSaveBO.Strategy convertSaveStrategy(String strategyName) {
        if (CharSequenceUtil.isBlank((CharSequence)strategyName)) {
            return SysDprBatchSaveBO.Strategy.APPEND;
        }
        Map<String, SysDprBatchSaveBO.Strategy> strategyMap = Arrays.stream(SysDprBatchSaveBO.Strategy.values()).collect(Collectors.toMap(Enum::name, t -> t, (t1, t2) -> t1));
        return strategyMap.getOrDefault(strategyName, SysDprBatchSaveBO.Strategy.APPEND);
    }
}

