/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonAppInstanceRespVO;
import com.elitescloud.cloudt.system.service.PlatformQueryService;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysVersionRepoProc;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class PlatformQueryServiceImpl
implements PlatformQueryService {
    @Autowired
    private SysVersionRepoProc versionRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;

    @Override
    public ApiResult<List<CodeNameParam>> listProjectVersion() {
        List versionList = this.versionRepoProc.queryVersionList().stream().map(t -> new CodeNameParam(t, t)).collect(Collectors.toList());
        return ApiResult.ok(versionList);
    }

    @Override
    public ApiResult<List<CommonAppInstanceRespVO>> serviceInstanceList(String serviceId, Boolean appOnly) {
        List services;
        DiscoveryClient discoveryClient = (DiscoveryClient)SpringContextHolder.getBean(DiscoveryClient.class);
        List list = services = StringUtils.hasText((String)serviceId) ? List.of(serviceId) : discoveryClient.getServices();
        if (services.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map appMap = this.appRepoProc.allParams(null).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Function.identity(), (t1, t2) -> t1));
        List respVoList = services.stream().filter(s -> appOnly != null && appOnly == false || appMap.containsKey(s)).map(s -> {
            List instances;
            CommonAppInstanceRespVO respVO = new CommonAppInstanceRespVO();
            respVO.setServiceId((String)s);
            IdCodeNameParam app = (IdCodeNameParam)appMap.get(s);
            if (app != null) {
                respVO.setServiceName(app.getName());
            }
            if (CollUtil.isNotEmpty((Collection)(instances = discoveryClient.getInstances(s)))) {
                List<CommonAppInstanceRespVO.Instance> insList = instances.stream().map(t -> {
                    CommonAppInstanceRespVO.Instance ins = new CommonAppInstanceRespVO.Instance();
                    ins.setUri(t.getUri() == null ? null : t.getUri().toString());
                    ins.setSchema(t.getScheme());
                    ins.setSecure(t.isSecure());
                    ins.setHost(t.getHost());
                    ins.setPort(t.getPort());
                    return ins;
                }).collect(Collectors.toList());
                respVO.setInstances(insList);
                respVO.setUris(insList.stream().map(CommonAppInstanceRespVO.Instance::getUri).distinct().filter(StringUtils::hasText).collect(Collectors.toList()));
            } else {
                respVO.setInstances(Collections.emptyList());
                respVO.setUris(Collections.emptyList());
            }
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }
}

