/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.support.common.param.SysVersionUploadVO;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.ProjectVersionConvert;
import com.elitescloud.cloudt.system.model.vo.query.devops.ProjectVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ProjectVersionPageRespVO;
import com.elitescloud.cloudt.system.service.ProjectVersionMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysProjectVersionDO;
import com.elitescloud.cloudt.system.service.repo.ProjectVersionRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class ProjectVersionMngServiceImpl
implements ProjectVersionMngService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectVersionMngServiceImpl.class);
    @Autowired
    private ProjectVersionRepoProc repoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> upload(SysVersionUploadVO versionUploadVO) {
        String clientIp = HttpServletUtil.currentClientIp();
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{versionUploadVO.getApplicationCode(), versionUploadVO.getProject(), versionUploadVO.getEnv()})) {
            logger.info("\u4e0a\u62a5\u7684\u7248\u672c\u4fe1\u606f\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u4fe1\u606f\uff0c\u5ffd\u7565\u4e0a\u62a5\uff1a{}", (Object)clientIp);
            return ApiResult.fail((String)"\u7f3a\u5c11\u5fc5\u8981\u7684\u4fe1\u606f");
        }
        SysProjectVersionDO versionDO = this.repoProc.getExistsRecord(versionUploadVO.getProject(), versionUploadVO.getEnv(), versionUploadVO.getApplicationCode());
        if (versionDO == null) {
            versionDO = new SysProjectVersionDO();
        }
        ProjectVersionConvert.INSTANCE.uploadVo2Do(versionUploadVO, versionDO);
        if (StringUtils.hasText((String)versionUploadVO.getBuildTime())) {
            versionDO.setBuildDateTime(DatetimeUtil.parseLocalDateTime((String)versionUploadVO.getBuildTime()));
        }
        versionDO.setReporterIp(clientIp);
        versionDO.setReportTime(LocalDateTime.now());
        this.repoProc.save((Serializable)versionDO);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<PagingVO<ProjectVersionPageRespVO>> pageMng(ProjectVersionPageQueryVO queryVO) {
        PagingVO pageData = this.repoProc.pageMng(queryVO).map(ProjectVersionConvert.INSTANCE::do2PageRespVO);
        return ApiResult.ok((Object)pageData);
    }
}

