/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.ResourceByteQueryService;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
public class ResourceByteQueryServiceImpl
implements ResourceByteQueryService {
    private static final Logger log = LoggerFactory.getLogger(ResourceByteQueryServiceImpl.class);
    @Autowired
    private ResourceByteRepoProc repoProc;

    @Override
    public ResponseEntity<StreamingResponseBody> download(String fileCode) {
        SysResourceByteDO resourceByteDO;
        SysResourceByteDO sysResourceByteDO = resourceByteDO = StringUtils.hasText((String)fileCode) ? this.repoProc.getByResourceKey(fileCode) : null;
        if (resourceByteDO == null || ArrayUtil.isEmpty((Object)((Object)resourceByteDO))) {
            return ResponseEntity.notFound().build();
        }
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(resourceByteDO.getShowName(), StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType((MediaType)ObjectUtil.defaultIfNull((Object)this.parseMediaType(resourceByteDO.getMimeType()), (Object)MediaType.APPLICATION_OCTET_STREAM)).header("Content-Disposition", new String[]{contentDisposition.toString()})).contentLength((long)resourceByteDO.getResource().length).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])resourceByteDO.getResource(), (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private MediaType parseMediaType(String mimeType) {
        if (CharSequenceUtil.isBlank((CharSequence)mimeType)) {
            return null;
        }
        String[] types = mimeType.split("/");
        return types.length > 1 ? new MediaType(types[0], types[1]) : new MediaType(types[0]);
    }
}

