/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.PermissionResBO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserListRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserBaseSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.service.SubUserMngService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.bo.AreaBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysSubUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.PermissionResRepoProc;
import com.elitescloud.cloudt.system.service.repo.SubUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import com.google.common.base.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class SubUserMngServiceImpl
implements SubUserMngService {
    @Autowired
    private SubUserRepoProc repoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private UserTypeRepoProc userTypeRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private PermissionResRepoProc permissionResRepoProc;
    @Autowired
    private PermissionMngManager permissionMngManager;
    @Autowired
    private UserMngManager userMngManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private UserMngService userMngService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(SubUserSaveVO saveVO) {
        SysSubUserDO subUserDO = null;
        try {
            subUserDO = this.checkForSave(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        SysUserDO userDO = (SysUserDO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            SysUserSaveBO userSaveBO = null;
            try {
                userSaveBO = this.convert2UserSaveBO(saveVO.getUserInfo(), tenant);
            }
            catch (Exception e) {
                throw new BusinessException("\u4fdd\u5b58\u8d26\u53f7\u5931\u8d25\uff0c" + e.getMessage());
            }
            return this.userMngManager.upsert(userSaveBO);
        });
        subUserDO.setSubUserId(userDO.getId());
        this.repoProc.save((Serializable)subUserDO);
        this.saveUserPermission(Set.of(userDO.getId()), saveVO);
        return ApiResult.ok((Object)subUserDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> saveBatch(SubUserBatchSaveVO saveVO) {
        Set<Long> userIds = saveVO.getUserIds();
        Assert.notEmpty(userIds, (String)"\u8d26\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Long> existsUserIds = this.repoProc.filterExistsSubUser(userIds);
        if (userIds.size() == existsUserIds.size()) {
            return ApiResult.fail((String)"\u5b50\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        this.checkBaseSubUserSaveVO(saveVO);
        ArrayList<SysSubUserDO> subUserList = new ArrayList<SysSubUserDO>();
        SysSubUserDO subUser = null;
        for (Long userId : userIds) {
            subUser = new SysSubUserDO();
            subUser.setSubUserId(userId);
            subUser.setType(saveVO.getBelongType().getValue());
            subUser.setTypeId(saveVO.getBelongerId());
            subUser.setPermissionType(saveVO.getGrantType().name());
            subUserList.add(subUser);
        }
        this.repoProc.save(subUserList);
        this.saveUserPermission(userIds, saveVO);
        List idList = subUserList.stream().map(BaseModel::getId).collect(Collectors.toList());
        return ApiResult.ok(idList);
    }

    @Override
    public ApiResult<List<SubUserListRespVO>> querySubUserList(BelongType belongType, String belongerId, String roleCode) {
        BelongType.Belonger belonger = this.normalize(belongType, belongerId);
        List<SubUserListRespVO> subUserListRespVOList = this.repoProc.querySubUsers(belonger, roleCode);
        if (subUserListRespVOList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set userIds = subUserListRespVOList.stream().map(SubUserListRespVO::getSubUserId).collect(Collectors.toSet());
        Map userMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.queryUserList(userIds))).stream().collect(Collectors.toMap(UserListRespVO::getId, Functions.identity(), (t1, t2) -> t1));
        subUserListRespVOList = subUserListRespVOList.stream().filter(t -> userMap.containsKey(t.getSubUserId())).peek(t -> {
            UserListRespVO user = (UserListRespVO)userMap.get(t.getSubUserId());
            t.setUsername(user.getUsername());
            t.setLastName(user.getLastName());
            t.setFirstName(user.getFirstName());
            t.setMobile(user.getMobile());
            t.setEmail(user.getEmail());
        }).collect(Collectors.toList());
        return ApiResult.ok(subUserListRespVOList);
    }

    @Override
    public ApiResult<SubUserDetailRespVO> get(Long id) {
        Assert.notNull((Object)id, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysSubUserDO subUserDO = (SysSubUserDO)this.repoProc.get(id);
        if (subUserDO == null) {
            return ApiResult.fail((String)"\u5b50\u8d26\u53f7\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        UserDetailRespVO userInfo = (UserDetailRespVO)this.userMngService.get(subUserDO.getSubUserId()).getData();
        if (userInfo == null) {
            return ApiResult.fail((String)"\u767b\u5f55\u8d26\u53f7\u5df2\u4e0d\u5b58\u5728");
        }
        SubUserDetailRespVO respVO = new SubUserDetailRespVO();
        respVO.setUser(userInfo);
        SubUserPermissionTypeEnum permissionType = SubUserPermissionTypeEnum.valueOf((String)subUserDO.getPermissionType());
        BelongType.Belonger belonger = new BelongType.Belonger(BelongType.valueOf((String)subUserDO.getType()), subUserDO.getTypeId());
        switch (permissionType) {
            case GRANT: {
                Set<String> resIds = this.permissionResRepoProc.listPermissionOfOwner(belonger, PermissionOwnerTypeEnum.USER, subUserDO.getSubUserId().toString()).stream().map(PermissionResBO.Res::getResId).collect(Collectors.toSet());
                respVO.setMenuCodes(resIds);
                break;
            }
            case GRANT_BY_ROLE: {
                List<IdCodeNameParam> roleList = this.userRoleRepoProc.getRolesOfUser(subUserDO.getSubUserId(), belonger);
                respVO.setRoleList(roleList);
                break;
            }
            case EXTENDS_ALL: {
                break;
            }
            default: {
                return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u7684\u6388\u6743\u7c7b\u578b");
            }
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> getRolesOfSubUser(Long id) {
        Assert.notNull((Object)id, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysSubUserDO subUserDO = (SysSubUserDO)this.repoProc.get(id);
        if (subUserDO == null) {
            return ApiResult.fail((String)"\u5b50\u8d26\u53f7\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        SubUserPermissionTypeEnum permissionType = SubUserPermissionTypeEnum.valueOf((String)subUserDO.getPermissionType());
        if (permissionType != SubUserPermissionTypeEnum.GRANT_BY_ROLE) {
            return ApiResult.ok(Collections.emptyList());
        }
        BelongType.Belonger belonger = new BelongType.Belonger(BelongType.valueOf((String)subUserDO.getType()), subUserDO.getTypeId());
        List<IdCodeNameParam> roleList = this.userRoleRepoProc.getRolesOfUser(subUserDO.getSubUserId(), belonger);
        return ApiResult.ok(roleList);
    }

    @Override
    public ApiResult<Set<String>> getMenuCodesOfSubUser(Long id) {
        Assert.notNull((Object)id, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysSubUserDO subUserDO = (SysSubUserDO)this.repoProc.get(id);
        if (subUserDO == null) {
            return ApiResult.fail((String)"\u5b50\u8d26\u53f7\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        SubUserPermissionTypeEnum permissionType = SubUserPermissionTypeEnum.valueOf((String)subUserDO.getPermissionType());
        if (permissionType != SubUserPermissionTypeEnum.GRANT) {
            return ApiResult.ok(Collections.emptySet());
        }
        BelongType.Belonger belonger = new BelongType.Belonger(BelongType.valueOf((String)subUserDO.getType()), subUserDO.getTypeId());
        Set menuCodes = this.permissionResRepoProc.listPermissionOfOwner(belonger, PermissionOwnerTypeEnum.USER, subUserDO.getSubUserId().toString()).stream().map(PermissionResBO.Res::getResId).collect(Collectors.toSet());
        return ApiResult.ok(menuCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> del(Set<Long> ids, Boolean delUser) {
        Assert.notEmpty(ids, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a", (Object[])new Object[0]);
        List subUserDOList = this.repoProc.get(ids);
        if (subUserDOList.isEmpty()) {
            return ApiResult.ok(ids);
        }
        block5: for (SysSubUserDO subUserDO : subUserDOList) {
            SubUserPermissionTypeEnum permissionType = SubUserPermissionTypeEnum.valueOf((String)subUserDO.getPermissionType());
            BelongType.Belonger belonger = new BelongType.Belonger(new BelongType(subUserDO.getType()), subUserDO.getTypeId());
            switch (permissionType) {
                case GRANT: {
                    this.permissionResRepoProc.delete(belonger, PermissionOwnerTypeEnum.USER, subUserDO.getSubUserId().toString());
                    continue block5;
                }
                case GRANT_BY_ROLE: {
                    this.userRoleRepoProc.deleteRolesOfUser(subUserDO.getSubUserId(), belonger);
                    continue block5;
                }
                case EXTENDS_ALL: {
                    continue block5;
                }
            }
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u7684\u6388\u6743\u7c7b\u578b");
        }
        if (delUser == null || !delUser.booleanValue()) {
            this.repoProc.delete(ids);
            return ApiResult.ok(ids);
        }
        List<Long> userIds = this.repoProc.querySubUserIds(ids);
        if (userIds.isEmpty()) {
            return ApiResult.ok(ids);
        }
        for (Long userId : userIds) {
            this.userMngManager.delete(userId);
        }
        this.repoProc.delete(ids);
        return ApiResult.ok(ids);
    }

    private void saveUserPermission(Set<Long> userIds, SubUserBaseSaveVO saveVO) {
        SubUserPermissionTypeEnum grantType = saveVO.getGrantType();
        switch (grantType) {
            case EXTENDS_ALL: {
                return;
            }
            case GRANT_BY_ROLE: {
                if (CollUtil.isEmpty(saveVO.getRoleCodes())) {
                    return;
                }
                this.permissionMngManager.addUserRole(userIds, saveVO.getRoleCodes());
                break;
            }
            case GRANT: {
                List permissionResList = CollUtil.isEmpty(saveVO.getMenuCodes()) ? Collections.emptyList() : saveVO.getMenuCodes().stream().filter(StringUtils::hasText).map(t -> new PermissionResBO.Res(MenuTreeNodeType.MENU, (String)t)).collect(Collectors.toList());
                List<PermissionResBO> permissionList = userIds.stream().filter(ObjectUtil::isNotNull).map(t -> {
                    PermissionResBO permissionResBO = new PermissionResBO();
                    permissionResBO.setOwnerTypeEnum(PermissionOwnerTypeEnum.USER);
                    permissionResBO.setOwnerId(t.toString());
                    permissionResBO.setResList(permissionResList);
                    return permissionResBO;
                }).collect(Collectors.toList());
                this.permissionMngManager.savePermissionRes(permissionList, new BelongType.Belonger(saveVO.getBelongType(), saveVO.getBelongerId()));
                break;
            }
            default: {
                throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u6388\u6743\u7c7b\u578b");
            }
        }
    }

    private SysUserSaveBO convert2UserSaveBO(UserSaveVO userSaveVO, SysTenantDTO tenantDTO) {
        Long userId = userSaveVO.getId();
        SysUserSaveBO userSaveBO = null;
        if (userId == null) {
            userSaveBO = UserConvert.INSTANCE.vo2SaveBo(userSaveVO);
        } else {
            SysUserDO userDO = (SysUserDO)this.userRepoProc.get(userId);
            Assert.notNull((Object)userDO, (String)"\u8d26\u53f7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            userSaveBO = UserConvert.INSTANCE.do2SaveBo(userDO);
            UserConvert.INSTANCE.copy2SaveBo(userSaveVO, userSaveBO);
        }
        AreaBO areaBO = AreaConvert.INSTANCE.vo2Bo(userSaveVO.getAreaVO());
        userSaveBO.setAreaBO(areaBO);
        if (!StringUtils.hasText((String)userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }
        if (userId != null) {
            List<SysUserTypeBO> userTypeList = this.userTypeRepoProc.getUserTypeBO(userId, tenantDTO.getId());
            userSaveBO.setUserTypes(new HashSet<SysUserTypeBO>(userTypeList));
        }
        return userSaveBO;
    }

    private SysSubUserDO checkForSave(SubUserSaveVO saveVO) {
        SysSubUserDO subUserDO = saveVO.getId() == null ? new SysSubUserDO() : (SysSubUserDO)this.repoProc.get(saveVO.getId());
        Assert.notNull((Object)subUserDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserSaveVO userInfo = saveVO.getUserInfo();
        Assert.notNull((Object)saveVO.getUserInfo(), (String)"\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        if (subUserDO.getId() != null) {
            Assert.isTrue((boolean)subUserDO.getSubUserId().equals(userInfo.getId()), (String)"\u9009\u62e9\u7684\u8d26\u53f7\u4e0d\u53ef\u53d8\u66f4", (Object[])new Object[0]);
        } else if (userInfo.getId() != null) {
            Assert.isTrue((!this.repoProc.existsSubUser(userInfo.getId()) ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u5df2\u662f\u5b50\u8d26\u53f7", (Object[])new Object[0]);
        }
        this.checkBaseSubUserSaveVO(saveVO);
        subUserDO.setPermissionType(saveVO.getGrantType().name());
        subUserDO.setType(saveVO.getBelongType().getValue());
        subUserDO.setTypeId(saveVO.getBelongerId());
        return subUserDO;
    }

    private void checkBaseSubUserSaveVO(SubUserBaseSaveVO saveVO) {
        if (saveVO.getGrantType() == null) {
            saveVO.setGrantType(SubUserPermissionTypeEnum.EXTENDS_ALL);
        }
        BelongType.Belonger belonger = this.normalize(saveVO.getBelongType(), saveVO.getBelongerId());
        saveVO.setBelongType(belonger.getBelongType());
        saveVO.setBelongerId(belonger.getBelongId());
    }

    private BelongType.Belonger normalize(BelongType belongType, String belongerId) {
        if (belongType == null) {
            return BelongType.getBelongerPersonal();
        }
        return new BelongType.Belonger(belongType, BelongType.getBelongerId((BelongType)belongType, (String[])new String[]{belongerId}));
    }
}

