/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.entity.SysAlertConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysAlertDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;
import com.elitescloud.cloudt.system.service.SysAlertService;
import com.elitescloud.cloudt.system.service.alert.AlertProvider;
import com.elitescloud.cloudt.system.service.impl.BaseAlertServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysAlertServiceImpl
extends BaseAlertServiceImpl
implements SysAlertService {
    private static final Logger log = LoggerFactory.getLogger(SysAlertServiceImpl.class);

    public ApiResult<Boolean> sendAlertByTmpl(String businessType, String category, Map<String, Object> tmplParams) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(tmplParams)) {
            return ApiResult.fail((String)"\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a");
        }
        this.send(businessType, (cfg, alertProvider) -> alertProvider.sendByTmpl((String)cfg, tmplParams, category));
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> sendAlert(String businessType, String category, String content) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)content)) {
            return ApiResult.fail((String)"\u53d1\u9001\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.send(businessType, (cfg, alertProvider) -> alertProvider.send((String)cfg, content, category));
        return ApiResult.ok((Object)true);
    }

    private void send(String businessType, BiConsumer<String, AlertProvider> consumer) {
        SysAlertDO alertDO = this.alertRepoProc.getByBusinessType(businessType);
        if (alertDO == null) {
            log.warn("\u9884\u8b66\u672a\u914d\u7f6e\uff1a{}", (Object)businessType);
            return;
        }
        if (!Boolean.TRUE.equals(alertDO.getEnabled())) {
            log.info("\u672a\u542f\u7528\u9884\u8b66\u914d\u7f6e\uff1a{}", (Object)businessType);
            return;
        }
        List<SysAlertConfigDO> configList = this.alertConfigRepoProc.getByBusinessType(businessType);
        Assert.notEmpty(configList, (String)"\u672a\u914d\u7f6e\u6709\u6548\u7684\u9884\u8b66\u9014\u5f84", (Object[])new Object[0]);
        SysAlertType alertType = null;
        AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO> alertProvider = null;
        for (SysAlertConfigDO configDO : configList) {
            if (Boolean.FALSE.equals(configDO.getEnabled())) {
                log.info("\u672a\u542f\u7528\u9884\u8b66\uff1a{}\uff0c{}", (Object)businessType, (Object)configDO.getAlertType());
                continue;
            }
            alertType = SysAlertType.parse((String)configDO.getAlertType());
            Assert.notNull((Object)alertType, (String)("\u672a\u77e5\u9884\u8b66\u7c7b\u578b\uff1a" + configDO.getAlertType()), (Object[])new Object[0]);
            alertProvider = super.getAlertProvider(alertType);
            Assert.notNull(alertProvider, (String)("\u4e0d\u652f\u6301\u7684\u9884\u8b66\u7c7b\u578b\uff1a" + configDO.getAlertType()), (Object[])new Object[0]);
            try {
                consumer.accept(configDO.getCfgJson(), alertProvider);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u9884\u8b66\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }
}

