/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.convert.SysSettingConvert;
import com.elitescloud.cloudt.system.model.entity.SysSettingDO;
import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.service.dto.SysSettingDTO;
import com.elitescloud.cloudt.system.service.repo.SysSettingRepo;
import com.elitescloud.cloudt.system.service.repo.SysSettingRepoProc;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class SysSettingServiceImpl
implements ISysSettingService {
    private final SysSettingRepo sysSettingRepo;
    private final SysSettingRepoProc sysSettingRepoProc;
    @Autowired
    private SysCacheSettingRpcService cacheSettingRpcService;

    public SysSettingServiceImpl(SysSettingRepo sysSettingRepo, SysSettingRepoProc sysSettingRepoProc) {
        this.sysSettingRepo = sysSettingRepo;
        this.sysSettingRepoProc = sysSettingRepoProc;
    }

    public PagingVO<SysSettingVO> search(SysSettingQParam param) {
        return this.sysSettingRepoProc.pageMng(param).map(SysSettingConvert.INSTANCE::doToVO);
    }

    @Cacheable(value={"sys-setting"}, key="#root.methodName")
    public List<SysSettingVO> all() {
        return this.sysSettingRepo.findAll().stream().map(SysSettingConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public SysSettingVO oneById(Long id) {
        return this.sysSettingRepo.findById(id).map(SysSettingConvert.INSTANCE::doToVO).orElse(null);
    }

    public SysSettingVO oneByNo(String no) {
        return this.sysSettingRepo.findBySettingNo(no).map(SysSettingConvert.INSTANCE::doToVO).orElse(null);
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public Long create(SysSettingVO sysSetting) {
        this.sysSettingRepo.findBySettingNo(sysSetting.getSettingNo()).ifPresent(s -> {
            throw new BusinessException("\u914d\u7f6e\uff1a" + s.getSettingNo() + ", \u5df2\u7ecf\u5b58\u5728");
        });
        SysSettingDO newSetting = (SysSettingDO)((Object)this.sysSettingRepo.save((Object)SysSettingConvert.INSTANCE.voToDO(sysSetting)));
        this.clearCache();
        return newSetting.getId();
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void update(SysSettingVO sysSettingVO) {
        Optional oldSetting = this.sysSettingRepo.findById(sysSettingVO.getId());
        if (oldSetting.isEmpty()) {
            throw new BusinessException("\u8bbe\u7f6e\uff1a" + sysSettingVO.getSettingNo() + ", \u672a\u627e\u5230");
        }
        SysSettingDO saveSetting = (SysSettingDO)((Object)oldSetting.get());
        Assert.isTrue((boolean)saveSetting.getSettingNo().equals(sysSettingVO.getSettingNo()), (String)"\u7f16\u53f7\u4e0d\u53ef\u4fee\u6539");
        saveSetting.setSettingVal(sysSettingVO.getSettingVal());
        saveSetting.setSettingName(sysSettingVO.getSettingName());
        saveSetting.setSettingType(sysSettingVO.getSettingType());
        saveSetting.setSettingType2(sysSettingVO.getSettingType2());
        saveSetting.setSettingStatus(sysSettingVO.getSettingStatus());
        saveSetting.setSettingDesc(sysSettingVO.getSettingDesc());
        saveSetting.setDefaultValue(sysSettingVO.getDefaultValue());
        saveSetting.setSortNo(sysSettingVO.getSortNo());
        this.sysSettingRepo.save((Object)saveSetting);
        this.clearCache();
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void removeByIds(List<Long> ids) {
        this.sysSettingRepo.deleteAllByIdIn(ids);
        this.clearCache();
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void removeByNos(List<String> nos) {
        this.sysSettingRepo.deleteAllBySettingNoIn(nos);
        this.clearCache();
    }

    public List<SysSettingDTO> findSettingsBySettingNo(String settingNo) {
        return this.sysSettingRepoProc.findDtosBySettingNo(settingNo);
    }

    private void clearCache() {
        this.cacheSettingRpcService.clearCache();
    }
}

