/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.UnifyQueryConvert;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.vo.query.sys.UnifyQueryPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UnifyQueryDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UnifyQueryPagedRespVO;
import com.elitescloud.cloudt.system.service.SysUnifyQueryMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysUnifyQueryRecordDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.UnifyQueryRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysUnifyQueryMngServiceImpl
implements SysUnifyQueryMngService {
    @Autowired
    private UnifyQueryRepoProc repoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Override
    public ApiResult<PagingVO<UnifyQueryPagedRespVO>> pageMng(UnifyQueryPagedQueryVO queryVO) {
        PagingVO<SysUnifyQueryRecordDO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(UnifyQueryConvert.INSTANCE::do2PagedRespVO));
        }
        Set userIds = pageData.stream().map(SysUnifyQueryRecordDO::getUserId).filter(ObjectUtil::isNotNull).collect(Collectors.toSet());
        Set businessObjectCodes = pageData.stream().map(SysUnifyQueryRecordDO::getBusinessObjectCode).filter(ObjectUtil::isNotNull).collect(Collectors.toSet());
        HashMap userMap = new HashMap(pageData.size());
        HashMap businessObjectMap = new HashMap(pageData.size());
        HashMap appMap = new HashMap(pageData.size());
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            if (!userIds.isEmpty()) {
                userMap.putAll(this.userRepoProc.getBasicDto(userIds).stream().collect(Collectors.toMap(SysUserBasicDTO::getId, Functions.identity(), (t1, t2) -> t1)));
            }
            if (!businessObjectMap.isEmpty()) {
                businessObjectMap.putAll(this.businessObjectRepoProc.getCodeAndNames(businessObjectCodes));
            }
            appMap.putAll(this.appRepoProc.allParams(null).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Functions.identity(), (t1, t2) -> t1)));
            return null;
        });
        PagingVO pageVO = pageData.map(t -> {
            UnifyQueryPagedRespVO vo = UnifyQueryConvert.INSTANCE.do2PagedRespVO((SysUnifyQueryRecordDO)t);
            SysUserBasicDTO user = (SysUserBasicDTO)userMap.get(t.getUserId());
            if (user != null) {
                vo.setUsername(user.getUsername());
                vo.setFullName(user.getFullName());
            }
            vo.setBusinessObjectName((String)businessObjectMap.get(t.getBusinessObjectCode()));
            IdCodeNameParam app = (IdCodeNameParam)appMap.get(t.getAppCode());
            if (app != null) {
                vo.setAppName(app.getName());
            }
            return vo;
        });
        return ApiResult.ok((Object)pageVO);
    }

    @Override
    public ApiResult<UnifyQueryDetailRespVO> get(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysUnifyQueryRecordDO recordDO = (SysUnifyQueryRecordDO)this.repoProc.get(id);
        if (recordDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        UnifyQueryDetailRespVO detailVO = UnifyQueryConvert.INSTANCE.do2DetailRespVO(recordDO);
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            if (recordDO.getUserId() != null) {
                SysUserBasicDTO user = this.userRepoProc.getBasicDto(recordDO.getUserId());
                ObjUtil.ifNotNull((Object)user, u -> {
                    detailVO.setUsername(u.getUsername());
                    detailVO.setFullName(u.getFullName());
                });
                if (StringUtils.hasText((String)recordDO.getBusinessObjectCode())) {
                    detailVO.setBusinessObjectName(this.businessObjectRepoProc.getName(recordDO.getBusinessObjectCode()));
                }
                if (StringUtils.hasText((String)recordDO.getAppCode())) {
                    detailVO.setAppName(this.appRepoProc.getNameByCode(recordDO.getAppCode()));
                }
            }
            return null;
        });
        if (StringUtils.hasText((String)recordDO.getBusinessFields())) {
            detailVO.setBusinessFieldsList(Arrays.asList(recordDO.getBusinessFields().split(",")));
        }
        detailVO.setBusinessParamsMap((Map)JSONUtil.json2Obj((String)recordDO.getBusinessParams(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        detailVO.setSqlParamsMap((Map)JSONUtil.json2Obj((String)recordDO.getSqlParams(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        return ApiResult.ok((Object)detailVO);
    }
}

